/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.Log;
import ca.uhn.hl7v2.LogException;
import ca.uhn.hl7v2.util.Status;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class FileLog
extends Log {
    BufferedWriter exceptionWriter;
    BufferedWriter statusWriter;
    int currentDay = -1;
    private String prefix;

    protected FileLog() throws LogException {
        this.openLogs();
    }

    private void openLogs() throws LogException {
        this.prefix = System.getProperty("ca.uhn.hl7v2.log.name");
        if (this.prefix == null || this.prefix.equals("")) {
            this.prefix = "hl7";
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(System.currentTimeMillis()));
        this.currentDay = cal.get(5);
        String date = DateFormat.getDateInstance(2).format(cal.getTime());
        Status.writeStatus("Setting current log date to " + date);
        String exceptionLogFileName = String.valueOf(this.prefix) + "_exception_" + date + ".log";
        String statusLogFileName = String.valueOf(this.prefix) + "_status_" + date + ".log";
        try {
            this.exceptionWriter = new BufferedWriter(new FileWriter(exceptionLogFileName, true));
        }
        catch (IOException ioe) {
            throw new LogException("Can't open writer to exception log file " + exceptionLogFileName);
        }
        try {
            this.statusWriter = new BufferedWriter(new FileWriter(statusLogFileName, true));
        }
        catch (IOException ioe) {
            throw new LogException("Can't open writer to status log file " + statusLogFileName);
        }
    }

    private void maybeNewFile() throws LogException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(System.currentTimeMillis()));
        if (cal.get(5) != this.currentDay) {
            this.openLogs();
        }
    }

    public synchronized void log(Exception e, String message) throws LogException {
        System.out.println("FileLog: logging exception");
        if (e == null) {
            throw new LogException("Can't log null exception");
        }
        this.maybeNewFile();
        try {
            this.exceptionWriter.write(this.getCurrentTime());
            this.exceptionWriter.write("\t");
            this.exceptionWriter.write(e.getClass().getName());
            this.exceptionWriter.write("\t");
            this.exceptionWriter.write(e.getMessage() == null ? "" : e.getMessage());
            this.exceptionWriter.write("\t");
            if (message != null) {
                this.exceptionWriter.write(message);
            }
            this.exceptionWriter.write("\r\n");
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            this.exceptionWriter.write(stackTraceWriter.toString());
            this.exceptionWriter.write("\r\n");
            this.exceptionWriter.flush();
        }
        catch (IOException ioe) {
            throw new LogException("Can't write to exception log: " + ioe.toString());
        }
    }

    public synchronized void log(String status) throws LogException {
        this.maybeNewFile();
        try {
            this.statusWriter.write(this.getCurrentTime());
            this.statusWriter.write("\t");
            this.statusWriter.write(status);
            this.statusWriter.write("\r\n");
            this.statusWriter.flush();
        }
        catch (IOException ioe) {
            throw new LogException("Can't write to status log: " + ioe.getMessage());
        }
    }

    public String getDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append("HL7 exceptions and status messages are being logged by a FileLog object.  ");
        desc.append("Exceptions are being logged to files beginning ./");
        desc.append(this.prefix);
        desc.append("_exceptions and status messages are being logged to files beginning ./");
        desc.append(this.prefix);
        desc.append("_status. ");
        return desc.toString();
    }

    private String getCurrentTime() {
        return DateFormat.getDateTimeInstance().format(new Date());
    }
}

