/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.docbundle.BundleResourceManagerBackend;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;

public class MemoryDocumentBundle
implements WriteableDocumentBundle {
    private static final Log logger = LogFactory.getLog(MemoryDocumentBundle.class);
    private ZipRepository zipRepository = new ZipRepository();
    private MemoryDocumentMetaData metaData = new MemoryDocumentMetaData();
    private ResourceKey bundleKey;
    private ResourceManager resourceManager;

    public MemoryDocumentBundle() {
        this(null);
    }

    public MemoryDocumentBundle(ResourceKey parent) {
        ResourceManager defaultResourceManager = new ResourceManager();
        BundleResourceManagerBackend backend = new BundleResourceManagerBackend((Repository)this.zipRepository, defaultResourceManager.getBackend(), parent);
        this.bundleKey = backend.getBundleMainKey();
        this.resourceManager = new ResourceManager(defaultResourceManager, (ResourceManagerBackend)backend);
    }

    public ResourceKey getBundleMainKey() {
        return this.bundleKey;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public OutputStream createEntry(String path, String mimetype) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        if (mimetype == null) {
            throw new NullPointerException("Invalid Bundle: There is no mime-type for entry " + path);
        }
        String[] name = RepositoryUtilities.splitPath((String)path, (String)"/");
        try {
            ContentItem contentItem = RepositoryUtilities.createItem((Repository)this.zipRepository, (String[])name);
            this.metaData.setEntryMimeType(path, mimetype);
            return contentItem.getOutputStream();
        }
        catch (ContentIOException cioe) {
            logger.warn((Object)("Failed to create content item " + path), (Throwable)cioe);
            throw new IOException("Failed to create content item " + path);
        }
    }

    @Override
    public WriteableDocumentMetaData getWriteableDocumentMetaData() {
        return this.metaData;
    }

    @Override
    public DocumentMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void createDirectoryEntry(String name, String mimeType) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (mimeType == null) {
            throw new NullPointerException();
        }
        try {
            RepositoryUtilities.createLocation((Repository)this.zipRepository, (String[])RepositoryUtilities.splitPath((String)name, (String)"/"));
            if (!(name.length() > 0 && name.charAt(name.length() - 1) == '/')) {
                this.metaData.setEntryMimeType(name + '/', mimeType);
            } else {
                this.metaData.setEntryMimeType(name, mimeType);
            }
        }
        catch (ContentIOException e) {
            throw new IOException("Failed to create content-location " + name);
        }
    }

    @Override
    public boolean isEntryExists(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
        try {
            return RepositoryUtilities.isExistsEntity((Repository)this.zipRepository, (String[])splitName);
        }
        catch (ContentIOException e) {
            return false;
        }
    }

    @Override
    public boolean isEntryReadable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
            ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.zipRepository, (String[])splitName);
            return contentEntity instanceof ContentItem;
        }
        catch (ContentIOException cioe) {
            return false;
        }
    }

    @Override
    public InputStream getEntryAsStream(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
            ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.zipRepository, (String[])splitName);
            if (contentEntity instanceof ContentItem) {
                ContentItem contentItem = (ContentItem)contentEntity;
                return contentItem.getInputStream();
            }
        }
        catch (ContentIOException cioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to lookup entry for entry " + name), (Throwable)cioe);
            }
            throw new IOException("Failure while looking up the stream: " + (Object)((Object)cioe));
        }
        throw new IOException("No such stream: " + name);
    }

    @Override
    public String getEntryMimeType(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String definedMimeType = this.metaData.getEntryMimeType(name);
        if (definedMimeType != null) {
            return definedMimeType;
        }
        try {
            String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
            ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.zipRepository, (String[])splitName);
            if (contentEntity instanceof ContentItem) {
                ContentItem contentItem = (ContentItem)contentEntity;
                return contentItem.getMimeType();
            }
            return "";
        }
        catch (ContentIOException cioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to lookup entry mime-type for entry " + name), (Throwable)cioe);
            }
            return null;
        }
    }

    @Override
    public boolean removeEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
            ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.zipRepository, (String[])splitName);
            if (contentEntity == null) {
                return false;
            }
            if (contentEntity instanceof ContentItem) {
                if (contentEntity.delete()) {
                    this.metaData.removeEntry(name);
                    return true;
                }
            } else if (contentEntity.delete()) {
                String[] entryNames = this.metaData.getManifestEntryNames();
                for (int i = 0; i < entryNames.length; ++i) {
                    String entryName = entryNames[i];
                    if (!entryName.startsWith(name)) continue;
                    this.metaData.removeEntry(entryName);
                }
                return true;
            }
        }
        catch (ContentIOException cioe) {
            return false;
        }
        return false;
    }

    @Override
    public ResourceKey createResourceKey(String entryName, Map factoryParameters) throws ResourceKeyCreationException {
        if (entryName == null) {
            throw new NullPointerException();
        }
        ResourceKey bundleKey = this.getBundleMainKey().getParent();
        ResourceBundleLoader o = (ResourceBundleLoader)bundleKey.getFactoryParameters().get(new FactoryParameterKey("repository-loader"));
        if (o == null) {
            throw new ResourceKeyCreationException("Unable to create a inner-bundle key, no loader available.");
        }
        return o.deriveKey(this.getBundleMainKey(), entryName, factoryParameters);
    }

    @Override
    public ResourceKey getBundleKey() {
        return this.getBundleMainKey();
    }

    @Override
    public boolean isEmbeddedKey(ResourceKey resourceKey) {
        return resourceKey != null && this.getBundleMainKey().getParent().equals((Object)resourceKey.getParent());
    }
}

