/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata;

import java.io.Serializable;
import java.util.Map;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleMetaData;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultBundleMetaData
implements BundleMetaData,
Serializable,
Cloneable {
    private AttributeMap<Object> attributeMap = new AttributeMap();
    private static final long serialVersionUID = -3626983495621673501L;

    public DefaultBundleMetaData() {
    }

    public DefaultBundleMetaData(BundleMetaData metaData) {
        this();
        if (metaData != null) {
            String[] namespaces = metaData.getNamespaces();
            for (int namespaceIdx = 0; namespaceIdx < namespaces.length; ++namespaceIdx) {
                String namespace = namespaces[namespaceIdx];
                String[] names = metaData.getNames(namespace);
                for (int namesIdx = 0; namesIdx < names.length; ++namesIdx) {
                    String name = names[namesIdx];
                    this.attributeMap.setAttribute(namespace, name, metaData.getBundleAttribute(namespace, name));
                }
            }
        }
    }

    public void putBundleAttribute(String namespace, String attributeName, Object value) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (attributeName == null) {
            throw new NullPointerException();
        }
        this.attributeMap.setAttribute(namespace, attributeName, value);
    }

    @Override
    public Object getBundleAttribute(String namespace, String attributeName) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (attributeName == null) {
            throw new NullPointerException();
        }
        return this.attributeMap.getAttribute(namespace, attributeName);
    }

    @Override
    public String[] getNamespaces() {
        return this.attributeMap.getNameSpaces();
    }

    @Override
    public String[] getNames(String namespace) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        Map map = this.attributeMap.getAttributes(namespace);
        return map.keySet().toArray(new String[map.size()]);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultBundleMetaData metaData = (DefaultBundleMetaData)super.clone();
        metaData.attributeMap = this.attributeMap.clone();
        return metaData;
    }
}

