/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;

@InterfaceAudience.LimitedPrivate(value={"Sql standard authorization plugin"})
public class AuthorizationUtils {
    public static HivePrincipal.HivePrincipalType getHivePrincipalType(PrincipalType type) throws HiveException {
        if (type == null) {
            return null;
        }
        switch (type) {
            case USER: {
                return HivePrincipal.HivePrincipalType.USER;
            }
            case ROLE: {
                return HivePrincipal.HivePrincipalType.ROLE;
            }
            case GROUP: {
                return HivePrincipal.HivePrincipalType.GROUP;
            }
        }
        throw new AssertionError((Object)"Unsupported authorization type specified");
    }

    public static HivePrivilegeObject.HivePrivilegeObjectType getHivePrivilegeObjectType(Entity.Type type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
            case LOCAL_DIR: {
                return HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI;
            }
            case DFS_DIR: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                return HivePrivilegeObject.HivePrivilegeObjectType.PARTITION;
            }
            case FUNCTION: {
                return HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION;
            }
        }
        return null;
    }

    public static HivePrivilegeObject.HivePrivilegeObjectType getPrivObjectType(PrivilegeObjectDesc privSubjectDesc) {
        if (privSubjectDesc.getObject() == null) {
            return null;
        }
        return privSubjectDesc.getTable() ? HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW : HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
    }

    public static List<HivePrivilege> getHivePrivileges(List<PrivilegeDesc> privileges) {
        ArrayList<HivePrivilege> hivePrivileges = new ArrayList<HivePrivilege>();
        for (PrivilegeDesc privilege : privileges) {
            Privilege priv = privilege.getPrivilege();
            hivePrivileges.add(new HivePrivilege(priv.toString(), privilege.getColumns(), priv.getScopeList()));
        }
        return hivePrivileges;
    }

    public static List<HivePrincipal> getHivePrincipals(List<PrincipalDesc> principals) throws HiveException {
        ArrayList<HivePrincipal> hivePrincipals = new ArrayList<HivePrincipal>();
        for (PrincipalDesc principal : principals) {
            hivePrincipals.add(AuthorizationUtils.getHivePrincipal(principal));
        }
        return hivePrincipals;
    }

    public static HivePrincipal getHivePrincipal(PrincipalDesc principal) throws HiveException {
        if (principal == null) {
            return null;
        }
        return AuthorizationUtils.getHivePrincipal(principal.getName(), principal.getType());
    }

    public static HivePrincipal getHivePrincipal(String name, PrincipalType type) throws HiveException {
        return new HivePrincipal(name, AuthorizationUtils.getHivePrincipalType(type));
    }

    public static List<HivePrivilegeInfo> getPrivilegeInfos(List<HiveObjectPrivilege> privs) throws HiveException {
        ArrayList<HivePrivilegeInfo> hivePrivs = new ArrayList<HivePrivilegeInfo>();
        for (HiveObjectPrivilege priv : privs) {
            PrivilegeGrantInfo grantorInfo = priv.getGrantInfo();
            HiveObjectRef privObject = priv.getHiveObject();
            HivePrincipal hivePrincipal = AuthorizationUtils.getHivePrincipal(priv.getPrincipalName(), priv.getPrincipalType());
            HivePrincipal grantor = AuthorizationUtils.getHivePrincipal(grantorInfo.getGrantor(), grantorInfo.getGrantorType());
            HivePrivilegeObject object = AuthorizationUtils.getHiveObjectRef(privObject);
            HivePrivilege privilege = new HivePrivilege(grantorInfo.getPrivilege(), null);
            hivePrivs.add(new HivePrivilegeInfo(hivePrincipal, privilege, object, grantor, grantorInfo.isGrantOption(), grantorInfo.getCreateTime()));
        }
        return hivePrivs;
    }

    public static HivePrivilegeObject getHiveObjectRef(HiveObjectRef privObj) throws HiveException {
        if (privObj == null) {
            return null;
        }
        HivePrivilegeObject.HivePrivilegeObjectType objType = AuthorizationUtils.getHiveObjType(privObj.getObjectType());
        return new HivePrivilegeObject(objType, privObj.getDbName(), privObj.getObjectName(), privObj.getPartValues(), privObj.getColumnName());
    }

    public static HivePrivilegeObject getHivePrivilegeObject(PrivilegeObjectDesc privSubjectDesc) throws HiveException {
        String[] dbTable;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = null;
        ArrayList<String> partSpec = null;
        List<String> columns = null;
        if (privSubjectDesc == null) {
            dbTable = new String[]{null, null};
        } else {
            dbTable = privSubjectDesc.getTable() ? Utilities.getDbTableName(privSubjectDesc.getObject()) : new String[]{privSubjectDesc.getObject(), null};
            if (privSubjectDesc.getPartSpec() != null) {
                partSpec = new ArrayList<String>(privSubjectDesc.getPartSpec().values());
            }
            columns = privSubjectDesc.getColumns();
            objectType = AuthorizationUtils.getPrivObjectType(privSubjectDesc);
        }
        return new HivePrivilegeObject(objectType, dbTable[0], dbTable[1], partSpec, columns, null);
    }

    public static PrincipalType getThriftPrincipalType(HivePrincipal.HivePrincipalType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case USER: {
                return PrincipalType.USER;
            }
            case GROUP: {
                return PrincipalType.GROUP;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new AssertionError((Object)("Invalid principal type " + (Object)((Object)type)));
    }

    public static PrivilegeGrantInfo getThriftPrivilegeGrantInfo(HivePrivilege privilege, HivePrincipal grantorPrincipal, boolean grantOption, int grantTime) throws HiveException {
        return new PrivilegeGrantInfo(privilege.getName(), grantTime, grantorPrincipal.getName(), AuthorizationUtils.getThriftPrincipalType(grantorPrincipal.getType()), grantOption);
    }

    public static HiveObjectType getThriftHiveObjType(HivePrivilegeObject.HivePrivilegeObjectType type) throws HiveException {
        if (type == null) {
            return null;
        }
        switch (type) {
            case GLOBAL: {
                return HiveObjectType.GLOBAL;
            }
            case DATABASE: {
                return HiveObjectType.DATABASE;
            }
            case TABLE_OR_VIEW: {
                return HiveObjectType.TABLE;
            }
            case PARTITION: {
                return HiveObjectType.PARTITION;
            }
            case COLUMN: {
                return HiveObjectType.COLUMN;
            }
        }
        throw new HiveException("Unsupported type " + (Object)((Object)type));
    }

    private static HivePrivilegeObject.HivePrivilegeObjectType getHiveObjType(HiveObjectType type) throws HiveException {
        if (type == null) {
            return null;
        }
        switch (type) {
            case GLOBAL: {
                if (SessionState.get().getAuthorizationMode() == SessionState.AuthorizationMode.V2) {
                    throw new HiveException(ErrorMsg.UNSUPPORTED_AUTHORIZATION_RESOURCE_TYPE_GLOBAL);
                }
                return HivePrivilegeObject.HivePrivilegeObjectType.GLOBAL;
            }
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
            case PARTITION: {
                return HivePrivilegeObject.HivePrivilegeObjectType.PARTITION;
            }
            case COLUMN: {
                if (SessionState.get().getAuthorizationMode() == SessionState.AuthorizationMode.V2) {
                    throw new HiveException(ErrorMsg.UNSUPPORTED_AUTHORIZATION_RESOURCE_TYPE_COLUMN);
                }
                return HivePrivilegeObject.HivePrivilegeObjectType.COLUMN;
            }
        }
        throw new AssertionError((Object)("Unsupported type " + type));
    }

    public static HiveObjectRef getThriftHiveObjectRef(HivePrivilegeObject privObj) throws HiveException {
        if (privObj == null) {
            return null;
        }
        HiveObjectType objType = AuthorizationUtils.getThriftHiveObjType(privObj.getType());
        return new HiveObjectRef(objType, privObj.getDbname(), privObj.getObjectName(), null, null);
    }

    public static HivePrivilegeObject.HivePrivObjectActionType getActionType(Entity privObject) {
        HivePrivilegeObject.HivePrivObjectActionType actionType = HivePrivilegeObject.HivePrivObjectActionType.OTHER;
        if (privObject instanceof WriteEntity) {
            WriteEntity.WriteType writeType = ((WriteEntity)privObject).getWriteType();
            switch (writeType) {
                case INSERT: {
                    return HivePrivilegeObject.HivePrivObjectActionType.INSERT;
                }
                case INSERT_OVERWRITE: {
                    return HivePrivilegeObject.HivePrivObjectActionType.INSERT_OVERWRITE;
                }
                case UPDATE: {
                    return HivePrivilegeObject.HivePrivObjectActionType.UPDATE;
                }
                case DELETE: {
                    return HivePrivilegeObject.HivePrivObjectActionType.DELETE;
                }
            }
        }
        return actionType;
    }
}

