/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHub {
    private static final HapiLog log = HapiLogFactory.getHapiLog(ConnectionHub.class);
    private static ConnectionHub instance = null;
    private HashMap connections = new HashMap(20);
    private HashMap sockets = new HashMap(20);
    private HashMap numRefs = new HashMap(20);

    private ConnectionHub() {
    }

    public static synchronized ConnectionHub getInstance() {
        if (instance == null) {
            instance = new ConnectionHub();
        }
        return instance;
    }

    public Connection attach(String host, int port, Parser parser, Class<? extends LowerLayerProtocol> llpClass) throws HL7Exception {
        Connection conn = this.getExisting(host, port, parser.getClass(), llpClass);
        if (conn != null && !conn.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug("Discarding connection which appears to be closed. Remote addr: " + conn.getRemoteAddress());
            }
            this.close(conn);
            conn = null;
        }
        if (conn == null) {
            try {
                LowerLayerProtocol llp = llpClass.newInstance();
                conn = this.connect(host, port, parser, llp);
            }
            catch (ClassCastException e) {
                throw new HL7Exception("ClassCastException - need a LowerLayerProtocol class to get an Inititator", 207, e);
            }
            catch (Exception e) {
                throw new HL7Exception("Can't connect to " + host + " port " + port + ": " + e.getClass().getName() + ": " + e.getMessage(), 207, e);
            }
        }
        this.incrementRefs(conn);
        return conn;
    }

    private Connection getExisting(String host, int port, Class parserClass, Class llpClass) {
        Connection existing = null;
        Object o = this.connections.get(ConnectionHub.makeHashKey(host, port, parserClass, llpClass));
        if (o != null) {
            existing = (Connection)o;
        }
        return existing;
    }

    private Connection connect(String host, int port, Parser parser, LowerLayerProtocol llp) throws UnknownHostException, IOException, LLPException {
        Socket s = new Socket(host, port);
        Connection i = new Connection(parser, llp, s);
        this.connections.put(ConnectionHub.makeHashKey(host, port, parser.getClass(), llp.getClass()), i);
        this.sockets.put(ConnectionHub.makeHashKey(host, port, parser.getClass(), llp.getClass()), s);
        return i;
    }

    public void detach(Connection c) {
        int refs = this.decrementRefs(c);
        if (refs == 0) {
            this.close(c);
        }
    }

    public void discard(Connection c) {
        this.close(c);
    }

    private void close(Connection c) {
        c.close();
        Iterator keys = this.connections.keySet().iterator();
        boolean removed = false;
        while (keys.hasNext() && !removed) {
            Object key = keys.next();
            Object val = this.connections.get(key);
            if (val.hashCode() != c.hashCode()) continue;
            this.connections.remove(key);
            this.numRefs.remove(new Integer(c.hashCode()));
            removed = true;
        }
    }

    private int incrementRefs(Connection c) {
        return this.updateRefs(c, 1);
    }

    private int decrementRefs(Connection c) {
        return this.updateRefs(c, -1);
    }

    private int updateRefs(Connection c, int change) {
        Integer hashCode = new Integer(c.hashCode());
        Object o = this.numRefs.get(hashCode);
        int existingRefs = 0;
        if (o != null) {
            existingRefs = (Integer)o;
        }
        Integer newRefs = new Integer(existingRefs + change);
        this.numRefs.put(hashCode, newRefs);
        return newRefs;
    }

    private static String makeHashKey(String IP, int port, Class parserClass, Class llpClass) {
        StringBuffer key = new StringBuffer();
        key.append(IP);
        key.append(":");
        key.append(port);
        key.append(":");
        key.append(parserClass.getName());
        key.append(":");
        key.append(llpClass.getName());
        return key.toString();
    }
}

