/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.primitive.CommonTS;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.util.MessageIDGenerator;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

public class DefaultApplication
implements Application {
    private static final HapiLog log = HapiLogFactory.getHapiLog(DefaultApplication.class);

    public boolean canProcess(Message in) {
        return true;
    }

    public Message processMessage(Message in) throws ApplicationException {
        Message out = null;
        try {
            out = DefaultApplication.makeACK((Segment)in.get("MSH"));
            this.fillDetails(out);
        }
        catch (Exception e) {
            throw new ApplicationException("Couldn't create response message: " + e.getMessage());
        }
        return out;
    }

    public void fillDetails(Message ack) throws ApplicationException {
        try {
            Segment msa = (Segment)ack.get("MSA");
            Terser.set(msa, 1, 0, 1, 1, "AR");
            Terser.set(msa, 3, 0, 1, 1, "No appropriate destination could be found to which this message could be routed.");
            Structure s = ack.get("ERR");
            if (s != null) {
                Segment err = (Segment)s;
                Terser.set(err, 1, 0, 4, 1, "207");
                Terser.set(err, 1, 0, 4, 2, "Application Internal Error");
                Terser.set(err, 1, 0, 4, 3, "HL70357");
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Error trying to create Application Reject message: " + e.getMessage());
        }
    }

    public static Message makeACK(Segment inboundHeader) throws HL7Exception, IOException {
        if (!inboundHeader.getName().equals("MSH")) {
            throw new HL7Exception("Need an MSH segment to create a response ACK (got " + inboundHeader.getName() + ")");
        }
        String version = null;
        try {
            version = Terser.get(inboundHeader, 12, 0, 1, 1);
        }
        catch (HL7Exception hL7Exception) {
            // empty catch block
        }
        if (version == null) {
            version = "2.4";
        }
        String ackClassName = String.valueOf(DefaultModelClassFactory.getVersionPackageName(version)) + "message.ACK";
        Message out = null;
        try {
            Class<?> ackClass = Class.forName(ackClassName);
            out = (Message)ackClass.newInstance();
        }
        catch (Exception e) {
            throw new HL7Exception("Can't instantiate ACK of class " + ackClassName + ": " + e.getClass().getName());
        }
        Terser terser = new Terser(out);
        Segment outHeader = (Segment)out.get("MSH");
        DefaultApplication.fillResponseHeader(inboundHeader, outHeader);
        terser.set("/MSH-9", "ACK");
        terser.set("/MSH-12", version);
        terser.set("/MSA-1", "AA");
        terser.set("/MSA-2", Terser.get(inboundHeader, 10, 0, 1, 1));
        return out;
    }

    public static void fillResponseHeader(Segment inbound, Segment outbound) throws HL7Exception, IOException {
        if (!inbound.getName().equals("MSH") || !outbound.getName().equals("MSH")) {
            throw new HL7Exception("Need MSH segments.  Got " + inbound.getName() + " and " + outbound.getName());
        }
        String encChars = Terser.get(inbound, 2, 0, 1, 1);
        String fieldSep = Terser.get(inbound, 1, 0, 1, 1);
        String procID = Terser.get(inbound, 11, 0, 1, 1);
        Terser.set(outbound, 2, 0, 1, 1, encChars);
        Terser.set(outbound, 1, 0, 1, 1, fieldSep);
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        Terser.set(outbound, 7, 0, 1, 1, CommonTS.toHl7TSFormat(now));
        Terser.set(outbound, 10, 0, 1, 1, MessageIDGenerator.getInstance().getNewID());
        Terser.set(outbound, 11, 0, 1, 1, procID);
    }
}

