/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionListener;
import ca.uhn.hl7v2.app.MessageTypeRouter;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class HL7Service
implements Runnable {
    private Vector connections = new Vector();
    private boolean keepRunning;
    protected Parser parser;
    protected LowerLayerProtocol llp;
    private MessageTypeRouter router;
    private ArrayList listeners = new ArrayList();

    public HL7Service(Parser parser, LowerLayerProtocol llp) {
        this.parser = parser;
        this.llp = llp;
        this.router = new MessageTypeRouter();
    }

    public abstract void run();

    protected boolean keepRunning() {
        return this.keepRunning;
    }

    public boolean isRunning() {
        return this.keepRunning;
    }

    public void start() {
        Thread thd = new Thread(this);
        this.keepRunning = true;
        thd.start();
        Thread cleaner = new Thread(new ConnectionCleaner(this));
        cleaner.start();
    }

    public void stop() {
        this.keepRunning = false;
        int i = 0;
        while (i < this.connections.size()) {
            ((Connection)this.connections.get(i)).close();
            ++i;
        }
    }

    public synchronized void newConnection(Connection c) {
        c.getResponder().registerApplication(this.router);
        this.connections.add(c);
        this.notifyListeners(c);
    }

    private synchronized void discardConnection(Connection c) {
        this.connections.remove(c);
        this.notifyListeners(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getRemoteConnection(String IP) {
        Connection conn = null;
        while (conn == null) {
            int c = 0;
            HL7Service hL7Service = this;
            synchronized (hL7Service) {
                while (conn == null && c < this.connections.size()) {
                    Connection nextConn = (Connection)this.connections.get(c);
                    if (nextConn.getRemoteAddress().getHostAddress().equals(IP)) {
                        conn = nextConn;
                    }
                    ++c;
                }
            }
            if (conn != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return conn;
    }

    public synchronized Vector getRemoteConnections() {
        return this.connections;
    }

    public synchronized void registerConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(Connection c) {
        int i = 0;
        while (i < this.listeners.size()) {
            ConnectionListener cl = (ConnectionListener)this.listeners.get(i);
            if (c.isOpen()) {
                cl.connectionReceived(c);
            } else {
                cl.connectionDiscarded(c);
            }
            ++i;
        }
    }

    public synchronized void registerApplication(String messageType, String triggerEvent, Application handler) {
        this.router.registerApplication(messageType, triggerEvent, handler);
    }

    public void loadApplicationsFromFile(File f) throws IOException, HL7Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedReader in = new BufferedReader(new FileReader(f));
        String line = null;
        while ((line = in.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, "\t", false);
            String type = null;
            String event = null;
            String className = null;
            if (!tok.hasMoreTokens()) continue;
            try {
                type = tok.nextToken();
                event = tok.nextToken();
                className = tok.nextToken();
            }
            catch (NoSuchElementException ne) {
                throw new HL7Exception("Can't register applications from file " + f.getName() + ". The line '" + line + "' is not of the form: message_type [tab] trigger_event [tab] application_class.", 207);
            }
            Class<?> appClass = Class.forName(className);
            Object appObject = appClass.newInstance();
            Application app = null;
            try {
                app = (Application)appObject;
            }
            catch (ClassCastException cce) {
                throw new HL7Exception("The specified class, " + appClass.getName() + ", doesn't implement Application.", 207);
            }
            this.registerApplication(type, event, app);
        }
    }

    private class ConnectionCleaner
    implements Runnable {
        HL7Service service;

        public ConnectionCleaner(HL7Service service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (HL7Service.this.keepRunning()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                HL7Service hL7Service = this.service;
                synchronized (hL7Service) {
                    Iterator it = this.service.getRemoteConnections().iterator();
                    while (it.hasNext()) {
                        Connection conn = (Connection)it.next();
                        if (conn.isOpen()) continue;
                        it.remove();
                        this.service.notifyListeners(conn);
                    }
                }
            }
        }
    }
}

