/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.spec;

import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.spec.Conformance;
import ca.uhn.hl7v2.conf.spec.Encoding;
import ca.uhn.hl7v2.conf.spec.message.StaticDef;
import ca.uhn.hl7v2.conf.spec.usecase.UseCase;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class RuntimeProfile {
    private String impNote;
    private UseCase useCase;
    private Conformance conformance;
    private Encoding[] encodings;
    private StaticDef StaticDef;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private StaticDef message;
    private String specName;
    private String orgName;
    private String HL7Version;
    private String specVersion;
    private String status;
    private String role;
    private String HL7OID;
    private String conformanceType;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public String getImpNote() {
        return this.impNote;
    }

    public void setImpNote(String impNote) throws ProfileException {
        String oldImpNote = this.impNote;
        try {
            this.vetoableChangeSupport.fireVetoableChange("impNote", oldImpNote, impNote);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.impNote = impNote;
        this.propertyChangeSupport.firePropertyChange("impNote", oldImpNote, impNote);
    }

    public UseCase getUseCase() {
        return this.useCase;
    }

    public void setUseCase(UseCase useCase) throws ProfileException {
        UseCase oldUseCase = this.useCase;
        try {
            this.vetoableChangeSupport.fireVetoableChange("useCase", oldUseCase, useCase);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.useCase = useCase;
        this.propertyChangeSupport.firePropertyChange("useCase", oldUseCase, useCase);
    }

    public Conformance getConformance() {
        return this.conformance;
    }

    public void setConformance(Conformance conformance) throws ProfileException {
        Conformance oldConformance = this.conformance;
        try {
            this.vetoableChangeSupport.fireVetoableChange("conformance", oldConformance, conformance);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.conformance = conformance;
        this.propertyChangeSupport.firePropertyChange("conformance", oldConformance, conformance);
    }

    public Encoding getEncodings(int index) {
        return this.encodings[index];
    }

    public void setEncodings(int index, Encoding encodings) throws ProfileException {
        Encoding oldEncodings = this.encodings[index];
        this.encodings[index] = encodings;
        try {
            this.vetoableChangeSupport.fireVetoableChange("encodings", null, null);
        }
        catch (PropertyVetoException vetoException) {
            this.encodings[index] = oldEncodings;
            throw new ProfileException(null, vetoException);
        }
        this.propertyChangeSupport.firePropertyChange("encodings", null, null);
    }

    public StaticDef getMessage() {
        return this.message;
    }

    public void setMessage(StaticDef message) throws ProfileException {
        StaticDef oldMessage = this.message;
        try {
            this.vetoableChangeSupport.fireVetoableChange("message", oldMessage, message);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.message = message;
        this.propertyChangeSupport.firePropertyChange("message", oldMessage, message);
    }

    public String getSpecName() {
        return this.specName;
    }

    public void setSpecName(String specName) throws ProfileException {
        String oldSpecName = this.specName;
        try {
            this.vetoableChangeSupport.fireVetoableChange("specName", oldSpecName, specName);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.specName = specName;
        this.propertyChangeSupport.firePropertyChange("specName", oldSpecName, specName);
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) throws ProfileException {
        String oldOrgName = this.orgName;
        try {
            this.vetoableChangeSupport.fireVetoableChange("orgName", oldOrgName, orgName);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.orgName = orgName;
        this.propertyChangeSupport.firePropertyChange("orgName", oldOrgName, orgName);
    }

    public String getHL7Version() {
        return this.HL7Version;
    }

    public void setHL7Version(String HL7Version) throws ProfileException {
        String oldHL7Version = this.HL7Version;
        try {
            this.vetoableChangeSupport.fireVetoableChange("HL7Version", oldHL7Version, HL7Version);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.HL7Version = HL7Version;
        this.propertyChangeSupport.firePropertyChange("HL7Version", oldHL7Version, HL7Version);
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) throws ProfileException {
        String oldSpecVersion = this.specVersion;
        try {
            this.vetoableChangeSupport.fireVetoableChange("specVersion", oldSpecVersion, specVersion);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.specVersion = specVersion;
        this.propertyChangeSupport.firePropertyChange("specVersion", oldSpecVersion, specVersion);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) throws ProfileException {
        String oldStatus = this.status;
        try {
            this.vetoableChangeSupport.fireVetoableChange("status", oldStatus, status);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.status = status;
        this.propertyChangeSupport.firePropertyChange("status", oldStatus, status);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) throws ProfileException {
        String oldRole = this.role;
        try {
            this.vetoableChangeSupport.fireVetoableChange("role", oldRole, role);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.role = role;
        this.propertyChangeSupport.firePropertyChange("role", oldRole, role);
    }

    public String getHL7OID() {
        return this.HL7OID;
    }

    public void setHL7OID(String HL7OID) throws ProfileException {
        String oldHL7OID = this.HL7OID;
        try {
            this.vetoableChangeSupport.fireVetoableChange("HL7OID", oldHL7OID, HL7OID);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.HL7OID = HL7OID;
        this.propertyChangeSupport.firePropertyChange("HL7OID", oldHL7OID, HL7OID);
    }

    public String getConformanceType() {
        return this.conformanceType;
    }

    public void setConformanceType(String conformanceType) throws ProfileException {
        String oldConformanceType = this.conformanceType;
        try {
            this.vetoableChangeSupport.fireVetoableChange("conformanceType", oldConformanceType, conformanceType);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.conformanceType = conformanceType;
        this.propertyChangeSupport.firePropertyChange("conformanceType", oldConformanceType, conformanceType);
    }
}

