/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.HarFs;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.util.Times;

public final class LogToolUtils {
    public static final String CONTAINER_ON_NODE_PATTERN = "Container: %s on %s";

    private LogToolUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContainerLogMeta> getContainerLogMetaFromRemoteFS(Configuration conf, ApplicationId appId, String containerIdStr, String nodeId, String appOwner) throws IOException {
        ArrayList<ContainerLogMeta> containersLogMeta = new ArrayList<ContainerLogMeta>();
        boolean getAllContainers = containerIdStr == null;
        String nodeIdStr = nodeId == null ? null : LogAggregationUtils.getNodeString(nodeId);
        RemoteIterator<FileStatus> nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(conf, appId, appOwner);
        if (nodeFiles == null) {
            throw new IOException("There is no available log fils for application:" + appId);
        }
        block5: while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            if (nodeIdStr != null && !thisNodeFile.getPath().getName().contains(nodeIdStr) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(conf, thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    if (getAllContainers || key.toString().equals(containerIdStr)) {
                        ContainerLogMeta containerLogMeta = new ContainerLogMeta(key.toString(), thisNodeFile.getPath().getName());
                        try {
                            while (true) {
                                Pair<String, String> logMeta = AggregatedLogFormat.LogReader.readContainerMetaDataAndSkipData(valueStream);
                                containerLogMeta.addLogMeta((String)logMeta.getFirst(), (String)logMeta.getSecond(), Times.format(thisNodeFile.getModificationTime()));
                            }
                        }
                        catch (EOFException eof) {
                            containersLogMeta.add(containerLogMeta);
                            if (!getAllContainers) continue block5;
                        }
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
        }
        return containersLogMeta;
    }

    public static void outputContainerLog(String containerId, String nodeId, String fileName, long fileLength, long outputSize, String lastModifiedTime, InputStream fis, OutputStream os, byte[] buf, ContainerLogAggregationType logType) throws IOException {
        boolean keepGoing;
        long toSkip = 0L;
        long totalBytesToRead = fileLength;
        long skipAfterRead = 0L;
        if (outputSize < 0L) {
            long absBytes = Math.abs(outputSize);
            if (absBytes < fileLength) {
                toSkip = fileLength - absBytes;
                totalBytesToRead = absBytes;
            }
            IOUtils.skipFully((InputStream)fis, (long)toSkip);
        } else if (outputSize < fileLength) {
            totalBytesToRead = outputSize;
            skipAfterRead = fileLength - outputSize;
        }
        long curRead = 0L;
        long pendingRead = totalBytesToRead - curRead;
        int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
        int len = fis.read(buf, 0, toRead);
        boolean bl = keepGoing = len != -1 && curRead < totalBytesToRead;
        if (keepGoing) {
            StringBuilder sb = new StringBuilder();
            String containerStr = String.format(CONTAINER_ON_NODE_PATTERN, containerId, nodeId);
            sb.append(containerStr + "\n");
            sb.append("LogAggregationType: " + (Object)((Object)logType) + "\n");
            sb.append(StringUtils.repeat((String)"=", (int)containerStr.length()) + "\n");
            sb.append("LogType:" + fileName + "\n");
            sb.append("LogLastModifiedTime:" + lastModifiedTime + "\n");
            sb.append("LogLength:" + Long.toString(fileLength) + "\n");
            sb.append("LogContents:\n");
            byte[] b = sb.toString().getBytes(Charset.forName("UTF-8"));
            os.write(b, 0, b.length);
        }
        while (keepGoing) {
            os.write(buf, 0, len);
            pendingRead = totalBytesToRead - (curRead += (long)len);
            toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            len = fis.read(buf, 0, toRead);
            keepGoing = len != -1 && curRead < totalBytesToRead;
        }
        IOUtils.skipFully((InputStream)fis, (long)skipAfterRead);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean outputAggregatedContainerLog(Configuration conf, ApplicationId appId, String appOwner, String containerId, String nodeId, String logFileName, long outputSize, OutputStream os, byte[] buf) throws IOException {
        findLogs = false;
        nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(conf, appId, appOwner);
        while (nodeFiles != null && nodeFiles.hasNext()) {
            block12: {
                thisNodeFile = (FileStatus)nodeFiles.next();
                nodeName = thisNodeFile.getPath().getName();
                if (nodeName.equals(appId + ".har")) {
                    p = new Path("har:///" + thisNodeFile.getPath().toUri().getRawPath());
                    nodeFiles = HarFs.get((URI)p.toUri(), (Configuration)conf).listStatusIterator(p);
                    continue;
                }
                if (nodeId != null && !nodeName.contains(LogAggregationUtils.getNodeString(nodeId)) || nodeName.endsWith(".tmp")) continue;
                reader = null;
                reader = new AggregatedLogFormat.LogReader(conf, thisNodeFile.getPath());
                key = new AggregatedLogFormat.LogKey();
                valueStream = reader.next(key);
                while (valueStream != null && !key.toString().equals(containerId)) {
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
                if (valueStream != null) break block12;
                if (reader == null) continue;
                reader.close();
                continue;
            }
            try {
                try {
                    block7: while (true) {
                        fileType = valueStream.readUTF();
                        fileLengthStr = valueStream.readUTF();
                        fileLength = Long.parseLong(fileLengthStr);
                        if (fileType.equalsIgnoreCase(logFileName)) {
                            LogToolUtils.outputContainerLog(containerId, nodeId, fileType, fileLength, outputSize, Times.format(thisNodeFile.getModificationTime()), valueStream, os, buf, ContainerLogAggregationType.AGGREGATED);
                            sb = new StringBuilder();
                            endOfFile = "End of LogType:" + fileType;
                            sb.append("\n" + endOfFile + "\n");
                            sb.append(StringUtils.repeat((String)"*", (int)(endOfFile.length() + 50)) + "\n\n");
                            b = sb.toString().getBytes(Charset.forName("UTF-8"));
                            os.write(b, 0, b.length);
                            findLogs = true;
                            continue;
                        }
                        totalSkipped = 0L;
                        currSkipped = 0L;
                        while (true) {
                            if (currSkipped != -1L && totalSkipped < fileLength) ** break;
                            continue block7;
                            currSkipped = valueStream.skip(fileLength - totalSkipped);
                            totalSkipped += currSkipped;
                        }
                        break;
                    }
                }
                catch (EOFException eof) {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Throwable var25_25) {
                if (reader != null) {
                    reader.close();
                }
                throw var25_25;
            }
        }
        os.flush();
        return findLogs;
    }
}

