/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Collections;
import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;

public class RolapCalculatedMember
extends RolapMemberBase {
    private final Formula formula;
    private Map<String, Annotation> annotationMap;
    private RolapCube baseCube;

    RolapCalculatedMember(RolapMember parentMember, RolapLevel level, String name, Formula formula) {
        super(parentMember, level, name, null, Member.MemberType.FORMULA);
        this.formula = formula;
        this.annotationMap = Collections.emptyMap();
    }

    @Override
    public int getSolveOrder() {
        Number solveOrder = this.formula.getSolveOrder();
        return solveOrder == null ? 0 : solveOrder.intValue();
    }

    @Override
    public Object getPropertyValue(String propertyName, boolean matchCase) {
        if (Util.equal(propertyName, Property.FORMULA.name, matchCase)) {
            return this.formula;
        }
        if (Util.equal(propertyName, Property.CHILDREN_CARDINALITY.name, matchCase)) {
            return 0;
        }
        return super.getPropertyValue(propertyName, matchCase);
    }

    @Override
    protected boolean computeCalculated(Member.MemberType memberType) {
        return true;
    }

    @Override
    public boolean isCalculatedInQuery() {
        String memberScope = (String)this.getPropertyValue(Property.MEMBER_SCOPE.name);
        return memberScope == null || memberScope.equals("QUERY");
    }

    @Override
    public Exp getExpression() {
        return this.formula.getExpression();
    }

    public Formula getFormula() {
        return this.formula;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    void setAnnotationMap(Map<String, Annotation> annotationMap) {
        assert (annotationMap != null);
        this.annotationMap = annotationMap;
    }

    public RolapCube getBaseCube() {
        return this.baseCube;
    }

    public void setBaseCube(RolapCube baseCube) {
        this.baseCube = baseCube;
    }
}

