/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.DialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class JdbcDialectFactory
implements DialectFactory {
    private final Dialect.DatabaseProduct databaseProduct;
    private final Constructor<? extends JdbcDialectImpl> constructor;

    public JdbcDialectFactory(Class<? extends JdbcDialectImpl> dialectClass, Dialect.DatabaseProduct databaseProduct) {
        this.databaseProduct = databaseProduct;
        try {
            this.constructor = dialectClass.getConstructor(Connection.class);
        }
        catch (NoSuchMethodException e) {
            throw Util.newError(e, "Class does not contain constructor 'public <init>(Connection connection)' required for subclasses of JdbcDialectImpl");
        }
    }

    public static Dialect createDialectHelper(DialectFactory factory, DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Must specify either dataSource or connection");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (connection == null) {
                throw new IllegalArgumentException();
            }
            Dialect dialect = factory.createDialect(dataSource, connection);
            Connection connection2 = connection;
            connection = null;
            connection2.close();
            Dialect dialect2 = dialect;
            return dialect2;
        }
        catch (SQLException e) {
            throw Util.newError(e, "Error while creating dialect");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Dialect createDialect(DataSource dataSource, Connection connection) {
        if (connection == null) {
            return JdbcDialectFactory.createDialectHelper(this, dataSource);
        }
        assert (connection != null);
        if (this.acceptsConnection(connection)) {
            try {
                return this.constructor.newInstance(connection);
            }
            catch (InstantiationException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
            catch (IllegalAccessException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
            catch (InvocationTargetException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
        return null;
    }

    protected boolean acceptsConnection(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String productName = metaData.getDatabaseProductName();
            String productVersion = metaData.getDatabaseProductVersion();
            Dialect.DatabaseProduct product = JdbcDialectImpl.getProduct(productName, productVersion);
            return product == this.databaseProduct;
        }
        catch (SQLException e) {
            throw Util.newError(e, "Error while instantiating dialect");
        }
    }
}

