/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.AclEntry;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.config.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class PentahoXml {
    Document document;
    private static final String ROOT_ELEMENT = "pentaho-system";
    private static final String AUDIT_DATE_FORMAT_XPATH = "pentaho-system/audit/auditDateFormat";
    private static final String AUDIT_LOG_FILE_XPATH = "pentaho-system/audit/auditLogFile";
    private static final String AUDIT_LOG_SEPARATOR_XPATH = "pentaho-system/audit/id_separator";
    private static final String DEFAULT_PARAMETER_FORM = "pentaho-system/default-parameter-xsl";
    private static final String LOG_FILE_XPATH = "pentaho-system/log-file";
    private static final String LOG_LEVEL_XPATH = "pentaho-system/log-level";
    private static final String SOLUTION_REPOSITORY_CACHE_SIZE_XPATH = "pentaho-system/solution-repository/cache-size";
    private static final String ACL_FILES_XPATH = "pentaho-system/acl-files";
    private static final String ADMIN_ROLE_XPATH = "pentaho-system/acl-voter/admin-role";
    private static final String ANONYMOUS_USER_XPATH = "pentaho-system/anonymous-authentication/anonymous-user";
    private static final String ANONYMOUS_ROLE_XPATH = "pentaho-system/anonymous-authentication/anonymous-role";
    private static final String ACL_ENTRY_XPATH = "pentaho-system/acl-publisher/default-acls/acl-entry";

    public PentahoXml(File pentahoXmlFile) throws IOException, DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromFile((File)pentahoXmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public PentahoXml(String xml) throws DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    public PentahoXml(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException(Messages.getInstance().getErrorString("PentahoXml.ERROR_0001_INVALID_ROOT_ELEMENT"));
        }
        this.document = doc;
    }

    public PentahoXml() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    public String getAuditDateFormat() {
        return this.getValue(AUDIT_DATE_FORMAT_XPATH);
    }

    public void setAuditDateFormat(String auditDateFormat) {
        this.setValue(AUDIT_DATE_FORMAT_XPATH, auditDateFormat);
    }

    public String getAuditLogFile() {
        return this.getValue(AUDIT_LOG_FILE_XPATH);
    }

    public void setAuditLogFile(String auditLogFile) {
        this.setValue(AUDIT_LOG_FILE_XPATH, auditLogFile);
    }

    public String getAuditLogSeparator() {
        return this.getValue(AUDIT_LOG_SEPARATOR_XPATH);
    }

    public void setAuditLogSeparator(String auditLogSeparator) {
        this.setValue(AUDIT_LOG_SEPARATOR_XPATH, auditLogSeparator, true);
    }

    public String getDefaultParameterForm() {
        return this.getValue(DEFAULT_PARAMETER_FORM);
    }

    public void setDefaultParameterForm(String defaultParameterForm) {
        this.setValue(DEFAULT_PARAMETER_FORM, defaultParameterForm);
    }

    public String getLogFile() {
        return this.getValue(LOG_FILE_XPATH);
    }

    public void setLogFile(String logFile) {
        this.setValue(LOG_FILE_XPATH, logFile);
    }

    public String getLogLevel() {
        return this.getValue(LOG_LEVEL_XPATH);
    }

    public void setLogLevel(String logLevel) {
        this.setValue(LOG_LEVEL_XPATH, logLevel);
    }

    public List<AclEntry> getDefaultAcls() {
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        List nodes = this.document.selectNodes(ACL_ENTRY_XPATH);
        for (Node node : nodes) {
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            AclEntry aclEntry = new AclEntry();
            aclEntry.setPrincipalName(element.attributeValue("role"));
            aclEntry.setPermission(element.attributeValue("acl"));
            aclEntries.add(aclEntry);
        }
        return aclEntries;
    }

    public void setDefaultAcls(List<AclEntry> defaultAcls) {
    }

    public Integer getSolutionRepositoryCacheSize() {
        Integer cacheSize = null;
        String tempValue = this.getValue(SOLUTION_REPOSITORY_CACHE_SIZE_XPATH);
        if (tempValue != null) {
            try {
                cacheSize = Integer.parseInt(tempValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cacheSize;
    }

    public void setSolutionRepositoryCacheSize(Integer solutionReporitoryCacheSize) {
        this.setValue(SOLUTION_REPOSITORY_CACHE_SIZE_XPATH, solutionReporitoryCacheSize == null ? "" : solutionReporitoryCacheSize.toString());
    }

    public String getAclFiles() {
        return this.getValue(ACL_FILES_XPATH);
    }

    public void setAclFiles(String fileExtensions) {
        this.setValue(ACL_FILES_XPATH, fileExtensions != null ? fileExtensions : "");
    }

    public String getAdminRole() {
        return this.getValue(ADMIN_ROLE_XPATH);
    }

    public void setAdminRole(String role) {
        this.setValue(ADMIN_ROLE_XPATH, role != null ? role : "");
    }

    public String getAnonymousUser() {
        return this.getValue(ANONYMOUS_USER_XPATH);
    }

    public void setAnonymousUser(String user) {
        this.setValue(ANONYMOUS_USER_XPATH, user != null ? user : "");
    }

    public String getAnonymousRole() {
        return this.getValue(ANONYMOUS_ROLE_XPATH);
    }

    public void setAnonymousRole(String role) {
        this.setValue(ANONYMOUS_ROLE_XPATH, role != null ? role : "");
    }

    private void setValue(String xPath, String value) {
        this.setValue(xPath, value, false);
    }

    private void setValue(String xPath, String value, boolean useCData) {
        Element element = (Element)this.document.selectSingleNode(xPath);
        if (element == null) {
            element = DocumentHelper.makeElement((Branch)this.document, (String)xPath);
        }
        if (useCData) {
            element.clearContent();
            element.addCDATA(value);
        } else {
            element.setText(value);
        }
    }

    private String getValue(String xpath) {
        Element element = (Element)this.document.selectSingleNode(xpath);
        return element != null ? element.getText() : null;
    }

    public Document getDocument() {
        return this.document;
    }
}

