/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class WebXml {
    Document document;
    protected static final String PARAM_NAME_ELEMENT = "param-name";
    protected static final String PARAM_VALUE_ELEMENT = "param-value";
    protected static final String ROOT_ELEMENT = "web-app";
    protected static final String CONTEXT_CONFIG_CONTEXT_PARAM_NAME = "contextConfigLocation";
    protected static final String BASE_URL_CONTEXT_PARAM_NAME = "base-url";
    protected static final String FULLY_QUALIFIED_SERVER_URL_CONTEXT_PARAM_NAME = "fully-qualified-server-url";
    protected static final String SOLUTION_PATH_CONTEXT_PARAM_NAME = "solution-path";
    protected static final String LOCALE_LANGUAGE_CONTEXT_PARAM_NAME = "locale-language";
    protected static final String LOCALE_COUNTRY_CONTEXT_PARAM_NAME = "locale-country";
    protected static final String ENCODING_CONTEXT_PARAM_NAME = "encoding";
    protected static final String HOME_SERVLET_NAME = "Home";
    protected static final String CONTEXT_PARAM_ELEMENT = "context-param";
    protected static final String CONTEXT_PARAM_XPATH = "web-app/context-param";
    protected static final String CONTEXT_PARAM_NAME_TEMPLATE_XPATH = "web-app/context-param/param-name[text()=\"{0}\"]";
    protected static final String SERVLET_NAME_TEMPLATE_XPATH = "web-app/servlet/servlet-name[text() = \"{0}\"]";

    public WebXml(File pentahoXmlFile) throws IOException, DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromFile((File)pentahoXmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public WebXml(String xml) throws DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    public WebXml(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException("Invalid root element.");
        }
        this.document = doc;
    }

    public WebXml() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    public String getContextConfigFileName() {
        return this.getContextParamValue(CONTEXT_CONFIG_CONTEXT_PARAM_NAME);
    }

    @Deprecated
    public String getBaseUrl() {
        return this.getFullyQualifiedServerUrl();
    }

    public String getFullyQualifiedServerUrl() {
        return this.getContextParamValue(FULLY_QUALIFIED_SERVER_URL_CONTEXT_PARAM_NAME);
    }

    public String getSolutionPath() {
        return this.getContextParamValue(SOLUTION_PATH_CONTEXT_PARAM_NAME);
    }

    public String getLocaleLanguage() {
        return this.getContextParamValue(LOCALE_LANGUAGE_CONTEXT_PARAM_NAME);
    }

    public String getLocaleCountry() {
        return this.getContextParamValue(LOCALE_COUNTRY_CONTEXT_PARAM_NAME);
    }

    public String getEncoding() {
        return this.getContextParamValue(ENCODING_CONTEXT_PARAM_NAME);
    }

    public String getHomePage() {
        return this.getServletMapping(HOME_SERVLET_NAME);
    }

    public void setContextConfigFileName(String fileName) {
        this.setContextParamValue(CONTEXT_CONFIG_CONTEXT_PARAM_NAME, fileName);
    }

    public void setBaseUrl(String baseUrl) {
        this.setContextParamValue(BASE_URL_CONTEXT_PARAM_NAME, baseUrl);
    }

    public void setFullyQualifiedServerUrl(String fullyQualifiedServerUrl) {
        this.setContextParamValue(FULLY_QUALIFIED_SERVER_URL_CONTEXT_PARAM_NAME, fullyQualifiedServerUrl);
    }

    public void setSolutionPath(String solutionPath) {
        this.setContextParamValue(SOLUTION_PATH_CONTEXT_PARAM_NAME, solutionPath);
    }

    public void setLocaleLanguage(String language) {
        this.setContextParamValue(LOCALE_LANGUAGE_CONTEXT_PARAM_NAME, language);
    }

    public void setLocaleCountry(String country) {
        this.setContextParamValue(LOCALE_COUNTRY_CONTEXT_PARAM_NAME, country);
    }

    public void setEncoding(String encoding) {
        this.setContextParamValue(ENCODING_CONTEXT_PARAM_NAME, encoding);
    }

    public void setHomePage(String homePage) {
        this.setServletMapping(HOME_SERVLET_NAME, homePage);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getContextParamValue(String name) {
        String xPath = MessageFormat.format(CONTEXT_PARAM_NAME_TEMPLATE_XPATH, name);
        Node node = this.document.selectSingleNode(xPath);
        String value = null;
        if (node != null) {
            node = node.selectSingleNode("../param-value");
        }
        if (node != null) {
            value = node.getText();
        }
        return value;
    }

    public void setContextParamValue(String name, String value) {
        String xPath = MessageFormat.format(CONTEXT_PARAM_NAME_TEMPLATE_XPATH, name);
        Element contextParamNameElement = (Element)this.document.selectSingleNode(xPath);
        if (value == null) {
            if (contextParamNameElement != null) {
                contextParamNameElement.getParent().detach();
            }
        } else {
            if (contextParamNameElement == null) {
                contextParamNameElement = this.document.getRootElement().addElement(CONTEXT_PARAM_ELEMENT);
                Element paramNameElement = contextParamNameElement.addElement(PARAM_NAME_ELEMENT);
                paramNameElement.setText(name);
            }
            Element paramValueElement = DocumentHelper.makeElement((Branch)contextParamNameElement.getParent(), (String)PARAM_VALUE_ELEMENT);
            paramValueElement.setText(value);
        }
    }

    public boolean setServletMapping(String name, String value) {
        String xPath = MessageFormat.format(SERVLET_NAME_TEMPLATE_XPATH, name);
        Node node = this.document.selectSingleNode(xPath);
        if (node != null) {
            node = node.selectSingleNode("../jsp-file");
        }
        if (node != null) {
            node.setText(value);
            return true;
        }
        return false;
    }

    public String getServletMapping(String name) {
        String xPath = MessageFormat.format(SERVLET_NAME_TEMPLATE_XPATH, name);
        Node node = this.document.selectSingleNode(xPath);
        String value = null;
        if (node != null) {
            node = node.selectSingleNode("../jsp-file");
        }
        if (node != null) {
            value = node.getText();
        }
        return value;
    }
}

