/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import org.osgi.framework.BundleContext;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.OSGIObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoOSGIActivator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static OSGIObjectFactory objectFactory;

    public void setBundleContext(BundleContext bundleContext) throws Exception {
        this.logger.debug("Registering OSGIObjectFactory");
        if (objectFactory != null) {
            this.logger.debug("De-Registering Previous OSGIObjectFactory");
            PentahoSystem.deregisterObjectFactory((IPentahoObjectFactory)objectFactory);
        }
        objectFactory = new OSGIObjectFactory(bundleContext);
        PentahoSystem.registerObjectFactory((IPentahoObjectFactory)objectFactory);
        PentahoSystem.setBundleContext((BundleContext)bundleContext);
        this.logger.debug("OSGIObjectFactory installed");
    }

    public void shutdown() {
        if (objectFactory != null) {
            PentahoSystem.deregisterObjectFactory((IPentahoObjectFactory)objectFactory);
        }
    }
}

