/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.io.File;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateContentComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;

public class JFreeReportDirectoryHtmlComponent
extends AbstractGenerateContentComponent {
    private static final long serialVersionUID = -7511578647689368225L;

    private File getInputFileValue(String inputName) {
        Object input = this.getInputValue(inputName);
        if (input == null) {
            return null;
        }
        if (input instanceof File) {
            return (File)input;
        }
        if (input instanceof String) {
            return new File((String)input);
        }
        return null;
    }

    @Override
    protected boolean performExport(MasterReport report) {
        try {
            File targetFile = this.getInputFileValue("target-file");
            if (targetFile == null) {
                return false;
            }
            File dataDirectory = this.getInputFileValue("data-directory");
            if (dataDirectory == null) {
                dataDirectory = new File(targetFile, "data/");
            }
            File targetDirectory = targetFile.getParentFile();
            if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                    String msg = Messages.getInstance().getErrorString("JFreeReportDirectoryComponent.ERROR_0001_INVALID_DIR", new Object[]{dataDirectory.getPath()});
                    throw new ReportProcessingException(msg);
                }
            } else if (!dataDirectory.exists()) {
                dataDirectory.mkdirs();
            }
            FileRepository targetRepository = new FileRepository(targetDirectory);
            ContentLocation targetRoot = targetRepository.getRoot();
            FileRepository dataRepository = new FileRepository(dataDirectory);
            ContentLocation dataRoot = dataRepository.getRoot();
            FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor();
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, targetFile.getName()));
            printer.setDataWriter(dataRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "content"));
            printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
            outputProcessor.setPrinter((HtmlPrinter)printer);
            FlowReportProcessor sp = new FlowReportProcessor(report, (OutputProcessor)outputProcessor);
            int yieldRate = this.getYieldRate();
            if (yieldRate > 0) {
                sp.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            sp.processReport();
            sp.close();
            return true;
        }
        catch (ReportProcessingException e) {
            return false;
        }
        catch (ContentIOException e) {
            return false;
        }
    }
}

