/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.pentaho.di.core.logging.KettleLogLayout;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogLevel;

public class Log4jForwardingKettleLoggingEventListener
implements KettleLoggingEventListener {
    public static final String STRING_PENTAHO_DI_LOGGER_NAME = "org.pentaho.di";
    private Logger pentahoLogger = Logger.getLogger((String)"org.pentaho.di");
    private KettleLogLayout layout;

    public Log4jForwardingKettleLoggingEventListener(Appender appender) {
        this.pentahoLogger.setAdditivity(false);
        this.pentahoLogger.setLevel(Level.ALL);
        this.pentahoLogger.addAppender(appender);
        this.layout = new KettleLogLayout(true);
    }

    public void eventAdded(KettleLoggingEvent event) {
        if (event.getLevel() == LogLevel.NOTHING) {
            return;
        }
        String line = this.layout.format(event);
        switch (event.getLevel()) {
            case ERROR: {
                this.pentahoLogger.log((Priority)Level.ERROR, (Object)line);
                break;
            }
            case DEBUG: 
            case ROWLEVEL: {
                this.pentahoLogger.log((Priority)Level.DEBUG, (Object)line);
                break;
            }
            default: {
                this.pentahoLogger.log((Priority)Level.INFO, (Object)line);
            }
        }
    }
}

