/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.xml.xquery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.XQueryAction;
import org.pentaho.actionsequence.dom.actions.XQueryConnectionAction;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.runtime.MapParameterResolver;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.services.connections.xquery.XQConnection;
import org.pentaho.platform.util.xml.XMLParserFactoryProducer;

public abstract class XQueryBaseComponent
extends ComponentBase
implements IPreparedComponent {
    private static final long serialVersionUID = -4390530975622541328L;
    private IPentahoResultSet rSet;
    protected IPentahoConnection connection;
    protected boolean connectionOwner = true;
    private static final String FILENAME_PREFIX = "tmp";
    private static final String EXTENSION = ".xml";
    private static final String XML_DOCUMENT_TAG = "XML_DOCUMENT";
    private int maxRows = -1;
    String preparedQuery = null;
    String[] preparedColumnTypes = null;

    public abstract boolean validateSystemSettings();

    public abstract Log getLogger();

    public IPentahoResultSet getResultSet() {
        return this.rSet;
    }

    protected boolean validateAction() {
        boolean result = false;
        IActionDefinition actionDefinition = this.getActionDefinition();
        if (actionDefinition instanceof XQueryAction) {
            XQueryAction xQueryAction = (XQueryAction)actionDefinition;
            if (xQueryAction.getSourceXml() == ActionInputConstant.NULL_INPUT && xQueryAction.getXmlDocument() == null) {
                this.error(Messages.getInstance().getString("XQueryBaseComponent.ERROR_0008_SOURCE_NOT_DEFINED", new Object[]{this.getActionName()}));
            } else if (xQueryAction.getQuery() == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", new Object[]{this.getActionName()}));
            } else if (xQueryAction.getOutputPreparedStatement() == null && xQueryAction.getOutputResultSet() == null) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0003_OUTPUT_NOT_SPECIFIED", new Object[]{this.getActionName()}));
            } else {
                result = true;
            }
        } else if (actionDefinition instanceof XQueryConnectionAction) {
            XQueryConnectionAction xQueryConnectionAction = (XQueryConnectionAction)actionDefinition;
            if (xQueryConnectionAction.getOutputConnection() == null) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0003_OUTPUT_NOT_SPECIFIED", new Object[]{this.getActionName()}));
            } else {
                result = true;
            }
        } else {
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{actionDefinition.getElement().asXML()}));
        }
        return result;
    }

    public void done() {
    }

    protected boolean executeAction() {
        boolean result = false;
        IActionDefinition actionDefinition = this.getActionDefinition();
        if (actionDefinition instanceof XQueryAction) {
            IPreparedComponent sharedConnection;
            XQueryAction xQueryAction = (XQueryAction)actionDefinition;
            IActionInput maxRowsInput = xQueryAction.getMaxRows();
            if (maxRowsInput != ActionInputConstant.NULL_INPUT) {
                this.setMaxRows(maxRowsInput.getIntValue());
            }
            if ((sharedConnection = (IPreparedComponent)xQueryAction.getSharedConnection().getValue()) != null) {
                this.connectionOwner = false;
                this.connection = sharedConnection.shareConnection();
            } else {
                this.connection = this.getConnection();
            }
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0002_CONNECTION_NOT_AVAILABLE", new Object[]{this.getActionName()}));
            } else if (this.connection.getDatasourceType() != "XML") {
                this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0001_INVALID_CONNECTION_TYPE", new Object[]{this.getActionName()}));
            } else {
                result = this.runQuery(this.connection, xQueryAction.getQuery().getStringValue());
            }
        } else if (actionDefinition instanceof XQueryConnectionAction) {
            XQueryConnectionAction xQueryConnectionAction = (XQueryConnectionAction)this.getActionDefinition();
            this.connection = this.getConnection();
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0002_CONNECTION_NOT_AVAILABLE", new Object[]{this.getActionName()}));
            } else if (this.connection.getDatasourceType() != "XML") {
                this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0001_INVALID_CONNECTION_TYPE", new Object[]{this.getActionName()}));
            } else {
                xQueryConnectionAction.getOutputConnection().setValue((Object)this);
                result = true;
            }
        }
        return result;
    }

    protected boolean runQuery(IPentahoConnection localConnection, String rawQuery) {
        XQueryAction xQueryAction = (XQueryAction)this.getActionDefinition();
        try {
            if (localConnection == null) {
                return false;
            }
            this.debug(Messages.getInstance().getString("XQueryBaseComponent.DEBUG_RUNNING_QUERY", new Object[]{rawQuery}));
            String documentPath = null;
            int resourceType = -1;
            String srcXml = xQueryAction.getSourceXml().getStringValue();
            IActionResource xmlResource = xQueryAction.getXmlDocument();
            InputStream inputStream = null;
            URL url = null;
            if (srcXml != null) {
                inputStream = new FileInputStream(new File(this.createTempXMLFile(srcXml)));
            } else if (xmlResource != null) {
                IActionSequenceResource resource = this.getResource(xmlResource.getName());
                resourceType = resource.getSourceType();
                if (resourceType == 1 || resourceType == 3) {
                    inputStream = resource.getInputStream(RepositoryFilePermission.READ);
                } else if (resourceType == 6) {
                    inputStream = new FileInputStream(new File(this.createTempXMLFile(resource.getAddress())));
                } else {
                    url = new URL(documentPath);
                }
            }
            String[] columnTypes = null;
            if (this.retrieveColumnTypes()) {
                try {
                    SAXReader reader = XMLParserFactoryProducer.getSAXReader(null);
                    Document document = url != null ? reader.read(url) : reader.read(inputStream);
                    Node commentNode = document.selectSingleNode("/result-set/comment()");
                    if (commentNode != null) {
                        String commentString = commentNode.getText();
                        StringTokenizer st = new StringTokenizer(commentString, ",");
                        LinkedList<String> columnTypesList = new LinkedList<String>();
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken().trim();
                            columnTypesList.add(token);
                        }
                        columnTypes = columnTypesList.toArray(new String[0]);
                    }
                }
                catch (Exception e) {
                    this.getLogger().warn((Object)Messages.getInstance().getString("XQueryBaseComponent.ERROR_0009_ERROR_BUILDING_COLUMN_TYPES"), (Throwable)e);
                }
            }
            if (rawQuery != null) {
                if (rawQuery.indexOf("{XML_DOCUMENT}") >= 0) {
                    rawQuery = TemplateUtil.applyTemplate((String)rawQuery, (String)XML_DOCUMENT_TAG, documentPath);
                } else {
                    int len;
                    Calendar now = Calendar.getInstance();
                    File temp = File.createTempFile("tempXQuery" + now.getTimeInMillis(), EXTENSION);
                    temp.deleteOnExit();
                    FileOutputStream out = new FileOutputStream(temp);
                    IActionSequenceResource resource = this.getResource(xmlResource.getName());
                    inputStream = resource.getInputStream(RepositoryFilePermission.READ);
                    byte[] buf = new byte[1024];
                    while ((len = inputStream.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    inputStream.close();
                    documentPath = temp.getAbsolutePath();
                    documentPath = FilenameUtils.separatorsToUnix((String)documentPath);
                    rawQuery = "doc(\"" + documentPath + "\")" + rawQuery;
                }
            }
            if (xQueryAction.getOutputPreparedStatement() != null) {
                return this.prepareFinalQuery(rawQuery, columnTypes);
            }
            return this.runFinalQuery(localConnection, rawQuery, columnTypes);
        }
        catch (Exception e) {
            this.getLogger().error((Object)Messages.getInstance().getString("XQueryBaseComponent.ERROR_0010_ERROR_RUNNING_QUERY"), (Throwable)e);
            return false;
        }
    }

    protected boolean prepareFinalQuery(String rawQuery, String[] columnTypes) {
        if (rawQuery != null) {
            this.preparedQuery = this.applyInputsToFormat(rawQuery);
        }
        this.preparedColumnTypes = columnTypes;
        ((XQueryAction)this.getActionDefinition()).getOutputPreparedStatement().setValue((Object)this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runFinalQuery(IPentahoConnection localConnection, String rawQuery, String[] columnTypes) {
        boolean success;
        block7: {
            XQueryAction xQueryAction = (XQueryAction)this.getActionDefinition();
            success = false;
            String finalQuery = this.applyInputsToFormat(rawQuery);
            try {
                IPentahoResultSet resultSet = ((XQConnection)localConnection).executeQuery(finalQuery, columnTypes);
                if (resultSet == null) break block7;
                if (!xQueryAction.getLive().getBooleanValue(true)) {
                    resultSet = resultSet.memoryCopy();
                }
                try {
                    IActionOutput resultSetOutput = xQueryAction.getOutputResultSet();
                    if (resultSetOutput != null) {
                        resultSetOutput.setValue((Object)resultSet);
                    }
                    success = true;
                }
                finally {
                    resultSet.close();
                }
            }
            catch (XPathException e) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            }
        }
        return success;
    }

    protected String createTempXMLFile(String xmlString) {
        String documentPath = null;
        try {
            File file = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), FILENAME_PREFIX, EXTENSION, true);
            documentPath = file.getCanonicalPath();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(xmlString);
            out.close();
        }
        catch (IOException e) {
            this.getLogger().error((Object)Messages.getInstance().getString("XQueryBaseComponent.ERROR_0011_ERROR_CREATING_TEMP_FILE"), (Throwable)e);
        }
        documentPath = documentPath.replaceAll("\\\\", "/");
        return documentPath;
    }

    protected IPentahoConnection getConnection() {
        IPentahoConnection conn = null;
        try {
            conn = PentahoConnectionFactory.getConnection((String)"XML", (IPentahoSession)this.getSession(), (ILogger)this);
            if (conn == null) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                return null;
            }
            if (this.getMaxRows() >= 0) {
                conn.setMaxRows(this.getMaxRows());
            }
            return conn;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            return null;
        }
    }

    public boolean init() {
        return true;
    }

    public IPentahoConnection shareConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet executePrepared(Map preparedParams) {
        block9: {
            IPentahoResultSet iPentahoResultSet;
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0012_NO_CONNECTION", new Object[]{this.getActionName()}));
                return null;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0012_NO_CONNECTION", new Object[]{this.getActionName()}));
                return null;
            }
            if (this.preparedQuery == null) {
                this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                return null;
            }
            String finalQuery = TemplateUtil.applyTemplate((String)this.preparedQuery, (IRuntimeContext)this.getRuntimeContext(), (IParameterResolver)new MapParameterResolver(preparedParams, "PREPARELATER", this.getRuntimeContext()));
            IPentahoResultSet resultSet = ((XQConnection)this.connection).executeQuery(finalQuery, this.preparedColumnTypes);
            if (resultSet == null) break block9;
            boolean live = this.getInputBooleanValue("live", true);
            if (!live) {
                resultSet = resultSet.memoryCopy();
            }
            try {
                iPentahoResultSet = resultSet;
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (XPathException e) {
                    this.error(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
                }
            }
            resultSet.close();
            return iPentahoResultSet;
        }
        return null;
    }

    protected boolean retrieveColumnTypes() {
        return true;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int value) {
        if (this.rSet != null) {
            throw new UnsupportedOperationException(Messages.getInstance().getErrorString("XQueryBaseComponent.ERROR_0013_INVALID_ORDER_OF_OPERATION"));
        }
        this.maxRows = value;
    }

    public void dispose() {
        if (this.connectionOwner && this.connection != null) {
            this.connection.close();
        }
    }
}

