/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.LocaleFileDescriptor;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.ExportFileNameEncoder;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class LocaleFilesProcessor {
    private static final String FILE_LOCALE_RESOLVER = "file.locale";
    private static final String URL_DESCRIPTION = "url_description";
    private static final String URL_NAME = "url_name";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String NAME = "name";
    private static final String PROPERTIES_EXT = ".properties";
    private static final String LOCALE_EXT = ".locale";
    private List<LocaleFileDescriptor> localeFiles = new ArrayList<LocaleFileDescriptor>();

    public boolean isLocaleFile(ImportSource.IRepositoryFileBundle file, String parentPath, byte[] bytes) throws IOException {
        boolean isLocale = false;
        String fileName = file.getFile().getName();
        String actualFilePath = file.getPath();
        RepositoryFile localeRepositoryFile = file.getFile();
        if (ImportSession.getSession().getManifest() != null && ImportSession.getSession().getManifest().getManifestInformation().getManifestVersion() != null) {
            fileName = ExportFileNameEncoder.decodeZipFileName(fileName);
            actualFilePath = ExportFileNameEncoder.decodeZipFileName(actualFilePath);
            localeRepositoryFile = new RepositoryFile.Builder(localeRepositoryFile).name(ExportFileNameEncoder.decodeZipFileName(localeRepositoryFile.getName())).build();
        }
        int sourceVersion = 0;
        if (fileName.endsWith(PROPERTIES_EXT)) {
            sourceVersion = 1;
        } else if (fileName.endsWith(LOCALE_EXT)) {
            sourceVersion = 2;
        }
        if (sourceVersion != 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            Properties properties = this.loadProperties(inputStream);
            String name = this.getProperty(properties, NAME, sourceVersion);
            String title = this.getProperty(properties, TITLE, sourceVersion);
            String description = this.getProperty(properties, DESCRIPTION, sourceVersion);
            String url_name = this.getProperty(properties, URL_NAME, sourceVersion);
            String url_description = this.getProperty(properties, URL_DESCRIPTION, sourceVersion);
            if (!StringUtils.isEmpty((String)url_name)) {
                name = url_name;
            }
            if (!StringUtils.isEmpty((String)title)) {
                name = title;
            }
            String string = description = !StringUtils.isEmpty((String)description) ? description : "";
            if (!StringUtils.isEmpty((String)url_description)) {
                description = url_description;
            }
            if (!StringUtils.isEmpty((String)name)) {
                LocaleFileDescriptor localeFile;
                String filePath = actualFilePath.equals("/") || actualFilePath.equals("\\") ? "" : actualFilePath;
                filePath = RepositoryFilenameUtils.concat((String)parentPath, (String)filePath);
                switch (sourceVersion) {
                    case 1: {
                        localeFile = new LocaleFileDescriptor(name, PROPERTIES_EXT, description, filePath, localeRepositoryFile, inputStream);
                        break;
                    }
                    case 2: {
                        localeFile = new LocaleFileDescriptor(name, LOCALE_EXT, description, filePath, localeRepositoryFile, inputStream);
                        break;
                    }
                    default: {
                        localeFile = new LocaleFileDescriptor(name, description, filePath, localeRepositoryFile, inputStream);
                    }
                }
                this.localeFiles.add(localeFile);
                if (properties.size() <= 2 || sourceVersion == 2) {
                    isLocale = true;
                }
            }
        }
        return isLocale;
    }

    private String getProperty(Properties properties, String propertyName, int sourceVersion) {
        if (sourceVersion == 1) {
            return properties.getProperty(propertyName);
        }
        return properties.getProperty("file." + propertyName);
    }

    public Properties loadProperties(InputStream inputStream) throws IOException {
        assert (inputStream != null);
        Properties properties = new Properties();
        PropertyResourceBundle rb = new PropertyResourceBundle(inputStream);
        Enumeration<String> keyEnum = rb.getKeys();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            assert (key != null);
            String sKey = String.valueOf(key);
            properties.put(sKey, rb.getObject(sKey));
        }
        return properties;
    }

    public boolean createLocaleEntry(String filePath, String name, String title, String description, RepositoryFile file, InputStream is) throws IOException {
        return this.createLocaleEntry(filePath, name, title, description, file, is, 2);
    }

    public boolean createLocaleEntry(String filePath, String name, String title, String description, RepositoryFile file, InputStream is, int sourceVersion) throws IOException {
        boolean success = false;
        RepositoryFile.Builder rf = new RepositoryFile.Builder(name);
        rf.path(filePath);
        if (!StringUtils.isEmpty((String)title)) {
            name = title;
        }
        if (!StringUtils.isEmpty((String)name)) {
            LocaleFileDescriptor localeFile = name.endsWith(PROPERTIES_EXT) ? new LocaleFileDescriptor(name, PROPERTIES_EXT, description, filePath, rf.build(), is) : (name.endsWith(LOCALE_EXT) ? new LocaleFileDescriptor(name, LOCALE_EXT, description, filePath, rf.build(), is) : new LocaleFileDescriptor(name, description, filePath, rf.build(), is));
            this.localeFiles.add(localeFile);
            success = true;
        }
        return success;
    }

    public void processLocaleFiles(IPlatformImporter importer) throws PlatformImportException {
        String actualFileName;
        String extension;
        RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder();
        IPlatformMimeResolver mimeResolver = (IPlatformMimeResolver)PentahoSystem.get(IPlatformMimeResolver.class);
        String mimeType = mimeResolver.resolveMimeForFileName(FILE_LOCALE_RESOLVER);
        ArrayList<String> filesWithLocaleFiles = new ArrayList<String>();
        for (LocaleFileDescriptor localeFile : this.localeFiles) {
            extension = localeFile.getExtension();
            if (StringUtils.isEmpty((String)extension) || !extension.equals(LOCALE_EXT)) continue;
            actualFileName = localeFile.getFile().getName().indexOf(".") != -1 ? localeFile.getFile().getName().substring(0, localeFile.getFile().getName().indexOf(".")) : localeFile.getFile().getName();
            filesWithLocaleFiles.add(localeFile.getPath() + actualFileName);
        }
        for (LocaleFileDescriptor localeFile : this.localeFiles) {
            extension = localeFile.getExtension();
            if (!StringUtils.isEmpty((String)extension) && extension.equals(PROPERTIES_EXT)) {
                String string = actualFileName = localeFile.getFile().getName().indexOf(".") != -1 ? localeFile.getFile().getName().substring(0, localeFile.getFile().getName().indexOf(".")) : localeFile.getFile().getName();
                if (filesWithLocaleFiles.contains(localeFile.getPath() + actualFileName)) continue;
            }
            this.proceed(importer, bundleBuilder, mimeType, localeFile);
        }
    }

    protected void proceed(IPlatformImporter importer, RepositoryFileImportBundle.Builder bundleBuilder, String mimeType, LocaleFileDescriptor localeFile) throws PlatformImportException {
        bundleBuilder.name(localeFile.getName());
        bundleBuilder.comment(localeFile.getDescription());
        bundleBuilder.path(localeFile.getPath());
        bundleBuilder.file(localeFile.getFile());
        bundleBuilder.input(localeFile.getInputStream());
        bundleBuilder.mime(mimeType);
        RepositoryFileImportBundle platformImportBundle = bundleBuilder.build();
        importer.importFile(platformImportBundle);
    }
}

