/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.util.List;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PentahoPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;

public class PDIImportFileHandler
extends RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    public PDIImportFileHandler(List<IMimeType> mimeTypes) {
        super(mimeTypes);
    }

    @Override
    protected RepositoryFile createFile(RepositoryFileImportBundle bundle, String repositoryPath, IRepositoryFileData data) throws PlatformImportException {
        String originalName = bundle.getName();
        bundle.setName(PentahoPlatformImporter.checkAndSanitize(originalName));
        bundle.setTitle(originalName);
        return super.createFile(bundle, repositoryPath, data);
    }

    @Override
    protected RepositoryFile updateFile(RepositoryFileImportBundle bundle, RepositoryFile file, IRepositoryFileData data) throws PlatformImportException {
        RepositoryFile updatedFile = null;
        if (this.isNodeRepositoryFileData(file)) {
            updatedFile = this.getRepository().updateFile(file, data, bundle.getComment());
        } else {
            String fileName = bundle.getName();
            this.getLogger().trace((Object)("The file [" + fileName + "] will be recreated because it content-type was changed."));
            RepositoryFileAcl originFileAcl = this.getRepository().getAcl(file.getId());
            this.getRepository().deleteFile(file.getId(), true, null);
            RepositoryFileAcl newFileAcl = bundle.getAcl();
            bundle.setAcl(originFileAcl);
            updatedFile = this.createFile(bundle, file.getPath(), data);
            bundle.setAcl(newFileAcl);
        }
        return updatedFile;
    }

    private boolean isNodeRepositoryFileData(RepositoryFile file) {
        try {
            this.getRepository().getDataForRead(file.getId(), NodeRepositoryFileData.class);
            return true;
        }
        catch (UnifiedRepositoryException e) {
            return false;
        }
    }
}

