/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.ExportHandler;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class DefaultExportHandler
implements ExportHandler {
    private static final Log log = LogFactory.getLog(DefaultExportHandler.class);
    private Map<String, Converter> converters;
    private IUnifiedRepository repository;
    private List<String> localeExportList;

    @Override
    public InputStream doExport(RepositoryFile repositoryFile, String filePath) throws ExportException, IOException {
        Converter converter;
        Object is = null;
        String name = repositoryFile.getName();
        String ext = RepositoryFilenameUtils.getExtension((String)name);
        if (StringUtils.isEmpty((String)ext)) {
            log.debug((Object)("Skipping file without extension: " + name));
        }
        if (this.converters == null) {
            IRepositoryContentConverterHandler converterHandler = (IRepositoryContentConverterHandler)PentahoSystem.get(IRepositoryContentConverterHandler.class);
            this.converters = converterHandler.getConverters();
        }
        if ((converter = this.converters.get(ext)) == null) {
            log.debug((Object)("Skipping file without converter: " + name));
            return null;
        }
        return converter.convert(repositoryFile.getId());
    }

    public void setConverters(Map<String, Converter> converters) {
        this.converters = converters;
    }

    public void setRepository(IUnifiedRepository repository) {
        this.repository = repository;
    }

    public List<String> getLocaleExportList() {
        return this.localeExportList;
    }

    public void setLocaleExportList(List<String> localeExportList) {
        this.localeExportList = localeExportList;
    }
}

