/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.IJobFilter;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.repository.RepositoryGcJob;
import org.pentaho.platform.util.StringUtil;

public class RepositoryCleanerSystemListener
implements IPentahoSystemListener,
IJobFilter {
    private final Log logger = LogFactory.getLog(RepositoryCleanerSystemListener.class);
    private boolean gcEnabled = true;
    private String execute;

    public boolean startup(IPentahoSession session) {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", (IPentahoSession)session);
        if (scheduler == null) {
            this.logger.error((Object)"Cannot obtain an instance of IScheduler2");
            return false;
        }
        try {
            List jobs = scheduler.getJobs((IJobFilter)this);
            if (this.gcEnabled) {
                if (jobs.isEmpty()) {
                    this.scheduleJob(scheduler);
                } else {
                    this.rescheduleIfNecessary(scheduler, jobs);
                }
            } else if (!jobs.isEmpty()) {
                this.unscheduleJob(scheduler, jobs);
            }
        }
        catch (SchedulerException e) {
            this.logger.error((Object)"Scheduler error", (Throwable)e);
        }
        return true;
    }

    private JobTrigger findJobTrigger() {
        if (StringUtil.isEmpty((String)this.execute)) {
            this.logger.error((Object)"\"execute\" property is not specified!");
            return null;
        }
        Frequency frequency = Frequency.fromString(this.execute);
        if (frequency == null) {
            this.logger.error((Object)("Unknown value for property \"execute\": " + this.execute));
            return null;
        }
        return frequency.createTrigger();
    }

    private void scheduleJob(IScheduler scheduler) throws SchedulerException {
        JobTrigger trigger = this.findJobTrigger();
        if (trigger != null) {
            this.logger.info((Object)("Creating new job with trigger: " + trigger));
            scheduler.createJob("RepositoryGcJob", RepositoryGcJob.class, null, (IJobTrigger)trigger);
        }
    }

    private void rescheduleIfNecessary(IScheduler scheduler, List<Job> jobs) throws SchedulerException {
        JobTrigger trigger = this.findJobTrigger();
        if (trigger == null) {
            return;
        }
        ArrayList<Job> matched = new ArrayList<Job>(jobs.size());
        for (Job job : jobs) {
            JobTrigger tr = job.getJobTrigger();
            if (trigger.getClass() != tr.getClass()) {
                this.logger.info((Object)("Removing job with id: " + job.getJobId()));
                scheduler.removeJob(job.getJobId());
                continue;
            }
            matched.add(job);
        }
        if (matched.isEmpty()) {
            this.logger.info((Object)"Need to re-schedule job");
            this.scheduleJob(scheduler);
        }
    }

    private void unscheduleJob(IScheduler scheduler, List<Job> jobs) throws SchedulerException {
        for (Job job : jobs) {
            this.logger.info((Object)("Removing job with id: " + job.getJobId()));
            scheduler.removeJob(job.getJobId());
        }
    }

    public void shutdown() {
    }

    public boolean accept(Job job) {
        return "RepositoryGcJob".equals(job.getJobName());
    }

    public boolean isGcEnabled() {
        return this.gcEnabled;
    }

    public void setGcEnabled(boolean gcEnabled) {
        this.gcEnabled = gcEnabled;
    }

    public String getExecute() {
        return this.execute;
    }

    public void setExecute(String execute) {
        this.execute = execute;
    }

    static enum Frequency {
        NOW("now"){

            @Override
            public JobTrigger createTrigger() {
                return new SimpleJobTrigger(new Date(), new Date(Long.MAX_VALUE), 0, 1L);
            }
        }
        ,
        WEEKLY("weekly"){

            @Override
            public JobTrigger createTrigger() {
                return new ComplexJobTrigger(null, null, null, Integer.valueOf(1), Integer.valueOf(0));
            }
        }
        ,
        MONTHLY("monthly"){

            @Override
            public JobTrigger createTrigger() {
                return new ComplexJobTrigger(null, null, Integer.valueOf(1), null, Integer.valueOf(0));
            }
        };

        private final String value;

        private Frequency(String value) {
            this.value = value;
        }

        public abstract JobTrigger createTrigger();

        public static Frequency fromString(String name) {
            for (Frequency frequency : Frequency.values()) {
                if (!frequency.value.equalsIgnoreCase(name)) continue;
                return frequency;
            }
            return null;
        }

        String getValue() {
            return this.value;
        }
    }
}

