/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices.content;

import java.io.OutputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.plugin.services.webservices.content.AbstractAxisServiceContentGenerator;
import org.pentaho.platform.plugin.services.webservices.messages.Messages;

public abstract class AxisWebServiceRequestDispatcher
extends AbstractAxisServiceContentGenerator {
    private static final long serialVersionUID = 8314157642653305277L;

    @Override
    public void createContent(AxisConfiguration axisConfiguration, ConfigurationContext context, OutputStream out) throws Exception {
        AxisService axisService;
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        if (pathParams == null) {
            String message = Messages.getInstance().getErrorString("WebServiceContentGenerator.ERROR_0004_PATH_PARAMS_IS_MISSING");
            this.getLogger().error((Object)message);
            out.write(message.getBytes());
            return;
        }
        String serviceName = pathParams.getStringParameter("path", null);
        if (serviceName == null) {
            String message = Messages.getInstance().getErrorString("WebServiceContentGenerator.ERROR_0005_SERVICE_NAME_IS_MISSING");
            this.getLogger().error((Object)message);
            out.write(message.getBytes());
            return;
        }
        String query = serviceName = serviceName.substring(1);
        String operationName = null;
        int idx = serviceName.indexOf("/");
        if (idx != -1) {
            serviceName = serviceName.substring(0, idx);
            operationName = (idx = (query = query.substring(idx + 1)).indexOf("?")) != -1 ? query.substring(0, idx) : query;
        }
        if ((axisService = axisConfiguration.getService(serviceName)) == null) {
            String message = Messages.getInstance().getErrorString("WebServiceContentGenerator.ERROR_0006_SERVICE_IS_INVALID", new Object[]{serviceName});
            this.getLogger().error((Object)message);
            out.write(message.getBytes());
            return;
        }
        this.createServiceContent(axisService, operationName, axisConfiguration, context, out);
    }

    protected abstract void createServiceContent(AxisService var1, String var2, AxisConfiguration var3, ConfigurationContext var4, OutputStream var5) throws Exception;
}

