/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.XmlTransient;
import org.pentaho.platform.api.email.IEmailConfiguration;
import org.pentaho.platform.api.email.IEmailService;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.email.EmailConfiguration;
import org.pentaho.platform.plugin.services.email.EmailService;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;

@XmlTransient
@Path(value="/emailconfig/")
public class EmailResource
extends AbstractJaxRSResource {
    private static final Log logger = LogFactory.getLog(EmailResource.class);
    private IEmailService emailService = null;
    private IAuthorizationPolicy policy;

    public EmailResource() throws IllegalArgumentException {
        this.emailService = (IEmailService)PentahoSystem.get(IEmailService.class, (String)"IEmailService", (IPentahoSession)PentahoSessionHolder.getSession());
        if (this.emailService == null) {
            this.emailService = new EmailService();
        }
        this.init(this.emailService);
    }

    public EmailResource(IEmailService emailService) throws IllegalArgumentException {
        this.init(emailService);
    }

    private void init(IEmailService emailService) {
        if (emailService == null) {
            throw new IllegalArgumentException();
        }
        this.emailService = emailService;
        try {
            this.policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to get IAuthorizationPolicy: " + ex.getMessage()));
        }
    }

    @GET
    @Path(value="/resetEmailConfig")
    @Produces(value={"text/plain", "application/json"})
    public Response deleteEmailConfig(EmailConfiguration emailConfiguration) {
        if (this.canAdminister()) {
            try {
                this.emailService.setEmailConfig((IEmailConfiguration)new EmailConfiguration());
                return Response.ok().build();
            }
            catch (Exception e) {
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/setEmailConfig")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain", "application/json"})
    public Response setEmailConfig(EmailConfiguration emailConfiguration) {
        if (this.canAdminister()) {
            try {
                this.emailService.setEmailConfig((IEmailConfiguration)emailConfiguration);
                return Response.ok().build();
            }
            catch (Exception e) {
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/getEmailConfig")
    @Produces(value={"application/json"})
    public IEmailConfiguration getEmailConfig() {
        if (this.canAdminister()) {
            try {
                return this.emailService.getEmailConfig();
            }
            catch (Exception e) {
                return new EmailConfiguration();
            }
        }
        return new EmailConfiguration();
    }

    @PUT
    @Path(value="/sendEmailTest")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain", "application/json"})
    public Response sendEmailTest(EmailConfiguration emailConfiguration) throws Exception {
        if (this.canAdminister()) {
            return Response.ok((Object)this.emailService.sendEmailTest((IEmailConfiguration)emailConfiguration)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/isValid")
    @Produces(value={"text/plain"})
    public Response isValid() {
        try {
            if (this.emailService.isValid()) {
                return Response.ok((Object)"true").build();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok((Object)"false").build();
    }

    private boolean canAdminister() {
        return this.policy.isAllowed("org.pentaho.repository.read") && this.policy.isAllowed("org.pentaho.repository.create") && this.policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

