/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.StandardSerializationPolicy;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;
import org.pentaho.platform.web.servlet.messages.Messages;

public abstract class AbstractGwtRpcProxyServlet
extends RemoteServiceServlet {
    private static final Log logger = LogFactory.getLog(AbstractGwtRpcProxyServlet.class);

    protected abstract Object resolveDispatchTarget(String var1);

    protected void doUnexpectedFailure(Throwable e) {
        super.doUnexpectedFailure(e);
        logger.error((Object)e);
    }

    protected String getDispatchKey() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String requestPathInfo = request.getPathInfo();
        if (requestPathInfo.startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        if (requestPathInfo.contains("/")) {
            String[] elements = requestPathInfo.split("/");
            return elements[elements.length - 1];
        }
        return requestPathInfo;
    }

    protected String getServletContextPath() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String path = request.getServletPath() + "/" + request.getPathInfo();
        if (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCall(String payload) throws SerializationException {
        HashMap<Class<GwtRpcProxyException>, Boolean> whitelist = new HashMap<Class<GwtRpcProxyException>, Boolean>();
        whitelist.put(GwtRpcProxyException.class, Boolean.TRUE);
        HashMap obfuscatedTypeIds = new HashMap();
        StandardSerializationPolicy policy = new StandardSerializationPolicy(whitelist, whitelist, obfuscatedTypeIds);
        String servletContextPath = this.getServletContextPath();
        Object target = null;
        try {
            target = this.resolveDispatchTarget(servletContextPath);
        }
        catch (GwtRpcProxyException ex) {
            logger.error((Object)Messages.getInstance().getErrorString("AbstractGwtRpcProxyServlet.ERROR_0001_FAILED_TO_RESOLVE_DISPATCH_TARGET", new Object[]{servletContextPath}), (Throwable)ex);
            return RPC.encodeResponseForFailure(null, (Throwable)ex, (SerializationPolicy)policy);
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader altLoader = target.getClass().getClassLoader();
        try {
            if (altLoader != origLoader) {
                Thread.currentThread().setContextClassLoader(altLoader);
            }
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, null, (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            Method method = rpcRequest.getMethod();
            try {
                Method m = target.getClass().getMethod(method.getName(), method.getParameterTypes());
                if (m != null) {
                    method = m;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String string = RPC.invokeAndEncodeResponse((Object)target, (Method)method, (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
            return string;
        }
        catch (IncompatibleRemoteServiceException ex) {
            logger.error((Object)Messages.getInstance().getErrorString("AbstractGwtRpcProxyServlet.ERROR_0003_RPC_INVOCATION_FAILED", new Object[]{target.getClass().getName()}), (Throwable)ex);
            String string = RPC.encodeResponseForFailure(null, (Throwable)ex);
            return string;
        }
        finally {
            if (altLoader != origLoader && origLoader != null) {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }
}

