/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IBackgroundExecution;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.scheduler.BackgroundExecutionException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.runtime.ParameterManager;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.MessageFormatUtils;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;
import org.pentaho.platform.web.servlet.HttpServletRequestHandler;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class ViewAction
extends ServletBase {
    private static final long serialVersionUID = 4680027723733552639L;
    private static final Log logger = LogFactory.getLog(ViewAction.class);

    @Override
    public Log getLogger() {
        return logger;
    }

    protected boolean doBackgroundExecution(HttpServletRequest request, HttpServletResponse response, IPentahoSession userSession) throws ServletException, IOException {
        if ("true".equals(request.getParameter("background"))) {
            IBackgroundExecution backgroundExecutionHandler = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)userSession);
            if (backgroundExecutionHandler != null) {
                HttpRequestParameterProvider parameterProvider = new HttpRequestParameterProvider(request);
                String intro = "";
                String footer = "";
                IUITemplater templater = (IUITemplater)PentahoSystem.get(IUITemplater.class, (IPentahoSession)userSession);
                if (templater != null) {
                    String[] sections = templater.breakTemplate("template-dialog.html", "", userSession);
                    if (sections != null && sections.length > 0) {
                        intro = sections[0];
                    }
                    if (sections != null && sections.length > 1) {
                        footer = sections[1];
                    }
                } else {
                    intro = Messages.getInstance().getString("ViewAction.ERROR_0002_BAD_TEMPLATE_OBJECT");
                }
                response.getWriter().print(intro);
                String backgroundResponse = null;
                try {
                    backgroundResponse = backgroundExecutionHandler.backgroundExecuteAction(userSession, (IParameterProvider)parameterProvider);
                }
                catch (BackgroundExecutionException bex) {
                    backgroundResponse = bex.getLocalizedMessage();
                    response.getWriter().print(backgroundResponse);
                    response.getWriter().print(footer);
                    this.error(Messages.getInstance().getErrorString("ViewAction.ERROR_0004_UNABLE_TO_PERFORM_BACKGROUND_EXECUTION"), bex);
                    return false;
                }
                response.setHeader("background_execution", "true");
                response.getWriter().print(backgroundResponse);
                response.getWriter().print(footer);
                return true;
            }
            this.error(Messages.getInstance().getErrorString("ViewAction.ERROR_0001_BACKGROUND_EXECUTE_NOT_SUPPORTED"));
        }
        return false;
    }

    protected OutputStream getOutputStream(HttpServletResponse response, boolean doMessages) throws ServletException, IOException {
        Object outputStream = null;
        outputStream = doMessages ? new ByteArrayOutputStream() : response.getOutputStream();
        return outputStream;
    }

    protected boolean doMessages(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("debug"));
    }

    protected boolean hasResponse(IRuntimeContext runtime) {
        boolean hasResponse = false;
        Map returnParamMap = runtime.getParameterManager().getReturnParameters();
        for (Map.Entry mapEntry : returnParamMap.entrySet()) {
            ParameterManager.ReturnParameter returnParam = (ParameterManager.ReturnParameter)mapEntry.getValue();
            if (returnParam == null || !"response".equals(returnParam.destinationName)) continue;
            hasResponse = true;
        }
        return hasResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleActionRequest(HttpServletRequest request, HttpServletResponse response, IOutputHandler outputHandler, HttpServletRequestHandler requestHandler, OutputStream outputStream, IContentItem contentItem) throws ServletException, IOException {
        IRuntimeContext runtime = null;
        try {
            boolean printError;
            runtime = requestHandler.handleActionRequest(0, 0);
            if (runtime == null) {
                StringBuffer buffer = new StringBuffer();
                for (String message : requestHandler.getMessages()) {
                    buffer.append(message);
                }
                outputStream.write(buffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
                return;
            }
            boolean hasResponse = outputHandler.isResponseExpected();
            IContentItem responseContentItem = outputHandler.getOutputContentItem("response", "content", null, null);
            boolean success = runtime != null && runtime.getStatus() == 6;
            boolean debugMessages = this.doMessages(request);
            boolean printSuccess = runtime != null && success && (!hasResponse || debugMessages);
            boolean bl = printError = runtime != null && !success && !response.isCommitted();
            if (printSuccess || printError) {
                String htmlMimeType = "text/html";
                responseContentItem.setMimeType("text/html");
                outputStream = responseContentItem.getOutputStream(null);
                response.setContentType("text/html");
                StringBuffer buffer = new StringBuffer();
                if (printSuccess) {
                    boolean doWrapper = !"false".equals(request.getParameter("wrapper"));
                    MessageFormatUtils.formatSuccessMessage("text/html", runtime, buffer, debugMessages, doWrapper);
                } else {
                    response.resetBuffer();
                    MessageFormatUtils.formatFailureMessage("text/html", runtime, buffer, requestHandler.getMessages());
                }
                outputStream.write(buffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
                responseContentItem.closeOutputStream();
            }
        }
        finally {
            if (runtime != null) {
                runtime.dispose();
            }
        }
    }

    protected void setupRequestHandler(HttpServletRequest request, HttpServletRequestHandler requestHandler) {
        String prompt = request.getParameter("prompt");
        String actionPath = request.getParameter("path");
        String processId = ((Object)((Object)this)).getClass().getName();
        String instanceId = request.getParameter("instance-id");
        requestHandler.setInstanceId(instanceId);
        requestHandler.setProcessId(processId);
        requestHandler.setActionPath(actionPath);
        requestHandler.setForcePrompt(prompt != null && prompt.equalsIgnoreCase("yes"));
    }

    protected void setupOutputHandler(HttpOutputHandler outputHandler, IParameterProvider requestParameters) {
        int outputPreference = 3;
        if (this.doSubscribe(requestParameters)) {
            outputPreference = 1;
        }
        outputHandler.setOutputPreference(outputPreference);
    }

    protected HttpServletRequestHandler getRequestHandler(HttpServletRequest request, HttpServletResponse response, IPentahoSession userSession, IParameterProvider requestParameters, OutputStream outputStream, HttpOutputHandler outputHandler, SimpleUrlFactory urlFactory) throws ServletException, IOException {
        HttpServletRequestHandler requestHandler = new HttpServletRequestHandler(userSession, null, request, outputHandler, (IPentahoUrlFactory)urlFactory);
        this.setupRequestHandler(request, requestHandler, requestParameters, userSession);
        return requestHandler;
    }

    protected HttpOutputHandler createOutputHandler(HttpServletResponse response, OutputStream outputStream) {
        return new HttpOutputHandler(response, outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            IPentahoSession userSession = this.getPentahoSession(request);
            if (!this.doBackgroundExecution(request, response, userSession)) {
                OutputStream outputStream = this.getOutputStream(response, this.doMessages(request));
                ActionSequenceJCRHelper actionHelper = new ActionSequenceJCRHelper(userSession);
                String actionPath = request.getParameter("path");
                IActionSequence actionSequence = actionHelper.getActionSequence(actionPath, PentahoSystem.loggingLevel, RepositoryFilePermission.READ);
                String fileName = null;
                if (actionSequence != null) {
                    String title = actionSequence.getTitle();
                    if (title != null && title.length() > 0) {
                        fileName = title;
                    } else {
                        String sequenceName = actionSequence.getSequenceName();
                        if (sequenceName != null && sequenceName.length() > 0) {
                            fileName = sequenceName;
                        } else {
                            List actionDefinitionsList = actionSequence.getActionDefinitionsAndSequences();
                            int i = 0;
                            boolean done = false;
                            while (actionDefinitionsList.size() > i && !done) {
                                IActionDefinition actionDefinition = (IActionDefinition)actionDefinitionsList.get(i);
                                String componentName = actionDefinition.getComponentName();
                                if (componentName != null && componentName.length() > 0) {
                                    fileName = componentName;
                                    done = true;
                                    continue;
                                }
                                ++i;
                            }
                        }
                    }
                }
                IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                HttpOutputHandler outputHandler = this.createOutputHandler(response, outputStream);
                outputHandler.setSession(userSession);
                HttpMimeTypeListener listener = new HttpMimeTypeListener(request, response, fileName);
                outputHandler.setMimeTypeListener(listener);
                SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath() + "ViewAction?");
                HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
                HttpServletRequestHandler requestHandler = this.getRequestHandler(request, response, userSession, (IParameterProvider)requestParameters, outputStream, outputHandler, urlFactory);
                this.handleActionRequest(request, response, outputHandler, requestHandler, outputStream, null);
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected boolean doSubscribe(IParameterProvider requestParameters) {
        return requestParameters.getStringParameter("subscribepage", "no").equalsIgnoreCase("yes");
    }

    protected void setupRequestHandler(HttpServletRequest request, HttpServletRequestHandler requestHandler, IParameterProvider requestParameters, IPentahoSession userSession) {
        this.setupRequestHandler(request, requestHandler);
        String actionName = requestParameters.getStringParameter("action2", null);
        if (actionName == null) {
            actionName = requestParameters.getStringParameter("action", null);
        }
        String defaultParameterXsl = PentahoSystem.getSystemSetting((String)"default-parameter-xsl", (String)"DefaultParameterForm.xsl");
        requestHandler.setParameterXsl(defaultParameterXsl);
        if (this.doSubscribe(requestParameters)) {
            requestHandler.setForcePrompt(true);
            requestHandler.setParameterProvider("PRO_EDIT_SUBSCRIPTION", requestParameters);
        }
    }
}

