/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.websocket;

import java.util.List;
import java.util.function.Predicate;
import org.pentaho.platform.api.websocket.IWebsocketEndpointConfig;

public class WebsocketEndpointConfig
implements IWebsocketEndpointConfig {
    private String urlSufix;
    private Class<?> endpointImpl;
    private List<String> subProtocolAccepted;
    private Predicate<String> isOriginAllowedPredicate;
    private int maxMessageBytesLength = 8192;
    private static WebsocketEndpointConfig instance;
    private String SERVLET_CONTEXT_PATH_PROPERTY = this.getClass().getName() + ":servletContextPath";
    private String MAX_MESSAGE_LENGTH = this.getClass().getName() + ":maximumMessageLength";

    public WebsocketEndpointConfig(String urlSufix, Class<?> endpointImpl, List<String> subProtocolAccepted, Predicate<String> isOriginAllowedPredicate, int maxMessageBytesLength) {
        this.urlSufix = urlSufix;
        this.endpointImpl = endpointImpl;
        this.subProtocolAccepted = subProtocolAccepted;
        this.isOriginAllowedPredicate = isOriginAllowedPredicate;
        this.maxMessageBytesLength = maxMessageBytesLength;
    }

    public String getUrlSufix() {
        return this.urlSufix;
    }

    public Class<?> getEndpointImpl() {
        return this.endpointImpl;
    }

    public List<String> getSubProtocolAccepted() {
        return this.subProtocolAccepted;
    }

    public Predicate<String> getIsOriginAllowedPredicate() {
        return this.isOriginAllowedPredicate;
    }

    public int getMaxMessageBytesLength() {
        return this.maxMessageBytesLength;
    }

    public String getServletContextPathPropertyName() {
        return this.SERVLET_CONTEXT_PATH_PROPERTY;
    }

    public String getMaxMessagePropertyName() {
        return this.MAX_MESSAGE_LENGTH;
    }

    public static WebsocketEndpointConfig getInstanceToReadProperties() {
        if (instance != null) {
            return instance;
        }
        instance = new WebsocketEndpointConfig(null, null, null, null, 0);
        return instance;
    }
}

