/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DenormalizedMDXTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataCellAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataMemberAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.util.ResultSetProcessingLib;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public class BandedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private static final Log logger = LogFactory.getLog(DenormalizedMDXTableModel.class);
    private Result resultSet;
    private int rowCount;
    private int columnCount;
    private int[] axesSize;
    private IntList columnToAxisPosition;
    private List<Member> columnToMemberMapping;
    private List<String> columnNames;

    @Deprecated
    public BandedMDXTableModel(Result resultSet, int rowLimit) {
        this(resultSet, rowLimit, false);
    }

    public BandedMDXTableModel(Result resultSet, int rowLimit, boolean membersOnAxisSorted) {
        ArgumentNullException.validate((String)"resultSet", (Object)resultSet);
        this.resultSet = resultSet;
        Axis[] axes = this.resultSet.getAxes();
        this.axesSize = ResultSetProcessingLib.computeItemsPerAxis(axes);
        this.rowCount = this.computeRowCount(this.axesSize);
        int[] axesMembers = ResultSetProcessingLib.computeTotalColumnsPerAxis(axes, 1, membersOnAxisSorted);
        this.columnCount = this.computeColumnCount(axesMembers, this.axesSize);
        this.columnToAxisPosition = ResultSetProcessingLib.computeColumnToAxisMapping(axes, axesMembers, this.columnCount, 1);
        this.columnToMemberMapping = Collections.unmodifiableList(ResultSetProcessingLib.computeColumnToMemberMapping(axes, axesMembers, 1, membersOnAxisSorted));
        this.columnNames = this.computeColumnNames(axes, this.columnToMemberMapping);
        if (rowLimit > 0) {
            this.rowCount = Math.min(rowLimit, this.rowCount);
        }
    }

    protected int computeColumnCount(int[] axesMembers, int[] axesSize) {
        if (axesSize.length == 0) {
            return 1;
        }
        int columnCount = axesSize[0];
        for (int i = 1; i < axesMembers.length; ++i) {
            columnCount += axesMembers[i];
        }
        return columnCount;
    }

    protected int computeRowCount(int[] axesSize) {
        if (axesSize.length > 1) {
            int rowCount = axesSize[1];
            for (int i = 2; i < axesSize.length; ++i) {
                int size = axesSize[i];
                rowCount *= size;
            }
            return rowCount;
        }
        return 1;
    }

    protected List<String> computeColumnNames(Axis[] axes, List<Member> columnToMemberMapper) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Member member : columnToMemberMapper) {
            columnNames.add(member.getLevel().getUniqueName());
        }
        if (axes.length > 0) {
            Axis axis = axes[0];
            List positions = axis.getPositions();
            for (int i = 0; i < positions.size(); ++i) {
                Position position = (Position)positions.get(i);
                columnNames.add(ResultSetProcessingLib.computeUniqueColumnName(position));
            }
        } else {
            columnNames.add("Measure");
        }
        return Collections.unmodifiableList(columnNames);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isMeasureColumn(columnIndex)) {
            int[] cellKey = this.computeCellKey(rowIndex, columnIndex);
            Cell cell = this.resultSet.getCell(cellKey);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        int[] cellKey = this.computeCellKey(rowIndex, columnIndex);
        Member candidateMember = this.getCandidateMembers(columnIndex, cellKey);
        if (candidateMember != null) {
            return candidateMember.getName();
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    private int[] computeCellKey(int rowIndex, int columnIndex) {
        int startOfColumnIndex;
        int[] cellKey = new int[this.axesSize.length];
        if (this.axesSize.length == 0) {
            return cellKey;
        }
        int correctedColIndex = this.axesSize.length > 0 ? (columnIndex < (startOfColumnIndex = this.columnCount - this.axesSize[0]) ? -1 : columnIndex - startOfColumnIndex) : 0;
        cellKey[0] = correctedColIndex;
        int tmpRowIdx = rowIndex;
        for (int i = 1; i < this.axesSize.length; ++i) {
            int pos;
            int axisSize = this.axesSize[i];
            if (axisSize == 0) {
                cellKey[i] = 0;
                continue;
            }
            cellKey[i] = pos = tmpRowIdx % axisSize;
            tmpRowIdx /= axisSize;
        }
        return cellKey;
    }

    private Member getCandidateMembers(int columnIndex, int[] cellKey) {
        int axisIndex = this.columnToAxisPosition.get(columnIndex);
        Axis[] axes = this.resultSet.getAxes();
        Axis axis = axes[axisIndex];
        List positionList = axis.getPositions();
        if (positionList.isEmpty()) {
            return null;
        }
        int posIndex = cellKey[axisIndex];
        Position position = (Position)positionList.get(posIndex);
        Member memberByName = this.findMemberByName((List<Member>)position, columnIndex);
        if (memberByName != null) {
            return memberByName;
        }
        return this.findRootMember((List<Member>)position, columnIndex);
    }

    private Member findRootMember(List<Member> position, int columnIndex) {
        Dimension dimension = this.columnToMemberMapping.get(columnIndex).getDimension();
        for (int i = 0; i < position.size(); ++i) {
            Member member = position.get(i);
            if (!dimension.equals(member.getDimension()) || member.getParentMember() != null) continue;
            return member;
        }
        return null;
    }

    private Member findMemberByName(List<Member> position, int columnIndex) {
        Dimension dimension = this.columnToMemberMapping.get(columnIndex).getDimension();
        for (int i = 0; i < position.size(); ++i) {
            Member match;
            Member member = position.get(i);
            if (!dimension.equals(member.getDimension()) || (match = this.searchContextMemberOfParents(member, columnIndex)) == null) continue;
            return match;
        }
        return null;
    }

    private Member searchContextMemberOfParents(Member member, int columnIndex) {
        String columnName = this.getColumnName(columnIndex);
        for (Member candidate = member; candidate != null; candidate = candidate.getParentMember()) {
            if (!candidate.getLevel().getUniqueName().equals(columnName)) continue;
            return candidate;
        }
        return null;
    }

    public void close() {
        this.resultSet.close();
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isMeasureColumn(columnIndex)) {
            int[] cellKey = this.computeCellKey(rowIndex, columnIndex);
            Cell cell = this.resultSet.getCell(cellKey);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        int[] cellKey = this.computeCellKey(rowIndex, columnIndex);
        Member contextMember = this.getCandidateMembers(columnIndex, cellKey);
        if (contextMember != null) {
            return new MDXMetaDataMemberAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, contextMember);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    private boolean isMeasureColumn(int columnIndex) {
        return columnIndex >= this.columnToMemberMapping.size();
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        DefaultDataAttributes dataAttributes = new DefaultDataAttributes();
        dataAttributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", DefaultConceptQueryMapper.INSTANCE, (Object)"normalized");
        return dataAttributes;
    }
}

