/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceCache;

public class DriverDataSourceProvider
implements DataSourceProvider {
    private Properties properties = new Properties();
    private String url;
    private String driver;

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Object setProperty(String key, String value) {
        if (value == null) {
            return this.properties.remove(key);
        }
        return this.properties.setProperty(key, value);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public DataSource getDataSource() throws SQLException {
        try {
            if (this.driver != null) {
                Class.forName(this.driver);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to load the driver: " + this.driver, e.getMessage());
        }
        return DriverDataSourceCache.createDataSource(this.url, this.properties);
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverDataSourceProvider that = (DriverDataSourceProvider)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.properties.equals(that.properties)) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.properties != null ? this.properties.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.driver != null ? this.driver.hashCode() : 0);
        return result;
    }

    @Override
    public Object getConnectionHash() {
        ArrayList<Object> hash = new ArrayList<Object>();
        hash.add(this.getClass().getName());
        hash.add(this.properties);
        hash.add(this.url);
        hash.add(this.driver);
        return hash;
    }
}

