/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.MaterializeTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionsActiveCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.Element;

public class CoordMaterializeTransitionXCommand
extends MaterializeTransitionXCommand {
    private JPAService jpaService = null;
    private CoordinatorJobBean coordJob = null;
    private String jobId = null;
    private Date startMatdTime = null;
    private Date endMatdTime = null;
    private final int materializationWindow;
    private int lastActionNumber = 1;
    private Job.Status prevStatus = null;
    private static final int lookAheadWindow = ConfigurationService.getInt("oozie.service.CoordMaterializeTriggerService.lookup.interval");
    public static final String CONF_DEFAULT_MAX_TIMEOUT = "oozie.service.coord.default.max.timeout";

    public CoordMaterializeTransitionXCommand(String jobId, int materializationWindow) {
        super("coord_mater", "coord_mater", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.materializationWindow = materializationWindow;
    }

    public CoordMaterializeTransitionXCommand(CoordinatorJobBean coordJob, int materializationWindow, Date startTime, Date endTime) {
        super("coord_mater", "coord_mater", 1);
        this.jobId = ParamChecker.notEmpty(coordJob.getId(), "jobId");
        this.materializationWindow = materializationWindow;
        this.coordJob = coordJob;
        this.startMatdTime = startTime;
        this.endMatdTime = endTime;
    }

    @Override
    public void transitToNext() throws CommandException {
    }

    @Override
    public void updateJob() throws CommandException {
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_MATERIALIZE, this.coordJob));
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
            for (JsonBean actionBean : this.insertList) {
                if (!(actionBean instanceof CoordinatorActionBean)) continue;
                CoordinatorActionBean coordAction = (CoordinatorActionBean)actionBean;
                if (EventHandlerService.isEnabled()) {
                    CoordinatorXCommand.generateEvent(coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), null);
                }
                this.queue(new CoordActionNotificationXCommand(coordAction), 100L);
                long checkDelay = coordAction.getNominalTime().getTime() - new Date().getTime();
                this.queue(new CoordActionInputCheckXCommand(coordAction.getId(), coordAction.getJobId()), Math.max(checkDelay, 0L));
                if (StringUtils.isEmpty((String)coordAction.getPushMissingDependencies())) continue;
                this.queue(new CoordPushDependencyCheckXCommand(coordAction.getId(), true), 100L);
            }
        }
        catch (JPAExecutorException jex) {
            throw new CommandException(jex);
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            this.LOG.error((Object)ErrorCode.E0610);
        }
        try {
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_MATERIALIZE, this.jobId);
            this.prevStatus = this.coordJob.getStatus();
        }
        catch (JPAExecutorException jex) {
            throw new CommandException(jex);
        }
        this.calcMatdTime();
        LogUtils.setLogInfo(this.coordJob);
    }

    protected void calcMatdTime() throws CommandException {
        Timestamp startTime = this.coordJob.getNextMaterializedTimestamp();
        if (startTime == null) {
            startTime = this.coordJob.getStartTimestamp();
        }
        long startTimeMilli = startTime.getTime();
        long endTimeMilli = startTimeMilli + (long)(this.materializationWindow * 1000);
        this.startMatdTime = DateUtils.toDate(new Timestamp(startTimeMilli));
        this.endMatdTime = DateUtils.toDate(new Timestamp(endTimeMilli));
        this.endMatdTime = this.getMaterializationTimeForCatchUp(this.endMatdTime);
        Date jobEndTime = this.coordJob.getEndTime();
        if (this.endMatdTime.compareTo(jobEndTime) > 0) {
            this.endMatdTime = jobEndTime;
        }
        this.LOG.debug("Materializing coord job id=" + this.jobId + ", start=" + DateUtils.formatDateOozieTZ(this.startMatdTime) + ", end=" + DateUtils.formatDateOozieTZ(this.endMatdTime) + ", window=" + this.materializationWindow);
    }

    private Date getMaterializationTimeForCatchUp(Date currentMatTime) throws CommandException {
        if (currentMatTime.after(new Date())) {
            return currentMatTime;
        }
        if (this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.LAST_ONLY) || this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.NONE)) {
            return new Date();
        }
        int frequency = 0;
        try {
            frequency = Integer.parseInt(this.coordJob.getFrequency());
        }
        catch (NumberFormatException e) {
            return currentMatTime;
        }
        TimeZone appTz = DateUtils.getTimeZone(this.coordJob.getTimeZone());
        TimeUnit freqTU = TimeUnit.valueOf(this.coordJob.getTimeUnitStr());
        Calendar startInstance = Calendar.getInstance(appTz);
        startInstance.setTime(this.startMatdTime);
        Calendar endMatInstance = null;
        Calendar previousInstance = startInstance;
        for (int i = 1; i <= this.coordJob.getMatThrottling(); ++i) {
            endMatInstance = (Calendar)startInstance.clone();
            endMatInstance.add(freqTU.getCalendarUnit(), i * frequency);
            if (endMatInstance.getTime().compareTo(new Date()) >= 0) {
                if (previousInstance.getTime().after(currentMatTime)) {
                    return previousInstance.getTime();
                }
                return currentMatTime;
            }
            previousInstance = endMatInstance;
        }
        if (endMatInstance == null) {
            return currentMatTime;
        }
        return endMatInstance.getTime();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordJob.getStatus() != Job.Status.PREP && this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.RUNNINGWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "CoordMaterializeTransitionXCommand for jobId=" + this.jobId + " job is not in PREP or RUNNING but in " + this.coordJob.getStatus());
        }
        if (this.coordJob.isDoneMaterialization()) {
            throw new PreconditionException(ErrorCode.E1100, "CoordMaterializeTransitionXCommand for jobId =" + this.jobId + " job is already materialized");
        }
        if (this.coordJob.getNextMaterializedTimestamp() != null && this.coordJob.getNextMaterializedTimestamp().compareTo(this.coordJob.getEndTimestamp()) >= 0) {
            throw new PreconditionException(ErrorCode.E1100, "CoordMaterializeTransitionXCommand for jobId=" + this.jobId + " job is already materialized");
        }
        Timestamp startTime = this.coordJob.getNextMaterializedTimestamp();
        if (startTime == null && (startTime = this.coordJob.getStartTimestamp()).after(new Timestamp(System.currentTimeMillis() + (long)(lookAheadWindow * 1000)))) {
            throw new PreconditionException(ErrorCode.E1100, "CoordMaterializeTransitionXCommand for jobId=" + this.jobId + " job's start time is not reached yet - nothing to materialize");
        }
        if (this.coordJob.getNextMaterializedTimestamp() != null && this.coordJob.getNextMaterializedTimestamp().after(new Timestamp(System.currentTimeMillis() + (long)(lookAheadWindow * 1000)))) {
            throw new PreconditionException(ErrorCode.E1100, "CoordMaterializeTransitionXCommand for jobId=" + this.jobId + " Request is for future time. Lookup time is  " + new Timestamp(System.currentTimeMillis() + (long)(lookAheadWindow * 1000)) + " mat time is " + this.coordJob.getNextMaterializedTimestamp());
        }
        if (this.coordJob.getLastActionTime() != null && this.coordJob.getLastActionTime().compareTo(this.coordJob.getEndTime()) >= 0) {
            throw new PreconditionException(ErrorCode.E1100, "ENDED Coordinator materialization for jobId = " + this.jobId + ", all actions have been materialized from start time = " + this.coordJob.getStartTime() + " to end time = " + this.coordJob.getEndTime() + ", job status = " + this.coordJob.getStatusStr());
        }
        if (this.coordJob.getLastActionTime() != null && this.coordJob.getLastActionTime().compareTo(this.endMatdTime) >= 0) {
            throw new PreconditionException(ErrorCode.E1100, "ENDED Coordinator materialization for jobId = " + this.jobId + ", action is *already* materialized for Materialization start time = " + this.startMatdTime + ", materialization end time = " + this.endMatdTime + ", job status = " + this.coordJob.getStatusStr());
        }
        if (this.endMatdTime.after(this.coordJob.getEndTime())) {
            throw new PreconditionException(ErrorCode.E1100, "ENDED Coordinator materialization for jobId = " + this.jobId + " materialization end time = " + this.endMatdTime + " surpasses coordinator job's end time = " + this.coordJob.getEndTime() + " job status = " + this.coordJob.getStatusStr());
        }
        if (this.coordJob.getPauseTime() != null && !this.startMatdTime.before(this.coordJob.getPauseTime())) {
            throw new PreconditionException(ErrorCode.E1100, "ENDED Coordinator materialization for jobId = " + this.jobId + ", materialization start time = " + this.startMatdTime + " is after or equal to coordinator job's pause time = " + this.coordJob.getPauseTime() + ", job status = " + this.coordJob.getStatusStr());
        }
    }

    @Override
    protected void materialize() throws CommandException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        cron.start();
        try {
            this.materializeActions(false);
            this.updateJobMaterializeInfo(this.coordJob);
        }
        catch (CommandException ex) {
            this.LOG.warn((Object)("Exception occurred:" + ex.getMessage() + " Making the job failed "), ex);
            this.coordJob.setStatus(Job.Status.FAILED);
            this.coordJob.resetPending();
            this.insertList.clear();
        }
        catch (Exception e) {
            this.LOG.error((Object)("Exception occurred:" + e.getMessage() + " Making the job failed "), e);
            this.coordJob.setStatus(Job.Status.FAILED);
            try {
                CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_MATERIALIZE, this.coordJob);
            }
            catch (JPAExecutorException jex) {
                throw new CommandException(ErrorCode.E1011, jex);
            }
            throw new CommandException(ErrorCode.E1012, e.getMessage(), e);
        }
        finally {
            cron.stop();
            this.instrumentation.addCron("commands", this.getName() + ".materialize", cron);
        }
    }

    protected String materializeActions(boolean dryrun) throws Exception {
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration(new StringReader(this.coordJob.getConf()));
        }
        catch (IOException ioe) {
            this.LOG.warn((Object)("Configuration parse error. read from DB :" + this.coordJob.getConf()), ioe);
            throw new CommandException(ErrorCode.E1005, ioe.getMessage(), ioe);
        }
        String jobXml = this.coordJob.getJobXml();
        Element eJob = XmlUtils.parseXml(jobXml);
        TimeZone appTz = DateUtils.getTimeZone(this.coordJob.getTimeZone());
        String frequency = this.coordJob.getFrequency();
        TimeUnit freqTU = TimeUnit.valueOf(this.coordJob.getTimeUnitStr());
        TimeUnit endOfFlag = TimeUnit.valueOf(eJob.getAttributeValue("end_of_duration"));
        Calendar start = Calendar.getInstance(appTz);
        start.setTime(this.startMatdTime);
        DateUtils.moveToEnd(start, endOfFlag);
        Calendar end = Calendar.getInstance(appTz);
        end.setTime(this.endMatdTime);
        this.lastActionNumber = this.coordJob.getLastActionNumber();
        this.LOG.info("materialize actions for tz=" + appTz.getDisplayName() + ",\n start=" + start.getTime() + ", end=" + end.getTime() + ",\n timeUnit " + freqTU.getCalendarUnit() + ",\n frequency :" + frequency + ":" + (Object)((Object)freqTU) + ",\n lastActionNumber " + this.lastActionNumber);
        Calendar origStart = Calendar.getInstance(appTz);
        origStart.setTime(this.coordJob.getStartTimestamp());
        DateUtils.moveToEnd(origStart, endOfFlag);
        StringBuilder actionStrings = new StringBuilder();
        Date jobPauseTime = this.coordJob.getPauseTime();
        Calendar pause = null;
        if (jobPauseTime != null) {
            pause = Calendar.getInstance(appTz);
            pause.setTime(DateUtils.convertDateToTimestamp(jobPauseTime));
        }
        String action = null;
        int numWaitingActions = dryrun ? 0 : this.jpaService.execute(new CoordActionsActiveCountJPAExecutor(this.coordJob.getId()));
        int maxActionToBeCreated = this.coordJob.getMatThrottling() - numWaitingActions;
        boolean ignoreMaxActions = (this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.LAST_ONLY) || this.coordJob.getExecutionOrder().equals((Object)CoordinatorJob.Execution.NONE)) && this.endMatdTime.before(new Date());
        this.LOG.debug("Coordinator job :" + this.coordJob.getId() + ", maxActionToBeCreated :" + maxActionToBeCreated + ", Mat_Throttle :" + this.coordJob.getMatThrottling() + ", numWaitingActions :" + numWaitingActions);
        boolean isCronFrequency = false;
        Calendar effStart = (Calendar)start.clone();
        try {
            int intFrequency = Integer.parseInt(this.coordJob.getFrequency());
            effStart = (Calendar)origStart.clone();
            effStart.add(freqTU.getCalendarUnit(), this.lastActionNumber * intFrequency);
        }
        catch (NumberFormatException e) {
            isCronFrequency = true;
        }
        boolean firstMater = true;
        while (!(effStart.compareTo(end) >= 0 || !ignoreMaxActions && maxActionToBeCreated-- <= 0 || pause != null && effStart.compareTo(pause) >= 0)) {
            Date nextTime = effStart.getTime();
            if (isCronFrequency) {
                if (effStart.getTime().compareTo(this.startMatdTime) == 0 && firstMater) {
                    effStart.add(12, -1);
                    firstMater = false;
                }
                nextTime = CoordCommandUtils.getNextValidActionTimeForCronFrequency(effStart.getTime(), this.coordJob);
                effStart.setTime(nextTime);
            }
            if (effStart.compareTo(end) >= 0 || pause != null && effStart.compareTo(pause) >= 0) break;
            CoordinatorActionBean actionBean = new CoordinatorActionBean();
            ++this.lastActionNumber;
            int timeout = this.coordJob.getTimeout();
            this.LOG.debug("Materializing action for time=" + DateUtils.formatDateOozieTZ(effStart.getTime()) + ", lastactionnumber=" + this.lastActionNumber + " timeout=" + timeout + " minutes");
            Date actualTime = new Date();
            action = CoordCommandUtils.materializeOneInstance(this.jobId, dryrun, (Element)eJob.clone(), nextTime, actualTime, this.lastActionNumber, jobConf, actionBean);
            actionBean.setTimeOut(timeout);
            if (!dryrun) {
                this.storeToDB(actionBean, action, jobConf);
            } else {
                actionStrings.append("action for new instance");
                actionStrings.append(action);
            }
            if (isCronFrequency) continue;
            effStart = (Calendar)origStart.clone();
            effStart.add(freqTU.getCalendarUnit(), this.lastActionNumber * Integer.parseInt(this.coordJob.getFrequency()));
        }
        if (isCronFrequency && effStart.compareTo(end) < 0 && !ignoreMaxActions && maxActionToBeCreated-- <= 0 && !firstMater) {
            effStart.setTime(CoordCommandUtils.getNextValidActionTimeForCronFrequency(effStart.getTime(), this.coordJob));
        }
        this.endMatdTime = effStart.getTime();
        if (!dryrun) {
            return action;
        }
        return actionStrings.toString();
    }

    private void storeToDB(CoordinatorActionBean actionBean, String actionXml, Configuration jobConf) throws Exception {
        this.LOG.debug("In storeToDB() coord action id = " + actionBean.getId() + ", size of actionXml = " + actionXml.length());
        actionBean.setActionXml(actionXml);
        this.insertList.add(actionBean);
        this.writeActionSlaRegistration(actionXml, actionBean, jobConf);
    }

    private void writeActionSlaRegistration(String actionXml, CoordinatorActionBean actionBean, Configuration jobConf) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml);
        Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
        SLAEventBean slaEvent = SLADbOperations.createSlaRegistrationEvent(eSla, actionBean.getId(), SLAEvent.SlaAppType.COORDINATOR_ACTION, this.coordJob.getUser(), this.coordJob.getGroup(), this.LOG);
        if (slaEvent != null) {
            this.insertList.add(slaEvent);
        }
        SLAOperations.createSlaRegistrationEvent(eSla, actionBean.getId(), actionBean.getJobId(), AppType.COORDINATOR_ACTION, this.coordJob.getUser(), this.coordJob.getAppName(), this.LOG, false, CoordUtils.isSlaAlertDisabled(actionBean, this.coordJob.getAppName(), jobConf));
    }

    private void updateJobMaterializeInfo(CoordinatorJobBean job) throws CommandException {
        job.setLastActionTime(this.endMatdTime);
        job.setLastActionNumber(this.lastActionNumber);
        Date jobEndTime = job.getEndTime();
        if (job.getStatus() == Job.Status.PREP) {
            this.LOG.info("[" + job.getId() + "]: Update status from " + job.getStatus() + " to RUNNING");
            job.setStatus(Job.Status.RUNNING);
        }
        job.setPending();
        if (jobEndTime.compareTo(this.endMatdTime) <= 0) {
            this.LOG.info("[" + job.getId() + "]: all actions have been materialized, set pending to true");
            job.setDoneMaterialization();
        }
        job.setStatus(StatusUtils.getStatus(job));
        this.LOG.info("Coord Job status updated to = " + job.getStatus());
        job.setNextMaterializedTime(this.endMatdTime);
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null && !this.prevStatus.equals((Object)this.coordJob.getStatus())) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }
}

