/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.multiple;

import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMessageIF;
import org.productivity.java.syslog4j.SyslogMessageProcessorIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.multiple.MultipleSyslogConfig;

public class MultipleSyslog
implements SyslogIF {
    private static final long serialVersionUID = 587308197526365108L;
    protected String syslogProtocol = null;
    protected MultipleSyslogConfig multipleSyslogConfig = null;

    public void initialize(String string, SyslogConfigIF syslogConfigIF) throws SyslogRuntimeException {
        this.syslogProtocol = string;
        try {
            this.multipleSyslogConfig = (MultipleSyslogConfig)syslogConfigIF;
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must be of type MultipleSyslogConfig");
        }
    }

    public SyslogConfigIF getConfig() {
        return this.multipleSyslogConfig;
    }

    public void debug(String string) {
        this.log(7, string);
    }

    public void debug(SyslogMessageIF syslogMessageIF) {
        this.log(7, syslogMessageIF);
    }

    public void critical(String string) {
        this.log(2, string);
    }

    public void critical(SyslogMessageIF syslogMessageIF) {
        this.log(2, syslogMessageIF);
    }

    public void error(String string) {
        this.log(3, string);
    }

    public void error(SyslogMessageIF syslogMessageIF) {
        this.log(3, syslogMessageIF);
    }

    public void alert(String string) {
        this.log(1, string);
    }

    public void alert(SyslogMessageIF syslogMessageIF) {
        this.log(1, syslogMessageIF);
    }

    public void notice(String string) {
        this.log(5, string);
    }

    public void notice(SyslogMessageIF syslogMessageIF) {
        this.log(5, syslogMessageIF);
    }

    public void emergency(String string) {
        this.log(0, string);
    }

    public void emergency(SyslogMessageIF syslogMessageIF) {
        this.log(0, syslogMessageIF);
    }

    public void info(String string) {
        this.log(6, string);
    }

    public void info(SyslogMessageIF syslogMessageIF) {
        this.log(6, syslogMessageIF);
    }

    public void warn(String string) {
        this.log(4, string);
    }

    public void warn(SyslogMessageIF syslogMessageIF) {
        this.log(4, syslogMessageIF);
    }

    public void log(int n, String string) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String string2 = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslogIF = Syslog.getInstance(string2);
            syslogIF.log(n, string);
        }
    }

    public void log(int n, SyslogMessageIF syslogMessageIF) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String string = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslogIF = Syslog.getInstance(string);
            syslogIF.log(n, syslogMessageIF);
        }
    }

    public void flush() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String string = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslogIF = Syslog.getInstance(string);
            syslogIF.flush();
        }
    }

    public void shutdown() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String string = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslogIF = Syslog.getInstance(string);
            syslogIF.shutdown();
        }
    }

    public void backLog(int n, String string, Throwable throwable) {
    }

    public void backLog(int n, String string, String string2) {
    }

    public void setMessageProcessor(SyslogMessageProcessorIF syslogMessageProcessorIF) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public SyslogMessageProcessorIF getMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public void setStructuredMessageProcessor(SyslogMessageProcessorIF syslogMessageProcessorIF) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public SyslogMessageProcessorIF getStructuredMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public String getProtocol() {
        return this.syslogProtocol;
    }
}

