/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.io;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.io.LobReaderCache;
import com.cloudera.sqoop.util.RandomHash;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.sqoop.io.CodecMap;
import org.apache.sqoop.io.FixedLengthInputStream;

public final class LobFile {
    public static final Log LOG = LogFactory.getLog((String)LobFile.class.getName());
    public static final int LATEST_LOB_VERSION = 0;
    public static final char[] HEADER_ID_STR = new char[]{'L', 'O', 'B'};
    public static final long SEGMENT_HEADER_ID = -1L;
    public static final long SEGMENT_OFFSET_ID = -2L;
    public static final long INDEX_TABLE_ID = -3L;

    private LobFile() {
    }

    public static LobFile.Reader open(Path p, Configuration conf) throws IOException {
        FileSystem fs = p.getFileSystem(conf);
        FileStatus[] stats = fs.listStatus(p);
        if (null == stats || stats.length == 0) {
            throw new IOException("Could not find file: " + p);
        }
        FSDataInputStream fis = fs.open(p);
        DataInputStream dis = new DataInputStream((InputStream)fis);
        LobFileHeader header = new LobFileHeader(dis);
        int version = header.getVersion();
        if (version == 0) {
            return new V0Reader(p, conf, header, dis, fis, stats[0].getLen());
        }
        throw new IOException("No reader available for LobFile version " + version);
    }

    public static LobFile.Writer create(Path p, Configuration conf, boolean isCharData, String codec, int entriesPerSegment) throws IOException {
        return new V0Writer(p, conf, isCharData, codec, entriesPerSegment);
    }

    public static LobFile.Writer create(Path p, Configuration conf, boolean isCharData, String codec) throws IOException {
        return LobFile.create(p, conf, isCharData, codec, 4096);
    }

    public static LobFile.Writer create(Path p, Configuration conf, boolean isCharData) throws IOException {
        return LobFile.create(p, conf, isCharData, null);
    }

    public static LobFile.Writer create(Path p, Configuration conf) throws IOException {
        return LobFile.create(p, conf, false);
    }

    private static class V0Writer
    extends LobFile.Writer {
        public static final Log LOG = LogFactory.getLog((String)V0Writer.class.getName());
        private Configuration conf;
        private Path path;
        private boolean isCharData;
        private LobFileHeader header;
        private String codecName;
        private CompressionCodec codec;
        private Compressor compressor;
        private LinkedList<IndexSegment> indexSegments;
        private int entriesInSegment;
        private IndexTable indexTable;
        private int maxEntriesPerSegment;
        static final int DEFAULT_MAX_SEGMENT_ENTRIES = 4096;
        private DataOutputStream out;
        private CountingOutputStream countingOut;
        private long curEntryId;
        private long curClaimedLen;
        private OutputStream userOutputStream;
        private java.io.Writer userWriter;
        private CountingOutputStream userCountingOutputStream;

        V0Writer(Path p, Configuration conf, boolean isCharData, String codecName, int entriesPerSegment) throws IOException {
            this.path = LobReaderCache.qualify(p, conf);
            this.conf = conf;
            this.isCharData = isCharData;
            this.header = new LobFileHeader();
            this.indexSegments = new LinkedList();
            this.indexTable = new IndexTable();
            this.maxEntriesPerSegment = entriesPerSegment;
            this.codecName = codecName;
            if (this.codecName != null) {
                this.codec = CodecMap.getCodec(codecName, conf);
                if (null != this.codec) {
                    this.compressor = this.codec.createCompressor();
                }
            }
            this.init();
        }

        private void init() throws IOException {
            FileSystem fs = this.path.getFileSystem(this.conf);
            FSDataOutputStream fsOut = fs.create(this.path);
            this.countingOut = new CountingOutputStream((OutputStream)new BufferedOutputStream((OutputStream)fsOut));
            this.out = new DataOutputStream((OutputStream)this.countingOut);
            MetaBlock m = this.header.getMetaBlock();
            if (this.isCharData) {
                m.put("EntryEncoding", "CLOB");
            } else {
                m.put("EntryEncoding", "BLOB");
            }
            if (null != this.codec) {
                m.put("CompressionCodec", this.codecName);
            }
            int segmentBufLen = WritableUtils.getVIntSize((long)this.maxEntriesPerSegment);
            DataOutputBuffer entriesPerSegBuf = new DataOutputBuffer(segmentBufLen);
            WritableUtils.writeVInt((DataOutput)entriesPerSegBuf, (int)this.maxEntriesPerSegment);
            byte[] entriesPerSegArray = Arrays.copyOf(entriesPerSegBuf.getData(), segmentBufLen);
            m.put("EntriesPerSegment", new BytesWritable(entriesPerSegArray));
            this.header.write(this.out);
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public long tell() throws IOException {
            this.checkForNull(this.out);
            this.out.flush();
            return this.countingOut.getByteCount();
        }

        @Override
        public void close() throws IOException {
            this.finishRecord();
            this.writeIndex();
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.countingOut != null) {
                this.countingOut.close();
                this.countingOut = null;
            }
        }

        @Override
        public void finishRecord() throws IOException {
            if (null != this.userWriter) {
                this.userWriter.close();
                this.userWriter = null;
            }
            if (null != this.userCountingOutputStream) {
                if (null != this.userOutputStream && this.userOutputStream != this.userCountingOutputStream) {
                    this.userOutputStream.close();
                }
                this.userCountingOutputStream.close();
                this.updateIndex(this.userCountingOutputStream.getByteCount() + 16L + (long)WritableUtils.getVIntSize((long)this.curEntryId) + (long)WritableUtils.getVIntSize((long)this.curClaimedLen));
                this.userOutputStream = null;
                this.userCountingOutputStream = null;
            }
            if (null != this.out) {
                this.out.flush();
            }
        }

        private void updateIndex(long curRecordLen) throws IOException {
            LOG.debug((Object)("Adding index entry: id=" + this.curEntryId + "; len=" + curRecordLen));
            this.indexSegments.getLast().addRecordLen(curRecordLen);
            ++this.entriesInSegment;
            ++this.curEntryId;
        }

        private void writeIndex() throws IOException {
            for (IndexSegment segment : this.indexSegments) {
                long segmentOffset = this.tell();
                segment.getTableEntry().setSegmentOffset(segmentOffset);
                this.header.getStartMark().write(this.out);
                segment.write(this.out);
            }
            long indexTableStartPos = this.tell();
            LOG.debug((Object)("IndexTable offset: " + indexTableStartPos));
            this.header.getStartMark().write(this.out);
            this.indexTable.write(this.out);
            this.header.getStartMark().write(this.out);
            WritableUtils.writeVLong((DataOutput)this.out, (long)-2L);
            WritableUtils.writeVLong((DataOutput)this.out, (long)indexTableStartPos);
        }

        private void startRecordIndex() throws IOException {
            if (this.entriesInSegment == this.maxEntriesPerSegment || this.indexSegments.size() == 0) {
                this.entriesInSegment = 0;
                IndexTableEntry tableEntry = new IndexTableEntry();
                IndexSegment curSegment = new IndexSegment(tableEntry);
                this.indexSegments.add(curSegment);
                long filePos = this.tell();
                LOG.debug((Object)("Starting IndexSegment; first id=" + this.curEntryId + "; off=" + filePos));
                tableEntry.setFirstIndexId(this.curEntryId);
                tableEntry.setFirstIndexOffset(filePos);
                tableEntry.setLastIndexOffset(filePos);
                this.indexTable.add(tableEntry);
            }
        }

        @Override
        public OutputStream writeBlobRecord(long claimedLen) throws IOException {
            this.finishRecord();
            this.checkForNull(this.out);
            this.startRecordIndex();
            this.header.getStartMark().write(this.out);
            LOG.debug((Object)("Starting new record; id=" + this.curEntryId + "; claimedLen=" + claimedLen));
            WritableUtils.writeVLong((DataOutput)this.out, (long)this.curEntryId);
            WritableUtils.writeVLong((DataOutput)this.out, (long)claimedLen);
            this.curClaimedLen = claimedLen;
            this.userCountingOutputStream = new CountingOutputStream((OutputStream)new CloseShieldOutputStream((OutputStream)this.out));
            if (null == this.codec) {
                this.userOutputStream = this.userCountingOutputStream;
            } else {
                this.compressor.reset();
                this.userOutputStream = new CompressorStream((OutputStream)this.userCountingOutputStream, this.compressor);
            }
            return this.userOutputStream;
        }

        @Override
        public java.io.Writer writeClobRecord(long len) throws IOException {
            if (!this.isCharData) {
                throw new IOException("Can only write CLOB data to a Clob-specific LobFile");
            }
            this.writeBlobRecord(len);
            this.userWriter = new OutputStreamWriter(this.userOutputStream);
            return this.userWriter;
        }
    }

    private static class V0Reader
    extends LobFile.Reader {
        public static final Log LOG = LogFactory.getLog((String)V0Reader.class.getName());
        private static final long MAX_CONSUMPTION_WIDTH = 524288L;
        private LobFileHeader header;
        private Configuration conf;
        private CompressionCodec codec;
        private Decompressor decompressor;
        private long fileLen;
        private boolean isAligned;
        private long claimedRecordLen;
        private long curEntryId;
        private long curRecordOffset;
        private long indexRecordLen;
        private byte[] tmpRsmBuf;
        private FSDataInputStream underlyingInput;
        private DataInputStream dataIn;
        private InputStream userInputStream;
        private IndexSegment curIndexSegment;
        private int curIndexSegmentId;
        private IndexTable indexTable;
        private Path path;

        V0Reader(Path path, Configuration conf, LobFileHeader header, DataInputStream dis, FSDataInputStream stream, long fileLen) throws IOException {
            this.path = LobReaderCache.qualify(path, conf);
            this.conf = conf;
            this.header = header;
            this.dataIn = dis;
            this.underlyingInput = stream;
            this.isAligned = false;
            this.tmpRsmBuf = new byte[16];
            this.fileLen = fileLen;
            LOG.debug((Object)("Opening LobFile path: " + path));
            this.openCodec();
            this.openIndex();
        }

        private void openCodec() throws IOException {
            String codecName = this.header.getMetaBlock().getString("CompressionCodec");
            if (null != codecName) {
                LOG.debug((Object)("Decompressing file with codec: " + codecName));
                this.codec = CodecMap.getCodec(codecName, this.conf);
                if (null != this.codec) {
                    this.decompressor = this.codec.createDecompressor();
                }
            }
        }

        private void openIndex() throws IOException {
            this.internalSeek(this.fileLen - 16L - 10L);
            byte[] finaleBuffer = new byte[26];
            this.dataIn.readFully(finaleBuffer);
            int rsmStart = this.findRecordStartMark(finaleBuffer);
            if (-1 == rsmStart) {
                throw new IOException("Corrupt file index; could not find index start offset.");
            }
            int vlongStart = rsmStart + 16;
            DataInputBuffer inBuf = new DataInputBuffer();
            inBuf.reset(finaleBuffer, vlongStart, finaleBuffer.length - vlongStart);
            long offsetMarker = WritableUtils.readVLong((DataInput)inBuf);
            if (-2L != offsetMarker) {
                throw new IOException("Invalid segment offset id: " + offsetMarker);
            }
            long indexTableStart = WritableUtils.readVLong((DataInput)inBuf);
            LOG.debug((Object)("IndexTable begins at " + indexTableStart));
            this.readIndexTable(indexTableStart);
            this.curIndexSegmentId = 0;
            this.loadIndexSegment();
        }

        private void readIndexTable(long indexTableOffset) throws IOException {
            this.internalSeek(indexTableOffset);
            this.dataIn.readFully(this.tmpRsmBuf);
            if (!this.matchesRsm(this.tmpRsmBuf)) {
                throw new IOException("Expected record start mark before IndexTable");
            }
            this.indexTable = new IndexTable(this.dataIn);
        }

        private void readNextIndexSegment() throws IOException {
            ++this.curIndexSegmentId;
            this.loadIndexSegment();
        }

        private void loadIndexSegment() throws IOException {
            if (this.indexTable.size() <= this.curIndexSegmentId || this.curIndexSegmentId < 0) {
                this.curIndexSegment = null;
                return;
            }
            IndexTableEntry tableEntry = this.indexTable.get(this.curIndexSegmentId);
            long segmentOffset = tableEntry.getSegmentOffset();
            this.internalSeek(segmentOffset);
            this.readPositionedIndexSegment();
        }

        private void readPositionedIndexSegment() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reading index segment at " + this.tell()));
            }
            this.dataIn.readFully(this.tmpRsmBuf);
            if (!this.matchesRsm(this.tmpRsmBuf)) {
                throw new IOException("Expected record start mark before IndexSegment");
            }
            this.curIndexSegment = new IndexSegment(this.indexTable.get(this.curIndexSegmentId), this.dataIn);
        }

        private boolean matchesRsm(byte[] rsm, byte[] buf, int offset) {
            for (int i = 0; i < 16; ++i) {
                if (buf[i + offset] == rsm[i]) continue;
                return false;
            }
            return true;
        }

        private boolean matchesRsm(byte[] buf, int offset) {
            return this.matchesRsm(this.header.getStartMark().getBytes(), buf, offset);
        }

        private boolean matchesRsm(byte[] buf) {
            return this.matchesRsm(buf, 0);
        }

        private int findRecordStartMark(byte[] buf) {
            byte[] rsm = this.header.getStartMark().getBytes();
            for (int i = 0; i < buf.length; ++i) {
                if (!this.matchesRsm(rsm, buf, i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public long tell() throws IOException {
            this.checkForNull((InputStream)this.underlyingInput);
            return this.underlyingInput.getPos();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.closeUserStream();
            this.checkForNull((InputStream)this.underlyingInput);
            this.isAligned = false;
            this.searchForRecord(pos);
        }

        private void searchForRecord(long start) throws IOException {
            LOG.debug((Object)("Looking for the first record at/after offset " + start));
            for (int i = 0; i < this.indexTable.size(); ++i) {
                IndexTableEntry tableEntry = this.indexTable.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Checking index table entry for range: " + tableEntry.getFirstIndexOffset() + ", " + tableEntry.getLastIndexOffset()));
                }
                if (!tableEntry.containsOffset(start)) continue;
                this.curIndexSegmentId = i;
                this.loadIndexSegment();
                LOG.debug((Object)"Found matching index segment.");
                while (this.curIndexSegment.next()) {
                    long curStart = this.curIndexSegment.getCurRecordStart();
                    if (curStart < start) continue;
                    LOG.debug((Object)("Found seek target record with offset " + curStart));
                    this.curIndexSegment.rewindOnce();
                    return;
                }
                throw new IOException("IndexTableEntry claims last offset of " + tableEntry.getLastIndexOffset() + " but IndexSegment ends early." + " The IndexTable appears corrupt.");
            }
            this.curIndexSegmentId = this.indexTable.size();
            this.loadIndexSegment();
        }

        private void consumeBytes(int numBytes) throws IOException {
            int received;
            for (int remaining = numBytes; remaining > 0; remaining -= received) {
                received = this.dataIn.skipBytes(remaining);
                if (received >= 1) continue;
                throw new IOException("Could not consume additional bytes");
            }
        }

        private void internalSeek(long targetPos) throws IOException {
            long curPos = this.underlyingInput.getPos();
            LOG.debug((Object)("Internal seek: target=" + targetPos + "; cur=" + curPos));
            long distance = targetPos - curPos;
            if (targetPos == curPos) {
                LOG.debug((Object)"(no motion required)");
                return;
            }
            if (targetPos > curPos && distance < 524288L) {
                LOG.debug((Object)("Advancing by " + distance + " bytes."));
                this.consumeBytes((int)distance);
            } else {
                LOG.debug((Object)"Direct seek to target");
                this.underlyingInput.seek(targetPos);
                this.dataIn = new DataInputStream((InputStream)this.underlyingInput);
            }
        }

        private void closeUserStream() throws IOException {
            if (this.userInputStream != null) {
                this.userInputStream.close();
                this.userInputStream = null;
            }
        }

        @Override
        public boolean next() throws IOException {
            LOG.debug((Object)"Checking for next record");
            this.checkForNull((InputStream)this.underlyingInput);
            this.closeUserStream();
            this.isAligned = false;
            if (null == this.curIndexSegment) {
                LOG.debug((Object)"Index is finished; false");
                return false;
            }
            boolean moreInSegment = this.curIndexSegment.next();
            if (!moreInSegment) {
                LOG.debug((Object)"Loading next index segment.");
                this.readNextIndexSegment();
                if (null == this.curIndexSegment) {
                    LOG.debug((Object)"Index is finished; false");
                    return false;
                }
                moreInSegment = this.curIndexSegment.next();
            }
            if (!moreInSegment) {
                LOG.debug((Object)"Last index segment is finished; false.");
                this.curIndexSegment = null;
                return false;
            }
            this.indexRecordLen = this.curIndexSegment.getCurRecordLen();
            this.curRecordOffset = this.curIndexSegment.getCurRecordStart();
            LOG.debug((Object)("Next record starts at position: " + this.curRecordOffset + "; indexedLen=" + this.indexRecordLen));
            this.internalSeek(this.curRecordOffset);
            this.dataIn.readFully(this.tmpRsmBuf);
            if (!this.matchesRsm(this.tmpRsmBuf)) {
                throw new IOException("Index contains bogus offset.");
            }
            this.curEntryId = WritableUtils.readVLong((DataInput)this.dataIn);
            if (this.curEntryId < 0L) {
                LOG.debug((Object)"Indexed position is itself an IndexSegment; false.");
                return false;
            }
            LOG.debug((Object)("Aligned on record id=" + this.curEntryId));
            this.claimedRecordLen = WritableUtils.readVLong((DataInput)this.dataIn);
            LOG.debug((Object)("Record has claimed length " + this.claimedRecordLen));
            this.isAligned = true;
            return true;
        }

        @Override
        public boolean isRecordAvailable() {
            return this.isAligned;
        }

        @Override
        public long getRecordLen() {
            return this.claimedRecordLen;
        }

        @Override
        public long getRecordId() {
            return this.curEntryId;
        }

        @Override
        public long getRecordOffset() {
            return this.curRecordOffset;
        }

        @Override
        public InputStream readBlobRecord() throws IOException {
            if (!this.isRecordAvailable() && !this.next()) {
                throw new EOFException("End of file reached.");
            }
            this.closeUserStream();
            this.isAligned = false;
            long streamLen = this.indexRecordLen - 16L - (long)WritableUtils.getVIntSize((long)this.curEntryId) - (long)WritableUtils.getVIntSize((long)this.claimedRecordLen);
            LOG.debug((Object)("Yielding stream to user with length " + streamLen));
            this.userInputStream = new FixedLengthInputStream(this.dataIn, streamLen);
            if (this.codec != null) {
                this.decompressor.reset();
                this.userInputStream = new DecompressorStream(this.userInputStream, this.decompressor);
            }
            return this.userInputStream;
        }

        @Override
        public java.io.Reader readClobRecord() throws IOException {
            InputStream is = this.readBlobRecord();
            return new InputStreamReader(is);
        }

        @Override
        public void close() throws IOException {
            this.closeUserStream();
            if (null != this.dataIn) {
                this.dataIn.close();
                this.dataIn = null;
            }
            if (null != this.underlyingInput) {
                this.underlyingInput.close();
                this.underlyingInput = null;
            }
            this.isAligned = false;
        }

        @Override
        public boolean isClosed() {
            return this.underlyingInput == null;
        }
    }

    private static class IndexTable
    implements Iterable<IndexTableEntry>,
    Writable {
        private List<IndexTableEntry> tableEntries;

        public IndexTable() {
            this.tableEntries = new ArrayList<IndexTableEntry>();
        }

        public IndexTable(DataInput in) throws IOException {
            this.readFields(in);
        }

        public void readFields(DataInput in) throws IOException {
            long recordTypeId = WritableUtils.readVLong((DataInput)in);
            if (recordTypeId != -3L) {
                throw new IOException("Expected IndexTable; got record with typeId=" + recordTypeId);
            }
            int tableCount = WritableUtils.readVInt((DataInput)in);
            this.tableEntries = new ArrayList<IndexTableEntry>(tableCount);
            for (int i = 0; i < tableCount; ++i) {
                this.tableEntries.add(new IndexTableEntry(in));
            }
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong((DataOutput)out, (long)-3L);
            WritableUtils.writeVInt((DataOutput)out, (int)this.tableEntries.size());
            for (IndexTableEntry entry : this.tableEntries) {
                entry.write(out);
            }
        }

        public void add(IndexTableEntry entry) {
            this.tableEntries.add(entry);
        }

        public IndexTableEntry get(int i) {
            return this.tableEntries.get(i);
        }

        public int size() {
            return this.tableEntries.size();
        }

        @Override
        public Iterator<IndexTableEntry> iterator() {
            return this.tableEntries.iterator();
        }
    }

    private static class IndexSegment
    implements Writable {
        private BytesWritable recordLenBytes = new BytesWritable();
        private long prevLength;
        private DataOutputBuffer outputBuffer = new DataOutputBuffer(10);
        private IndexTableEntry tableEntry;
        private DataInputBuffer dataInputBuf;
        private long curOffset;
        private long curLen;
        private int prevInputBufPos;
        private long prevOffset;
        private long prevLen;

        public IndexSegment(IndexTableEntry tableEntry) {
            this.tableEntry = tableEntry;
        }

        public IndexSegment(IndexTableEntry tableEntry, DataInput in) throws IOException {
            this.tableEntry = tableEntry;
            this.readFields(in);
        }

        public IndexTableEntry getTableEntry() {
            return this.tableEntry;
        }

        public void addRecordLen(long recordLen) throws IOException {
            int numBytes = WritableUtils.getVIntSize((long)recordLen);
            this.recordLenBytes.setSize(this.recordLenBytes.getLength() + numBytes);
            this.outputBuffer.reset();
            WritableUtils.writeVLong((DataOutput)this.outputBuffer, (long)recordLen);
            System.arraycopy(this.outputBuffer.getData(), 0, this.recordLenBytes.getBytes(), this.recordLenBytes.getLength() - numBytes, numBytes);
            this.tableEntry.setLastIndexOffset(this.tableEntry.getLastIndexOffset() + this.prevLength);
            this.prevLength = recordLen;
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong((DataOutput)out, (long)-1L);
            int segmentBytesLen = this.recordLenBytes.getLength();
            WritableUtils.writeVLong((DataOutput)out, (long)segmentBytesLen);
            out.write(this.recordLenBytes.getBytes(), 0, segmentBytesLen);
        }

        public void readFields(DataInput in) throws IOException {
            long segmentId = WritableUtils.readVLong((DataInput)in);
            if (-1L != segmentId) {
                throw new IOException("Expected segment header id -1; got " + segmentId);
            }
            long length = WritableUtils.readVLong((DataInput)in);
            if (length > Integer.MAX_VALUE) {
                throw new IOException("Unexpected oversize data array length: " + length);
            }
            if (length < 0L) {
                throw new IOException("Unexpected undersize data array length: " + length);
            }
            byte[] segmentData = new byte[(int)length];
            in.readFully(segmentData);
            this.recordLenBytes = new BytesWritable(segmentData);
            this.reset();
        }

        public void reset() {
            this.dataInputBuf = null;
        }

        public boolean next() {
            boolean available;
            this.prevOffset = this.curOffset;
            if (null == this.dataInputBuf) {
                if (null == this.recordLenBytes) {
                    return false;
                }
                this.dataInputBuf = new DataInputBuffer();
                this.dataInputBuf.reset(this.recordLenBytes.getBytes(), 0, this.recordLenBytes.getLength());
                this.curOffset = this.tableEntry.getFirstIndexOffset();
                this.prevOffset = 0L;
            } else {
                this.curOffset += this.curLen;
            }
            boolean bl = available = this.dataInputBuf.getPosition() < this.dataInputBuf.getLength();
            if (available) {
                this.prevInputBufPos = this.dataInputBuf.getPosition();
                try {
                    this.prevLen = this.curLen;
                    this.curLen = WritableUtils.readVLong((DataInput)this.dataInputBuf);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            return available;
        }

        public void rewindOnce() {
            if (this.prevInputBufPos == 0) {
                this.reset();
            } else {
                this.dataInputBuf.reset(this.recordLenBytes.getBytes(), this.prevInputBufPos, this.recordLenBytes.getLength() - this.prevInputBufPos);
                this.curLen = this.prevLen;
                this.curOffset = this.prevOffset;
            }
        }

        public long getCurRecordLen() {
            return this.curLen;
        }

        public long getCurRecordStart() {
            return this.curOffset;
        }
    }

    private static class IndexTableEntry
    implements Writable {
        private long segmentOffset;
        private long firstIndexId;
        private long firstIndexOffset;
        private long lastIndexOffset;

        public IndexTableEntry() {
        }

        public IndexTableEntry(DataInput in) throws IOException {
            this.readFields(in);
        }

        private void setSegmentOffset(long offset) {
            this.segmentOffset = offset;
        }

        private void setFirstIndexId(long id) {
            this.firstIndexId = id;
        }

        private void setFirstIndexOffset(long offset) {
            this.firstIndexOffset = offset;
        }

        private void setLastIndexOffset(long offset) {
            this.lastIndexOffset = offset;
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong((DataOutput)out, (long)this.segmentOffset);
            WritableUtils.writeVLong((DataOutput)out, (long)this.firstIndexId);
            WritableUtils.writeVLong((DataOutput)out, (long)this.firstIndexOffset);
            WritableUtils.writeVLong((DataOutput)out, (long)this.lastIndexOffset);
        }

        public void readFields(DataInput in) throws IOException {
            this.segmentOffset = WritableUtils.readVLong((DataInput)in);
            this.firstIndexId = WritableUtils.readVLong((DataInput)in);
            this.firstIndexOffset = WritableUtils.readVLong((DataInput)in);
            this.lastIndexOffset = WritableUtils.readVLong((DataInput)in);
        }

        public long getFirstIndexId() {
            return this.firstIndexId;
        }

        public long getFirstIndexOffset() {
            return this.firstIndexOffset;
        }

        public long getLastIndexOffset() {
            return this.lastIndexOffset;
        }

        public long getSegmentOffset() {
            return this.segmentOffset;
        }

        public boolean containsOffset(long off) {
            return off <= this.getLastIndexOffset();
        }
    }

    private static class MetaBlock
    extends AbstractMap<String, BytesWritable>
    implements Writable {
        public static final String ENTRY_ENCODING_KEY = "EntryEncoding";
        public static final String COMPRESSION_CODEC_KEY = "CompressionCodec";
        public static final String ENTRIES_PER_SEGMENT_KEY = "EntriesPerSegment";
        public static final String CLOB_ENCODING = "CLOB";
        public static final String BLOB_ENCODING = "BLOB";
        private Map<String, BytesWritable> entries = new TreeMap<String, BytesWritable>();

        public MetaBlock() {
        }

        public MetaBlock(DataInput in) throws IOException {
            this.readFields(in);
        }

        public MetaBlock(Map<String, BytesWritable> map) {
            for (Map.Entry<String, BytesWritable> entry : map.entrySet()) {
                this.entries.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<String, BytesWritable>> entrySet() {
            return this.entries.entrySet();
        }

        @Override
        public BytesWritable put(String k, BytesWritable v) {
            BytesWritable old = this.entries.get(k);
            this.entries.put(k, v);
            return old;
        }

        @Override
        public BytesWritable put(String k, String v) {
            try {
                return this.put(k, new BytesWritable(v.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }

        @Override
        public BytesWritable get(Object k) {
            return this.entries.get(k);
        }

        public String getString(Object k) {
            BytesWritable bytes = this.get(k);
            if (null == bytes) {
                return null;
            }
            try {
                return new String(bytes.getBytes(), 0, bytes.getLength(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }

        public void readFields(DataInput in) throws IOException {
            int numEntries = WritableUtils.readVInt((DataInput)in);
            this.entries.clear();
            for (int i = 0; i < numEntries; ++i) {
                String key = Text.readString((DataInput)in);
                BytesWritable val = new BytesWritable();
                val.readFields(in);
                this.entries.put(key, val);
            }
        }

        public void write(DataOutput out) throws IOException {
            int numEntries = this.entries.size();
            WritableUtils.writeVInt((DataOutput)out, (int)numEntries);
            for (Map.Entry<String, BytesWritable> entry : this.entries.entrySet()) {
                Text.writeString((DataOutput)out, (String)entry.getKey());
                entry.getValue().write(out);
            }
        }
    }

    private static class RecordStartMark
    implements Writable {
        public static final int START_MARK_LENGTH = 16;
        private byte[] startBytes;

        public RecordStartMark() {
            this.generateStartMark();
        }

        public RecordStartMark(DataInput in) throws IOException {
            this.readFields(in);
        }

        public byte[] getBytes() {
            byte[] out = new byte[16];
            System.arraycopy(this.startBytes, 0, out, 0, 16);
            return out;
        }

        public void readFields(DataInput in) throws IOException {
            this.startBytes = new byte[16];
            in.readFully(this.startBytes);
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.startBytes);
        }

        private void generateStartMark() {
            this.startBytes = RandomHash.generateMD5Bytes();
        }
    }

    private static class LobFileHeader
    implements Writable {
        private int version;
        private RecordStartMark startMark;
        private MetaBlock metaBlock;

        public LobFileHeader() {
            this.version = 0;
            this.startMark = new RecordStartMark();
            this.metaBlock = new MetaBlock();
        }

        public LobFileHeader(DataInput in) throws IOException {
            this.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            for (char c : HEADER_ID_STR) {
                out.writeByte(c);
            }
            WritableUtils.writeVInt((DataOutput)out, (int)this.version);
            this.startMark.write(out);
            this.metaBlock.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            char[] chars = new char[3];
            for (int i = 0; i < 3; ++i) {
                chars[i] = (char)in.readByte();
            }
            this.checkHeaderChars(chars);
            this.version = WritableUtils.readVInt((DataInput)in);
            if (this.version != 0) {
                throw new IOException("Unexpected LobFile version " + this.version);
            }
            this.startMark = new RecordStartMark(in);
            this.metaBlock = new MetaBlock(in);
        }

        private void checkHeaderChars(char[] headerStamp) throws IOException {
            if (headerStamp.length != HEADER_ID_STR.length) {
                throw new IOException("Invalid LobFile header stamp: expected length " + HEADER_ID_STR.length);
            }
            for (int i = 0; i < HEADER_ID_STR.length; ++i) {
                if (headerStamp[i] == HEADER_ID_STR[i]) continue;
                throw new IOException("Invalid LobFile header stamp");
            }
        }

        public int getVersion() {
            return this.version;
        }

        public RecordStartMark getStartMark() {
            return this.startMark;
        }

        public MetaBlock getMetaBlock() {
            return this.metaBlock;
        }
    }

    public static abstract class Reader
    implements Closeable {
        public abstract Path getPath();

        public abstract long tell() throws IOException;

        public abstract void seek(long var1) throws IOException;

        public abstract boolean next() throws IOException;

        public abstract boolean isRecordAvailable();

        public abstract long getRecordLen();

        public abstract long getRecordId();

        public abstract long getRecordOffset();

        public abstract InputStream readBlobRecord() throws IOException;

        public abstract java.io.Reader readClobRecord() throws IOException;

        @Override
        public abstract void close() throws IOException;

        protected void checkForNull(InputStream in) throws IOException {
            if (null == in) {
                throw new IOException("Reader has been closed.");
            }
        }

        public abstract boolean isClosed();

        protected synchronized void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static abstract class Writer
    implements Closeable {
        public abstract Path getPath();

        @Override
        public abstract void close() throws IOException;

        protected synchronized void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        public abstract void finishRecord() throws IOException;

        public abstract OutputStream writeBlobRecord(long var1) throws IOException;

        public abstract java.io.Writer writeClobRecord(long var1) throws IOException;

        public abstract long tell() throws IOException;

        protected void checkForNull(OutputStream out) throws IOException {
            if (null == out) {
                throw new IOException("Writer has been closed.");
            }
        }
    }
}

