/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hbase.HBaseUtil;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.DataDrivenImportJob;
import com.cloudera.sqoop.mapreduce.HBaseImportJob;
import com.cloudera.sqoop.mapreduce.JdbcExportJob;
import com.cloudera.sqoop.mapreduce.JdbcUpdateExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import com.cloudera.sqoop.util.ResultSetPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.accumulo.AccumuloUtil;
import org.apache.sqoop.mapreduce.AccumuloImportJob;
import org.apache.sqoop.mapreduce.HBaseBulkImportJob;
import org.apache.sqoop.mapreduce.JdbcCallExportJob;
import org.apache.sqoop.util.LoggingUtils;
import org.apache.sqoop.util.SqlTypeMap;

public abstract class SqlManager
extends ConnManager {
    public static final Log LOG = LogFactory.getLog((String)SqlManager.class.getName());
    public static final String SUBSTITUTE_TOKEN = "$CONDITIONS";
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    protected SqoopOptions options;
    private Statement lastStatement;

    public SqlManager(SqoopOptions opts) {
        this.options = opts;
        this.initOptionDefaults();
    }

    protected void initOptionDefaults() {
        if (this.options.getFetchSize() == null) {
            LOG.info((Object)"Using default fetchSize of 1000");
            this.options.setFetchSize(1000);
        }
    }

    protected String getColNamesQuery(String tableName) {
        return "SELECT t.* FROM " + this.escapeTableName(tableName) + " AS t WHERE 1=0";
    }

    @Override
    public String[] getColumnNames(String tableName) {
        String stmt = this.getColNamesQuery(tableName);
        return this.getColumnNamesForRawQuery(stmt);
    }

    @Override
    public String[] getColumnNamesForTeradata(String tableName) {
        String stmt = this.getColNamesQuery(tableName);
        return this.getColumnNamesForRawQuery(stmt);
    }

    @Override
    public String[] getColumnNamesForQuery(String query) {
        String rawQuery = query.replace(SUBSTITUTE_TOKEN, " (1 = 0) ");
        return this.getColumnNamesForRawQuery(rawQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnNamesForRawQuery(String stmt) {
        ResultSet results;
        try {
            results = this.execute(stmt, new Object[0]);
        }
        catch (SQLException sqlE) {
            LoggingUtils.logAll(LOG, "Error executing statement: " + sqlE.toString(), sqlE);
            this.release();
            return null;
        }
        try {
            int cols = results.getMetaData().getColumnCount();
            ArrayList<String> columns = new ArrayList<String>();
            ResultSetMetaData metadata = results.getMetaData();
            for (int i = 1; i < cols + 1; ++i) {
                String colName = "";
                if (!this.options.getIgnoreAlias().booleanValue()) {
                    colName = metadata.getColumnLabel(i);
                }
                if ((colName == null || colName.equals("")) && null == (colName = metadata.getColumnName(i))) {
                    colName = "_RESULT_" + i;
                }
                columns.add(colName);
                LOG.debug((Object)("Found column " + colName));
            }
            String[] stringArray = columns.toArray(new String[0]);
            return stringArray;
        }
        catch (SQLException sqlException) {
            LoggingUtils.logAll(LOG, "Error reading from database: " + sqlException.toString(), sqlException);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                results.close();
                this.getConnection().commit();
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQLException closing ResultSet: " + sqlE.toString(), sqlE);
            }
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNamesForProcedure(String procedureName) {
        String[] stringArray;
        ArrayList<String> ret = new ArrayList<String>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            return null;
        }
        try {
            while (results.next()) {
                int index;
                if (results.getInt("COLUMN_TYPE") == 5 || (index = results.getInt("ORDINAL_POSITION") - 1) < 0) continue;
                for (int i = ret.size(); i < index; ++i) {
                    ret.add(null);
                }
                String name = results.getString("COLUMN_NAME");
                if (index == ret.size()) {
                    ret.add(name);
                    continue;
                }
                ret.set(index, name);
            }
            LOG.debug((Object)("getColumnsNamesForProcedure returns " + StringUtils.join(ret, (String)",")));
            stringArray = ret.toArray(new String[ret.size()]);
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException e) {
                LoggingUtils.logAll(LOG, "Error reading procedure metadata: ", e);
                throw new RuntimeException("Can't fetch column names for procedure.", e);
            }
        }
        results.close();
        this.getConnection().commit();
        return stringArray;
    }

    protected String getColTypesQuery(String tableName) {
        return this.getColNamesQuery(tableName);
    }

    @Override
    public Map<String, Integer> getColumnTypes(String tableName) {
        String stmt = this.getColTypesQuery(tableName);
        return this.getColumnTypesForRawQuery(stmt);
    }

    @Override
    public Map<String, Integer> getColumnTypesForQuery(String query) {
        String rawQuery = query.replace(SUBSTITUTE_TOKEN, " (1 = 0) ");
        return this.getColumnTypesForRawQuery(rawQuery);
    }

    protected Map<String, Integer> getColumnTypesForRawQuery(String stmt) {
        Map<String, List<Integer>> colInfo = this.getColumnInfoForRawQuery(stmt);
        if (colInfo == null) {
            return null;
        }
        SqlTypeMap<String, Integer> colTypes = new SqlTypeMap<String, Integer>();
        for (String s : colInfo.keySet()) {
            List<Integer> info = colInfo.get(s);
            colTypes.put(s, info.get(0));
        }
        return colTypes;
    }

    @Override
    public Map<String, List<Integer>> getColumnInfo(String tableName) {
        String stmt = this.getColNamesQuery(tableName);
        return this.getColumnInfoForRawQuery(stmt);
    }

    @Override
    public Map<String, List<Integer>> getColumnInfoForQuery(String query) {
        String rawQuery = query.replace(SUBSTITUTE_TOKEN, " (1 = 0) ");
        return this.getColumnInfoForRawQuery(rawQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, List<Integer>> getColumnInfoForRawQuery(String stmt) {
        ResultSet results;
        LOG.debug((Object)("Execute getColumnInfoRawQuery : " + stmt));
        try {
            results = this.execute(stmt, new Object[0]);
        }
        catch (SQLException sqlE) {
            LoggingUtils.logAll(LOG, "Error executing statement: " + sqlE.toString(), sqlE);
            this.release();
            return null;
        }
        try {
            SqlTypeMap<String, List<Integer>> colInfo = new SqlTypeMap<String, List<Integer>>();
            int cols = results.getMetaData().getColumnCount();
            ResultSetMetaData metadata = results.getMetaData();
            for (int i = 1; i < cols + 1; ++i) {
                int typeId = metadata.getColumnType(i);
                int precision = metadata.getPrecision(i);
                int scale = metadata.getScale(i);
                if (typeId == 4 && !metadata.isSigned(i) || typeId == 2 && precision == 19 && scale == 0) {
                    typeId = -5;
                }
                String colName = "";
                if (!this.options.getIgnoreAlias().booleanValue()) {
                    colName = metadata.getColumnLabel(i);
                }
                if (colName == null || colName.equals("")) {
                    colName = metadata.getColumnName(i);
                }
                ArrayList<Integer> info = new ArrayList<Integer>(3);
                info.add(typeId);
                info.add(precision);
                info.add(scale);
                colInfo.put(colName, info);
                LOG.debug((Object)("Found column " + colName + " of type " + info));
            }
            SqlTypeMap<String, List<Integer>> sqlTypeMap = colInfo;
            return sqlTypeMap;
        }
        catch (SQLException sqlException) {
            LoggingUtils.logAll(LOG, "Error reading from database: " + sqlException.toString(), sqlException);
            Map<String, List<Integer>> map = null;
            return map;
        }
        finally {
            try {
                results.close();
                this.getConnection().commit();
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQLException closing ResultSet: " + sqlE.toString(), sqlE);
            }
            this.release();
        }
    }

    @Override
    public Map<String, String> getColumnTypeNamesForTable(String tableName) {
        String stmt = this.getColTypesQuery(tableName);
        return this.getColumnTypeNamesForRawQuery(stmt);
    }

    @Override
    public Map<String, String> getColumnTypeNamesForQuery(String query) {
        String rawQuery = query.replace(SUBSTITUTE_TOKEN, " (1 = 0) ");
        return this.getColumnTypeNamesForRawQuery(rawQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getColumnTypeNamesForRawQuery(String stmt) {
        ResultSet results;
        try {
            results = this.execute(stmt, new Object[0]);
        }
        catch (SQLException sqlE) {
            LoggingUtils.logAll(LOG, "Error executing statement: " + sqlE.toString(), sqlE);
            this.release();
            return null;
        }
        try {
            HashMap<String, String> colTypeNames = new HashMap<String, String>();
            int cols = results.getMetaData().getColumnCount();
            ResultSetMetaData metadata = results.getMetaData();
            for (int i = 1; i < cols + 1; ++i) {
                String colTypeName = metadata.getColumnTypeName(i);
                String colName = "";
                if (!this.options.getIgnoreAlias().booleanValue()) {
                    colName = metadata.getColumnLabel(i);
                }
                if (colName == null || colName.equals("")) {
                    colName = metadata.getColumnName(i);
                }
                colTypeNames.put(colName, colTypeName);
                LOG.debug((Object)("Found column " + colName + " of type " + colTypeName));
            }
            HashMap<String, String> hashMap = colTypeNames;
            return hashMap;
        }
        catch (SQLException sqlException) {
            LoggingUtils.logAll(LOG, "Error reading from database: " + sqlException.toString(), sqlException);
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                results.close();
                this.getConnection().commit();
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQLException closing ResultSet: " + sqlE.toString(), sqlE);
            }
            this.release();
        }
    }

    @Override
    public ResultSet readTable(String tableName, String[] columns) throws SQLException {
        if (columns == null) {
            columns = this.getColumnNames(tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        boolean first = true;
        for (String col : columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(this.escapeColName(col));
            first = false;
        }
        sb.append(" FROM ");
        sb.append(this.escapeTableName(tableName));
        sb.append(" AS ");
        sb.append(this.escapeTableName(tableName));
        String sqlCmd = sb.toString();
        LOG.debug((Object)("Reading table with command: " + sqlCmd));
        return this.execute(sqlCmd, new Object[0]);
    }

    @Override
    public String[] listDatabases() {
        LOG.error((Object)"Generic SqlManager.listDatabases() not implemented.");
        return null;
    }

    @Override
    public Map<String, Integer> getColumnTypesForProcedure(String procedureName) {
        Map<String, List<Integer>> colInfo = this.getColumnInfoForProcedure(procedureName);
        if (colInfo == null) {
            return null;
        }
        SqlTypeMap<String, Integer> colTypes = new SqlTypeMap<String, Integer>();
        for (String s : colInfo.keySet()) {
            List<Integer> info = colInfo.get(s);
            colTypes.put(s, info.get(0));
        }
        return colTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Integer>> getColumnInfoForProcedure(String procedureName) {
        TreeMap<String, List<Integer>> treeMap;
        TreeMap<String, List<Integer>> ret = new TreeMap<String, List<Integer>>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            return null;
        }
        try {
            while (results.next()) {
                if (results.getInt("COLUMN_TYPE") == 5 || results.getInt("ORDINAL_POSITION") <= 0) continue;
                ArrayList<Integer> info = new ArrayList<Integer>(3);
                info.add(results.getInt("DATA_TYPE"));
                info.add(results.getInt("PRECISION"));
                info.add(results.getInt("SCALE"));
                ret.put(results.getString("COLUMN_NAME"), info);
            }
            LOG.debug((Object)("Columns returned = " + StringUtils.join(ret.keySet(), (String)",")));
            LOG.debug((Object)("Types returned = " + StringUtils.join(ret.values(), (String)",")));
            treeMap = ret.isEmpty() ? null : ret;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException sqlException) {
                LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
                return null;
            }
        }
        results.close();
        this.getConnection().commit();
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getColumnTypeNamesForProcedure(String procedureName) {
        TreeMap<String, String> treeMap;
        TreeMap<String, String> ret = new TreeMap<String, String>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            return null;
        }
        try {
            while (results.next()) {
                if (results.getInt("COLUMN_TYPE") == 5 || results.getInt("ORDINAL_POSITION") <= 0) continue;
                ret.put(results.getString("COLUMN_NAME"), results.getString("TYPE_NAME"));
            }
            LOG.debug((Object)("Columns returned = " + StringUtils.join(ret.keySet(), (String)",")));
            LOG.debug((Object)("Type names returned = " + StringUtils.join(ret.values(), (String)",")));
            treeMap = ret.isEmpty() ? null : ret;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException sqlException) {
                LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
                return null;
            }
        }
        results.close();
        this.getConnection().commit();
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listTables() {
        ResultSet results = null;
        String[] tableTypes = new String[]{"TABLE"};
        try {
            try {
                DatabaseMetaData metaData = this.getConnection().getMetaData();
                results = metaData.getTables(null, null, null, tableTypes);
            }
            catch (SQLException sqlException) {
                LoggingUtils.logAll(LOG, "Error reading database metadata: " + sqlException.toString(), sqlException);
                String[] stringArray = null;
                if (null != results) {
                    try {
                        results.close();
                        this.getConnection().commit();
                    }
                    catch (SQLException sqlE) {
                        LoggingUtils.logAll(LOG, "Exception closing ResultSet: " + sqlE.toString(), sqlE);
                    }
                }
                return stringArray;
            }
            if (null == results) {
                String[] sqlException = null;
                return sqlException;
            }
            ArrayList<String> tables = new ArrayList<String>();
            while (results.next()) {
                String tableName = results.getString("TABLE_NAME");
                tables.add(tableName);
            }
            String[] stringArray = tables.toArray(new String[0]);
            return stringArray;
        }
        finally {
            if (null != results) {
                try {
                    results.close();
                    this.getConnection().commit();
                }
                catch (SQLException sqlE) {
                    LoggingUtils.logAll(LOG, "Exception closing ResultSet: " + sqlE.toString(), sqlE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPrimaryKey(String tableName) {
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet results = metaData.getPrimaryKeys(null, null, tableName);
            if (null == results) {
                return null;
            }
            try {
                if (results.next()) {
                    String string = results.getString("COLUMN_NAME");
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                results.close();
                this.getConnection().commit();
            }
        }
        catch (SQLException sqlException) {
            LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
            return null;
        }
    }

    @Override
    public abstract Connection getConnection() throws SQLException;

    protected String getSplitColumn(SqoopOptions opts, String tableName) {
        String splitCol = opts.getSplitByCol();
        if (null == splitCol && null != tableName) {
            splitCol = this.getPrimaryKey(tableName);
        }
        return splitCol;
    }

    protected void checkTableImportOptions(ImportJobContext context) throws IOException, ImportException {
        String tableName = context.getTableName();
        SqoopOptions opts = context.getOptions();
        String splitCol = this.getSplitColumn(opts, tableName);
        if (null == splitCol && opts.getNumMappers() > 1) {
            if (!opts.getAutoResetToOneMapper()) {
                throw new ImportException("No primary key could be found for table " + tableName + ". Please specify one with --split-by or perform " + "a sequential import with '-m 1'.");
            }
            LOG.warn((Object)"Split by column not provided or can't be inferred.  Resetting to one mapper");
            opts.setNumMappers(1);
        }
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        DataDrivenImportJob importer;
        String tableName = context.getTableName();
        String jarFile = context.getJarFile();
        SqoopOptions opts = context.getOptions();
        context.setConnManager(this);
        if (opts.getHBaseTable() != null) {
            if (!HBaseUtil.isHBaseJarPresent()) {
                throw new ImportException("HBase jars are not present in classpath, cannot import to HBase!");
            }
            importer = !opts.isBulkLoadEnabled() ? new HBaseImportJob(opts, context) : new HBaseBulkImportJob(opts, context);
        } else if (opts.getAccumuloTable() != null) {
            if (!AccumuloUtil.isAccumuloJarPresent()) {
                throw new ImportException("Accumulo jars are not present in classpath, cannot import to Accumulo!");
            }
            importer = new AccumuloImportJob(opts, context);
        } else {
            importer = new DataDrivenImportJob(opts, context.getInputFormat(), context);
        }
        this.checkTableImportOptions(context);
        String splitCol = this.getSplitColumn(opts, tableName);
        importer.runImport(tableName, jarFile, splitCol, opts.getConf());
    }

    @Override
    public void importQuery(ImportJobContext context) throws IOException, ImportException {
        DataDrivenImportJob importer;
        String jarFile = context.getJarFile();
        SqoopOptions opts = context.getOptions();
        context.setConnManager(this);
        if (opts.getHBaseTable() != null) {
            if (!HBaseUtil.isHBaseJarPresent()) {
                throw new ImportException("HBase jars are not present in classpath, cannot import to HBase!");
            }
            importer = !opts.isBulkLoadEnabled() ? new HBaseImportJob(opts, context) : new HBaseBulkImportJob(opts, context);
        } else if (opts.getAccumuloTable() != null) {
            if (!AccumuloUtil.isAccumuloJarPresent()) {
                throw new ImportException("Accumulo jars are not present in classpath, cannot import to Accumulo!");
            }
            importer = new AccumuloImportJob(opts, context);
        } else {
            importer = new DataDrivenImportJob(opts, context.getInputFormat(), context);
        }
        String splitCol = this.getSplitColumn(opts, null);
        if (splitCol == null) {
            String boundaryQuery = opts.getBoundaryQuery();
            if (opts.getNumMappers() > 1) {
                throw new ImportException("A split-by column must be specified for parallel free-form query imports. Please specify one with --split-by or perform a sequential import with '-m 1'.");
            }
            if (boundaryQuery != null && !boundaryQuery.isEmpty()) {
                throw new ImportException("Using a boundary query for a query based import requires specifying the split by column as well. Please specify a column name using --split-by and try again.");
            }
        }
        importer.runImport(null, jarFile, splitCol, opts.getConf());
    }

    protected ResultSet execute(String stmt, Integer fetchSize, Object ... args) throws SQLException {
        this.release();
        PreparedStatement statement = null;
        statement = this.getConnection().prepareStatement(stmt, 1003, 1007);
        if (fetchSize != null) {
            LOG.debug((Object)("Using fetchSize for next query: " + fetchSize));
            statement.setFetchSize(fetchSize);
        }
        this.lastStatement = statement;
        if (null != args) {
            for (int i = 0; i < args.length; ++i) {
                statement.setObject(i + 1, args[i]);
            }
        }
        LOG.info((Object)("Executing SQL statement: " + stmt));
        return statement.executeQuery();
    }

    protected ResultSet execute(String stmt, Object ... args) throws SQLException {
        return this.execute(stmt, this.options.getFetchSize(), args);
    }

    @Override
    public void close() throws SQLException {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatAndPrintResultSet(ResultSet results, PrintWriter pw) {
        try {
            try {
                int cols = results.getMetaData().getColumnCount();
                pw.println("Got " + cols + " columns back");
                if (cols > 0) {
                    ResultSetMetaData rsmd = results.getMetaData();
                    String schema = rsmd.getSchemaName(1);
                    String table = rsmd.getTableName(1);
                    if (null != schema) {
                        pw.println("Schema: " + schema);
                    }
                    if (null != table) {
                        pw.println("Table: " + table);
                    }
                }
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQLException reading result metadata: " + sqlE.toString(), sqlE);
            }
            try {
                new ResultSetPrinter().printResultSet(pw, results, this.options.getIgnoreAlias());
            }
            catch (IOException ioe) {
                LOG.error((Object)("IOException writing results: " + ioe.toString()));
                try {
                    results.close();
                    this.getConnection().commit();
                }
                catch (SQLException sqlE) {
                    LoggingUtils.logAll(LOG, "SQLException closing ResultSet: " + sqlE.toString(), sqlE);
                }
                this.release();
                return;
            }
        }
        finally {
            try {
                results.close();
                this.getConnection().commit();
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQLException closing ResultSet: " + sqlE.toString(), sqlE);
            }
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execAndPrint(String s) {
        ResultSet results = null;
        try {
            results = this.execute(s, new Object[0]);
        }
        catch (SQLException sqlE) {
            LoggingUtils.logAll(LOG, "Error executing statement: ", sqlE);
            this.release();
            return;
        }
        PrintWriter pw = new PrintWriter(System.out, true);
        try {
            this.formatAndPrintResultSet(results, pw);
        }
        finally {
            pw.close();
        }
    }

    protected Connection makeConnection() throws SQLException {
        Connection connection;
        String driverClass = this.getDriverClass();
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load db driver class: " + driverClass);
        }
        String username = this.options.getUsername();
        String password = this.options.getPassword();
        String connectString = this.options.getConnectString();
        Properties connectionParams = this.options.getConnectionParams();
        if (connectionParams != null && connectionParams.size() > 0) {
            LOG.debug((Object)"User specified connection params. Using properties specific API for making connection.");
            Properties props = new Properties();
            if (username != null) {
                props.put("user", username);
            }
            if (password != null) {
                props.put("password", password);
            }
            props.putAll((Map<?, ?>)connectionParams);
            connection = DriverManager.getConnection(connectString, props);
        } else {
            LOG.debug((Object)"No connection paramenters specified. Using regular API for making connection.");
            connection = username == null ? DriverManager.getConnection(connectString) : DriverManager.getConnection(connectString, username, password);
        }
        connection.setTransactionIsolation(this.getMetadataIsolationLevel());
        connection.setAutoCommit(false);
        return connection;
    }

    protected int getMetadataIsolationLevel() {
        return 2;
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcExportJob exportJob = new JdbcExportJob(context);
        exportJob.runExport();
    }

    @Override
    public void callTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcCallExportJob exportJob = new JdbcCallExportJob(context);
        exportJob.runExport();
    }

    @Override
    public void release() {
        if (null != this.lastStatement) {
            try {
                this.lastStatement.close();
            }
            catch (SQLException e) {
                LoggingUtils.logAll(LOG, "Exception closing executed Statement: " + e, e);
            }
            this.lastStatement = null;
        }
    }

    @Override
    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcUpdateExportJob exportJob = new JdbcUpdateExportJob(context);
        exportJob.runExport();
    }

    protected String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getCurrentDbTimestamp() {
        this.release();
        Statement s = null;
        ResultSet rs = null;
        try {
            Connection c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getCurTimestampQuery());
            if (rs == null || !rs.next()) {
                Timestamp timestamp = null;
                return timestamp;
            }
            Timestamp timestamp = rs.getTimestamp(1);
            return timestamp;
        }
        catch (SQLException sqlE) {
            LoggingUtils.logAll(LOG, "SQL exception accessing current timestamp: " + sqlE, sqlE);
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQL Exception closing resultset: " + sqlE, sqlE);
            }
            try {
                if (null != s) {
                    s.close();
                }
            }
            catch (SQLException sqlE) {
                LoggingUtils.logAll(LOG, "SQL Exception closing statement: " + sqlE, sqlE);
            }
        }
    }

    @Override
    public long getTableRowCount(String tableName) throws SQLException {
        this.release();
        tableName = this.escapeTableName(tableName);
        long result = -1L;
        String countQuery = "SELECT COUNT(*) FROM " + tableName;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            Connection conn = this.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(countQuery);
            rset.next();
            result = rset.getLong(1);
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to query count * for table " + tableName, ex);
            throw ex;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close result set", ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close statement", ex);
                }
            }
        }
        return result;
    }

    @Override
    public void deleteAllRecords(String tableName) throws SQLException {
        this.release();
        tableName = this.escapeTableName(tableName);
        String deleteQuery = "DELETE FROM " + tableName;
        Statement stmt = null;
        try {
            Connection conn = this.getConnection();
            stmt = conn.createStatement();
            int updateCount = stmt.executeUpdate(deleteQuery);
            conn.commit();
            LOG.info((Object)("Deleted " + updateCount + " records from " + tableName));
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to execute delete query: " + deleteQuery, ex);
            throw ex;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close statement", ex);
                }
            }
        }
    }

    @Override
    public void migrateData(String fromTable, String toTable) throws SQLException {
        this.release();
        fromTable = this.escapeTableName(fromTable);
        toTable = this.escapeTableName(toTable);
        String updateQuery = "INSERT INTO " + toTable + " ( SELECT * FROM " + fromTable + " )";
        String deleteQuery = "DELETE FROM " + fromTable;
        Statement stmt = null;
        try {
            Connection conn = this.getConnection();
            stmt = conn.createStatement();
            int updateCount = stmt.executeUpdate(updateQuery);
            LOG.info((Object)("Migrated " + updateCount + " records from " + fromTable + " to " + toTable));
            int deleteCount = stmt.executeUpdate(deleteQuery);
            if (updateCount != deleteCount) {
                conn.rollback();
                throw new RuntimeException("Inconsistent record counts");
            }
            conn.commit();
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to migrate data from " + fromTable + " to " + toTable, ex);
            throw ex;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close statement", ex);
                }
            }
        }
    }

    @Override
    public String getInputBoundsQuery(String splitByCol, String sanitizedQuery) {
        return this.options.getBoundaryQuery();
    }
}

