/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import pt.webdetails.cda.CdaUtils;
import pt.webdetails.cpf.SimpleContentGenerator;
import pt.webdetails.cpf.audit.CpfAuditHelper;

public class CdaContentGenerator
extends SimpleContentGenerator {
    private boolean edit = false;
    private static Log logger = LogFactory.getLog(CdaContentGenerator.class);
    public static final String PLUGIN_NAME = "cda";
    private static final long serialVersionUID = 1L;

    public void createContent() throws Exception {
        CdaUtils utils = new CdaUtils();
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        String path = this.getPathParameterAsString("path", "");
        long start = System.currentTimeMillis();
        UUID uuid = CpfAuditHelper.startAudit((String)this.getPluginName(), (String)path, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (IParameterProvider)requestParams);
        if (this.edit) {
            utils.editFile(path, this.getResponse());
        } else {
            utils.previewQuery(path, this.getResponse());
        }
        long end = System.currentTimeMillis();
        CpfAuditHelper.endAudit((String)this.getPluginName(), (String)path, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (long)start, (UUID)uuid, (long)end);
    }

    public Log getLogger() {
        return logger;
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String getObjectName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    private class MethodParams {
        public static final String PATH = "path";
        public static final String REQUEST = "request";

        private MethodParams() {
        }
    }
}

