/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPlatformReadyListener;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryMetaData;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.CdaPluginEnvironment;
import pt.webdetails.cda.ICdaEnvironment;
import pt.webdetails.cda.PentahoCdaEnvironment;
import pt.webdetails.cda.utils.mondrian.CompactBandedMDXDataFactory;
import pt.webdetails.cda.utils.mondrian.ExtBandedMDXDataFactory;
import pt.webdetails.cda.utils.mondrian.ExtDenormalizedMDXDataFactory;
import pt.webdetails.cda.utils.streaming.SQLStreamingReportDataFactory;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.SimpleLifeCycleListener;

public class CdaLifecycleListener
extends SimpleLifeCycleListener
implements IPlatformReadyListener {
    static Log logger = LogFactory.getLog(CdaLifecycleListener.class);
    private final Class[] customDataFactories = new Class[]{CompactBandedMDXDataFactory.class, ExtBandedMDXDataFactory.class, ExtDenormalizedMDXDataFactory.class, SQLStreamingReportDataFactory.class};

    public void init() throws PluginLifecycleException {
    }

    public void loaded() throws PluginLifecycleException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            super.loaded();
            PluginEnvironment.init((PluginEnvironment)CdaPluginEnvironment.getInstance());
            CdaEngine.init((ICdaEnvironment)new PentahoCdaEnvironment());
            CdaEngine.getInstance().getConfigProperty("just load", null);
            this.registerCustomDataFactories();
        }
        catch (Exception e) {
            logger.error((Object)"loading error", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    public void unLoaded() throws PluginLifecycleException {
    }

    public PluginEnvironment getEnvironment() {
        return PentahoPluginEnvironment.getInstance();
    }

    public void ready() throws PluginLifecycleException {
    }

    private void registerCustomDataFactories() {
        for (Class clazz : this.customDataFactories) {
            DefaultDataFactoryMetaData dmd = new DefaultDataFactoryMetaData(clazz.getName(), "", "", true, false, true, false, false, false, false, false, (DataFactoryCore)new DefaultDataFactoryCore(), 0);
            DataFactoryRegistry.getInstance().register((DataFactoryMetaData)dmd);
        }
    }
}

