/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.solution.SystemSettingsParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityParameterProvider;
import org.pentaho.platform.plugin.services.connections.javascript.JavaScriptResultSet;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;

public class CdaSessionFormulaContext
extends DefaultFormulaContext {
    Map<String, IParameterProvider> providers = new HashMap<String, IParameterProvider>();
    private static final String SECURITY_PREFIX = "security:";
    private static final String SESSION_PREFIX = "session:";
    private static final String SYSTEM_PREFIX = "system:";

    public CdaSessionFormulaContext(IPentahoSession session) {
        if (session != null) {
            this.providers.put(SECURITY_PREFIX, (IParameterProvider)new SecurityParameterProvider(session));
            this.providers.put(SESSION_PREFIX, (IParameterProvider)new PentahoSessionParameterProvider(session));
        }
        this.providers.put(SYSTEM_PREFIX, (IParameterProvider)new SystemSettingsParameterProvider());
    }

    public CdaSessionFormulaContext() {
        this(PentahoSessionHolder.getSession());
    }

    public Object resolveReference(Object name) {
        if (name instanceof String) {
            String paramName = ((String)name).trim();
            for (String prefix : this.providers.keySet()) {
                if (!paramName.startsWith(prefix)) continue;
                paramName = paramName.substring(prefix.length());
                Object value = this.providers.get(prefix).getParameter(paramName);
                if (value instanceof JavaScriptResultSet) {
                    JavaScriptResultSet resultSet = (JavaScriptResultSet)value;
                    return this.convertToArray(resultSet);
                }
                return value;
            }
        }
        return super.resolveReference(name);
    }

    private Object[] convertToArray(JavaScriptResultSet resultSet) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < resultSet.getRowCount(); ++i) {
            for (int j = 0; j < resultSet.getColumnCount(); ++j) {
                result.add(resultSet.getValueAt(i, j));
            }
        }
        return result.toArray();
    }
}

