/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.logging.SimpleLogger;
import pt.webdetails.cda.AccessDeniedException;
import pt.webdetails.cda.CdaCoreService;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.CdaPluginEnvironment;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.DataAccessConnectionDescriptor;
import pt.webdetails.cda.exporter.ExportOptions;
import pt.webdetails.cda.exporter.ExportedQueryResult;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.TableExporter;
import pt.webdetails.cda.exporter.UnsupportedExporterException;
import pt.webdetails.cda.services.CacheManager;
import pt.webdetails.cda.services.Editor;
import pt.webdetails.cda.services.ExtEditor;
import pt.webdetails.cda.services.Previewer;
import pt.webdetails.cda.settings.CdaSettingsReadException;
import pt.webdetails.cda.utils.CorsUtil;
import pt.webdetails.cda.utils.DoQueryParameters;
import pt.webdetails.cda.utils.Messages;
import pt.webdetails.cda.utils.QueryParameters;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.audit.CpfAuditHelper;
import pt.webdetails.cpf.messaging.JsonGeneratorSerializable;
import pt.webdetails.cpf.messaging.JsonResult;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.JsonHelper;

@Path(value="/{plugin}/api")
public class CdaUtils {
    private static final Log logger = LogFactory.getLog(CdaUtils.class);
    private static final Pattern CDA_PATH = Pattern.compile("^[^:]*([^/]+)[^?]*");
    private QueryParameters queryParametersUtil;

    public CdaUtils() {
        this.queryParametersUtil = new QueryParameters();
    }

    public CdaUtils(QueryParameters queryParametersUtil) {
        this.queryParametersUtil = queryParametersUtil;
    }

    public void setQueryParametersUtil(QueryParameters queryParametersUtil) {
        this.queryParametersUtil = queryParametersUtil;
    }

    public QueryParameters getQueryParametersUtil() {
        return this.queryParametersUtil;
    }

    protected static String getEncoding() {
        return CharsetHelper.getEncoding();
    }

    @GET
    @Path(value="/doQuery")
    @Produces(value={"application/json", "text/xml", "text/csv", "application/msexcel", "text/plain", "text/html"})
    public StreamingOutput doQueryGet(@Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws WebApplicationException {
        this.setCorsHeaders(servletRequest, servletResponse);
        return this.doQuery((MultivaluedMap<String, String>)uriInfo.getQueryParameters(), servletResponse);
    }

    @POST
    @Path(value="/doQuery")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "text/xml", "text/csv", "application/msexcel", "text/plain", "text/html"})
    public StreamingOutput doQueryPost(MultivaluedMap<String, String> formParams, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws WebApplicationException {
        this.setCorsHeaders(servletRequest, servletResponse);
        MultivaluedMap<String, String> params = formParams;
        if (formParams.size() == 0) {
            params = this.getParameterMapFromRequest(servletRequest);
        }
        return this.doQuery(params, servletResponse);
    }

    @VisibleForTesting
    protected ExportedQueryResult doQueryInternal(DoQueryParameters parameters) throws Exception {
        CdaCoreService core = this.getCdaCoreService();
        return core.doQuery(parameters);
    }

    public StreamingOutput doQuery(MultivaluedMap<String, String> params, HttpServletResponse servletResponse) throws WebApplicationException {
        long start = System.currentTimeMillis();
        ILogger auditLogger = this.getAuditLogger();
        String path = (String)((List)params.get((Object)"path")).get(0);
        UUID auditUuid = this.startAudit(path, auditLogger, params);
        try {
            DoQueryParameters parameters = this.queryParametersUtil.getDoQueryParameters(params);
            if (parameters.isWrapItUp()) {
                StreamingOutput streamingOutput = this.wrapQuery(parameters);
                return streamingOutput;
            }
            ExportedQueryResult result = this.doQueryInternal(parameters);
            result.writeHeaders(servletResponse);
            StreamingOutput streamingOutput = this.toStreamingOutput(result);
            return streamingOutput;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, 501);
        }
        finally {
            this.endAudit(path, auditLogger, start, auditUuid);
        }
    }

    private UUID startAudit(String path, ILogger auditLogger, MultivaluedMap<String, String> params) {
        String pluginName = this.getPluginName();
        String objectName = this.getObjectName();
        IPentahoSession pentahoSession = this.getPentahoSession();
        IParameterProvider requestParams = this.getParameterProvider(params);
        return CpfAuditHelper.startAudit((String)pluginName, (String)path, (String)objectName, (IPentahoSession)pentahoSession, (ILogger)auditLogger, (IParameterProvider)requestParams);
    }

    private void endAudit(String path, ILogger auditLogger, long start, UUID auditUuid) {
        long end = System.currentTimeMillis();
        String pluginName = this.getPluginName();
        String objectName = this.getObjectName();
        IPentahoSession pentahoSession = this.getPentahoSession();
        CpfAuditHelper.endAudit((String)pluginName, (String)path, (String)objectName, (IPentahoSession)pentahoSession, (ILogger)auditLogger, (long)start, (UUID)auditUuid, (long)end);
    }

    private String getObjectName() {
        return CdaUtils.class.getName();
    }

    private String getPluginName() {
        return CdaPluginEnvironment.getInstance().getPluginId();
    }

    private ILogger getAuditLogger() {
        return new SimpleLogger(CdaUtils.class.getName());
    }

    private IParameterProvider getParameterProvider(MultivaluedMap<String, String> params) {
        return new SimpleParameterProvider(params);
    }

    private StreamingOutput wrapQuery(DoQueryParameters parameters) throws Exception {
        String uuid = this.getCdaCoreService().wrapQuery(parameters);
        return out -> IOUtils.write((String)uuid, (OutputStream)out);
    }

    @GET
    @Path(value="/unwrapQuery")
    @Produces
    public void unwrapQuery(@QueryParam(value="path") String path, @QueryParam(value="uuid") String uuid, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws WebApplicationException {
        try {
            ExportedQueryResult result = this.getCdaCoreService().unwrapQuery(path, uuid);
            this.setCorsHeaders(servletRequest, servletResponse);
            result.writeResponse(servletResponse);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/listQueries")
    @Produces(value={"application/json", "text/xml", "text/csv", "application/msexcel", "text/plain", "text/html"})
    public StreamingOutput listQueries(@QueryParam(value="path") String path, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @Context HttpServletResponse servletResponse) throws WebApplicationException {
        ExportedQueryResult result;
        if (StringUtils.isEmpty((String)path)) {
            throw new IllegalArgumentException("No path provided");
        }
        logger.debug((Object)("Do Query: getSolPath:" + PentahoSystem.getApplicationContext().getSolutionPath(path)));
        try {
            result = this.getCdaCoreService().listQueries(path, this.getSimpleExportOptions(outputType));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new WebApplicationException((Throwable)e);
        }
        return this.toStreamingOutput(result);
    }

    private StreamingOutput toStreamingOutput(ExportedQueryResult result) {
        return out -> {
            try {
                result.writeOut(out);
            }
            catch (ExporterException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
    }

    private StreamingOutput toStreamingOutput(JsonGeneratorSerializable json) {
        return out -> JsonHelper.writeJson((JsonGeneratorSerializable)json, (OutputStream)out);
    }

    private StreamingOutput toErrorResult(Exception ex) {
        logger.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        return out -> JsonHelper.writeJson((JsonGeneratorSerializable)new JsonResult(false, ex.getLocalizedMessage()), (OutputStream)out);
    }

    private ExportOptions getSimpleExportOptions(String outputType) {
        return this.getSimpleExportOptions(outputType, Collections.emptyMap());
    }

    private ExportOptions getSimpleExportOptions(final String outputType, final Map<String, String> extraSettings) {
        return new ExportOptions(){

            public String getOutputType() {
                return outputType;
            }

            public Map<String, String> getExtraSettings() {
                return extraSettings;
            }
        };
    }

    @GET
    @Path(value="/listParameters")
    @Produces(value={"application/json", "text/xml", "text/csv", "application/msexcel", "text/plain", "text/html"})
    public StreamingOutput listParameters(@QueryParam(value="path") String path, @QueryParam(value="dataAccessId") String dataAccessId, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType) throws WebApplicationException {
        logger.debug((Object)("Do Query: getSolPath:" + path));
        try {
            ExportOptions exportOptions = this.getSimpleExportOptions(outputType);
            ExportedQueryResult result = this.getCdaCoreService().listParameters(path, dataAccessId, exportOptions);
            return this.toStreamingOutput(result);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    private TableExporter useExporter(CdaEngine engine, String outputType, HttpServletResponse servletResponse) throws UnsupportedExporterException {
        ExportOptions exportOptions = this.getSimpleExportOptions(outputType, null);
        return this.useExporter(engine, exportOptions, servletResponse);
    }

    private TableExporter useExporter(CdaEngine engine, ExportOptions exportOptions, HttpServletResponse servletResponse) throws UnsupportedExporterException {
        String attachmentName;
        TableExporter exporter = engine.getExporter(exportOptions);
        String mimeType = exporter.getMimeType();
        if (mimeType != null) {
            servletResponse.setHeader("Content-Type", mimeType);
        }
        if ((attachmentName = exporter.getAttachmentName()) != null) {
            servletResponse.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        return exporter;
    }

    @GET
    @Path(value="/getCdaFile")
    @Produces(value={"application/json"})
    public StreamingOutput getCdaFile(@QueryParam(value="path") String path) throws WebApplicationException {
        JsonResult json;
        String filePath = StringUtils.replace((String)path, (String)"///", (String)"/");
        try {
            String document = this.getEditor().getFile(filePath);
            json = document != null ? new JsonResult(true, document) : new JsonResult(false, "Unable to read file.");
        }
        catch (Exception e) {
            return this.toErrorResult(e);
        }
        return this.toStreamingOutput((JsonGeneratorSerializable)json);
    }

    @GET
    @Path(value="/canEdit")
    @Produces(value={"application/json"})
    public StreamingOutput canEdit(@QueryParam(value="path") String path) {
        boolean canEdit = this.getEditor().canEdit(path);
        return this.toStreamingOutput((JsonGeneratorSerializable)new JsonResult(true, JsonHelper.toJson((boolean)canEdit)));
    }

    private Editor getEditor() {
        return new Editor();
    }

    @POST
    @Path(value="/writeCdaFile")
    @Produces(value={"application/json"})
    public StreamingOutput writeCdaFile(@FormParam(value="path") String path, @FormParam(value="data") String data) {
        if (data == null) {
            logger.error((Object)("writeCdaFile: no data to save provided " + path));
            return this.toStreamingOutput((JsonGeneratorSerializable)new JsonResult(false, "No Data!"));
        }
        try {
            return this.toStreamingOutput((JsonGeneratorSerializable)new JsonResult(this.getEditor().writeFile(path, data), path));
        }
        catch (Exception e) {
            return this.toErrorResult(e);
        }
    }

    @GET
    @Path(value="/getCdaList")
    @Consumes(value={"application/xml", "application/json"})
    public void getCdaList(@DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        CdaEngine engine = CdaEngine.getInstance();
        TableExporter exporter = this.useExporter(engine, outputType, servletResponse);
        exporter.export((OutputStream)servletResponse.getOutputStream(), engine.getCdaList());
        servletResponse.getOutputStream().flush();
    }

    @GET
    @Path(value="/clearCache")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public String clearCache(@Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        String msg = "Cache Cleared Successfully";
        Boolean accessible = SecurityHelper.getInstance().isPentahoAdministrator(this.getPentahoSession());
        if (!accessible.booleanValue()) {
            msg = "Method clearCache not exposed or user does not have required permissions.";
            logger.error((Object)msg);
            servletResponse.sendError(403, msg);
            return msg;
        }
        try {
            CdaEngine.getInstance().getSettingsManager().clearCache();
            AbstractDataAccess.clearCache();
        }
        catch (Exception cce) {
            msg = "Method clearCache failed while trying to execute.";
            logger.error((Object)msg, (Throwable)cce);
            servletResponse.sendError(500, msg);
        }
        return msg;
    }

    @GET
    @Path(value="/editFile")
    @Produces(value={"text/html"})
    public String editFile(@QueryParam(value="path") String path) throws WebApplicationException, IOException {
        if (StringUtils.isEmpty((String)path)) {
            throw new WebApplicationException(400);
        }
        if (!CdaEngine.getEnvironment().canCreateContent()) {
            return Messages.getString("CdaUtils.ERROR_ACCESS_DENIED");
        }
        return this.getExtEditor().getMainEditor();
    }

    @GET
    @Path(value="/extEditor")
    @Produces(value={"text/html"})
    public String getExtEditor(@QueryParam(value="path") String path) throws WebApplicationException, IOException {
        if (StringUtils.isEmpty((String)path)) {
            throw new WebApplicationException(400);
        }
        return this.getExtEditor().getExtEditor();
    }

    public void editFile(String path, @Context HttpServletResponse servletResponse) throws IOException {
        String editFileUrl = PluginEnvironment.env().getUrlProvider().getPluginBaseUrl() + "editFile?path=" + path;
        servletResponse.sendRedirect(editFileUrl);
    }

    public void previewQuery(String path, @Context HttpServletResponse servletResponse) throws IOException {
        String previewQueryUrl = PluginEnvironment.env().getUrlProvider().getPluginBaseUrl() + "previewQuery?path=" + path;
        servletResponse.sendRedirect(previewQueryUrl);
    }

    private CacheManager getCacheManager() {
        return new CacheManager(PluginEnvironment.env().getUrlProvider(), CdaEngine.getEnvironment().getRepo());
    }

    @GET
    @Path(value="/previewQuery")
    @Produces(value={"text/html"})
    public String previewQuery(@Context HttpServletRequest servletRequest) throws Exception {
        String path = this.getPath(servletRequest);
        try {
            this.checkFileExists(path);
        }
        catch (Exception e) {
            logger.error((Object)("Error on trying to read: " + path), (Throwable)e);
            throw e;
        }
        return this.getPreviewer().previewQuery(path);
    }

    @VisibleForTesting
    void checkFileExists(String path) throws CdaSettingsReadException, AccessDeniedException {
        CdaEngine.getInstance().getSettingsManager().parseSettingsFile(path);
    }

    private String getPath(HttpServletRequest servletRequest) {
        String path = servletRequest.getParameter("path");
        if (!StringUtils.isEmpty((String)path)) {
            return path;
        }
        String uri = servletRequest.getRequestURI();
        Matcher pathFinder = CDA_PATH.matcher(uri);
        if (pathFinder.lookingAt()) {
            path = pathFinder.group(1);
            return path.replaceAll(":", "/");
        }
        return null;
    }

    @VisibleForTesting
    Previewer getPreviewer() {
        return new Previewer(PluginEnvironment.env().getUrlProvider(), CdaEngine.getEnvironment().getRepo());
    }

    private ExtEditor getExtEditor() {
        return new ExtEditor(PluginEnvironment.env().getUrlProvider(), CdaEngine.getEnvironment().getRepo());
    }

    @GET
    @Path(value="/listDataAccessTypes")
    @Produces(value={"application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public String listDataAccessTypes(@DefaultValue(value="false") @QueryParam(value="refreshCache") Boolean refreshCache) {
        DataAccessConnectionDescriptor[] data = CdaEngine.getInstance().getSettingsManager().getDataAccessDescriptors(refreshCache.booleanValue());
        StringBuilder output = new StringBuilder();
        if (data != null) {
            output.append("{\n");
            for (DataAccessConnectionDescriptor datum : data) {
                output.append(datum.toJSON()).append(",\n");
            }
            return output.toString().replaceAll(",\n\\z", "\n}");
        }
        return "";
    }

    @GET
    @Path(value="/manageCache")
    @Produces(value={"text/html"})
    public String manageCache() throws Exception {
        return this.getCacheManager().manageCache();
    }

    private IPentahoSession getPentahoSession() {
        return PentahoSessionHolder.getSession();
    }

    private CdaCoreService getCdaCoreService() {
        return new CdaCoreService(CdaEngine.getInstance());
    }

    @Deprecated
    public void listQueriesInterPluginOld(@QueryParam(value="path") String path, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws WebApplicationException, IOException {
        StreamingOutput so = this.listQueries(path, outputType, servletResponse);
        so.write((OutputStream)servletResponse.getOutputStream());
    }

    @Deprecated
    public void doQueryInterPluginOld(@Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        ExportedQueryResult result = this.doQueryInternal(this.queryParametersUtil.getDoQueryParameters(this.getParameterMapFromRequest(servletRequest)));
        result.writeResponse(servletResponse);
    }

    public String doQueryInterPlugin(@Context HttpServletRequest servletRequest) throws Exception {
        return this.doQueryInternal(this.queryParametersUtil.getDoQueryParameters(this.getParameterMapFromRequest(servletRequest))).asString();
    }

    private MultivaluedMap<String, String> getParameterMapFromRequest(HttpServletRequest servletRequest) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        Enumeration enumeration = servletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            String[] values = servletRequest.getParameterValues(param);
            if (values.length == 1) {
                params.add((Object)param, (Object)values[0]);
                continue;
            }
            ArrayList list = new ArrayList();
            Collections.addAll(list, values);
            params.put((Object)param, list);
        }
        return params;
    }

    private void setCorsHeaders(HttpServletRequest request, HttpServletResponse response) {
        CorsUtil.getInstance().setCorsHeaders(request, response);
    }

    @Deprecated
    public void listParameters(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @DefaultValue(value="<blank>") @QueryParam(value="dataAccessId") String dataAccessId, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        logger.debug((Object)("Do Query: getSolPath:" + path));
        try {
            ExportOptions exportOptions = this.getSimpleExportOptions(outputType);
            ExportedQueryResult result = this.getCdaCoreService().listParameters(path, dataAccessId, exportOptions);
            result.writeOut((OutputStream)servletResponse.getOutputStream());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @Deprecated
    public void doQueryPost(@FormParam(value="path") String path, @DefaultValue(value="json") @FormParam(value="outputType") String outputType, @DefaultValue(value="1") @FormParam(value="outputIndexId") int outputIndexId, @DefaultValue(value="1") @FormParam(value="dataAccessId") String dataAccessId, @DefaultValue(value="false") @FormParam(value="bypassCache") Boolean bypassCache, @DefaultValue(value="false") @FormParam(value="paginateQuery") Boolean paginateQuery, @DefaultValue(value="0") @FormParam(value="pageSize") int pageSize, @DefaultValue(value="0") @FormParam(value="pageStart") int pageStart, @DefaultValue(value="false") @FormParam(value="wrapItUp") Boolean wrapItUp, @FormParam(value="sortBy") List<String> sortBy, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        DoQueryParameters parameters = new DoQueryParameters(path);
        parameters.setOutputType(outputType);
        parameters.setOutputIndexId(outputIndexId);
        parameters.setDataAccessId(dataAccessId);
        parameters.setBypassCache(bypassCache.booleanValue());
        parameters.setPageSize(pageSize);
        parameters.setPageStart(pageStart);
        parameters.setWrapItUp(wrapItUp.booleanValue());
        parameters.setSortBy(sortBy);
        ExportedQueryResult result = this.doQueryInternal(parameters);
        result.writeResponse(servletResponse);
    }
}

