/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import pt.webdetails.cda.BaseCdaEnvironment;
import pt.webdetails.cda.CdaPluginEnvironment;
import pt.webdetails.cda.CdaSessionFormulaContext;
import pt.webdetails.cda.ICdaEnvironment;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.utils.framework.PluginUtils;
import pt.webdetails.cpf.bean.IBeanFactory;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.session.IUserSession;
import pt.webdetails.cpf.session.PentahoSessionUtils;

public abstract class PentahoBaseCdaEnvironment
extends BaseCdaEnvironment
implements ICdaEnvironment {
    private IQueryCache cacheImpl;
    private IAuthorizationPolicy authorizationPolicy;

    public void init(IBeanFactory beanFactory) {
        super.init(beanFactory);
        if (beanFactory.containsBean(IAuthorizationPolicy.class.getSimpleName())) {
            this.authorizationPolicy = (IAuthorizationPolicy)beanFactory.getBean(IAuthorizationPolicy.class.getSimpleName());
        }
    }

    public IQueryCache getQueryCache() {
        try {
            if (this.cacheImpl == null) {
                this.cacheImpl = PluginUtils.getPluginBean("cda.", IQueryCache.class);
            }
            return this.cacheImpl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return super.getQueryCache();
        }
    }

    public IContentAccessFactory getRepo() {
        return CdaPluginEnvironment.repository();
    }

    public FormulaContext getFormulaContext() {
        return new CdaSessionFormulaContext();
    }

    public IUserSession getUserSession() {
        return new PentahoSessionUtils().getCurrentSession();
    }

    public boolean canCreateContent() {
        if (this.authorizationPolicy == null) {
            this.authorizationPolicy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
            if (this.authorizationPolicy == null) {
                logger.warn((Object)"Couldn't retrieve Authorization Policy");
                return this.getUserSession().isAdministrator();
            }
        }
        return this.authorizationPolicy.isAllowed("org.pentaho.repository.create");
    }
}

