/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.scheduler;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.scheduler2.IJobFilter;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.scheduler2.quartz.QuartzScheduler;
import pt.webdetails.cda.AccessDeniedException;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.scheduler.QueryExecution;
import pt.webdetails.cda.cache.scheduler.ScheduledQueryExecution;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.services.BaseService;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.SettingsManager;
import pt.webdetails.cda.utils.PentahoHelper;
import pt.webdetails.cpf.messaging.JsonGeneratorSerializable;

public class CdaCacheScheduler
extends BaseService {
    private static final String JOB_NAME_PREFIX = "CDA-sched/";
    private static final String SUGAR_SCHEDULER_BEAN_ID = "IScheduler2";
    private static final String ACTION_BEAN_ID = "CdaCacheWarmup";
    private static final String STATUS_OK = "ok";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_FIELD = "status";

    public JsonGeneratorSerializable scheduleQueryExecution(String jsonString) {
        try {
            QueryExecution query = new QueryExecution(this.getSettingsManager(), jsonString);
            this.checkSchedulerAccess(query, PentahoSessionHolder.getSession());
            final Job job = this.scheduleQuery(query);
            if (job != null) {
                this.logJob(job);
                return new JsonGeneratorSerializable(){

                    public void writeToGenerator(JsonGenerator out) throws JsonGenerationException, IOException {
                        out.writeStartObject();
                        out.writeStringField(CdaCacheScheduler.STATUS_FIELD, CdaCacheScheduler.STATUS_OK);
                        out.writeStringField("jobId", job.getJobId());
                        out.writeEndObject();
                    }
                };
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)e);
            return this.getError(e);
        }
        return null;
    }

    public JsonGeneratorSerializable deleteJob(String id) {
        try {
            this.checkJobAccess(id, PentahoSessionHolder.getSession());
            IScheduler scheduler = this.getScheduler();
            scheduler.removeJob(id);
        }
        catch (Exception e) {
            return this.getError(e);
        }
        return new JsonGeneratorSerializable(){

            public void writeToGenerator(JsonGenerator out) throws JsonGenerationException, IOException {
                out.writeStartObject();
                out.writeStringField(CdaCacheScheduler.STATUS_FIELD, CdaCacheScheduler.STATUS_OK);
                out.writeEndObject();
            }
        };
    }

    public JsonGeneratorSerializable executeJob(String id) {
        IScheduler scheduler = this.getScheduler();
        try {
            this.checkJobAccess(id, PentahoSessionHolder.getSession());
            scheduler.triggerNow(id);
        }
        catch (Exception e) {
            return this.getError(e);
        }
        return new JsonGeneratorSerializable(){

            public void writeToGenerator(JsonGenerator out) throws JsonGenerationException, IOException {
                out.writeStartObject();
                out.writeStringField(CdaCacheScheduler.STATUS_FIELD, CdaCacheScheduler.STATUS_OK);
                out.writeEndObject();
            }
        };
    }

    public JsonGeneratorSerializable listScheduledQueries() {
        IScheduler scheduler = this.getScheduler();
        try {
            List jobs = scheduler.getJobs(this.getCdaJobFilter());
            final ArrayList<JsonGeneratorSerializable> queries = new ArrayList<JsonGeneratorSerializable>();
            for (Job job : jobs) {
                try {
                    String jsonString = (String)job.getJobParams().get("cdaQuery");
                    queries.add(CdaCacheScheduler.toCachedQueryJson(new ScheduledQueryExecution(this.getSettingsManager(), jsonString, job)));
                }
                catch (Exception e) {
                    this.getLog().error((Object)"Error reading job info.", (Throwable)e);
                }
            }
            return new JsonGeneratorSerializable(){

                public void writeToGenerator(JsonGenerator out) throws JsonGenerationException, IOException {
                    out.writeStartObject();
                    out.writeStringField(CdaCacheScheduler.STATUS_FIELD, CdaCacheScheduler.STATUS_OK);
                    out.writeFieldName("queries");
                    out.writeStartArray();
                    for (JsonGeneratorSerializable query : queries) {
                        query.writeToGenerator(out);
                    }
                    out.writeEndArray();
                    out.writeEndObject();
                }
            };
        }
        catch (SchedulerException e) {
            this.getLog().error((Object)" Error fetching job list.", (Throwable)e);
            return null;
        }
    }

    private SettingsManager getSettingsManager() {
        return CdaEngine.getInstance().getSettingsManager();
    }

    private IJobFilter getCdaJobFilter() {
        return new IJobFilter(){

            public boolean accept(Job job) {
                return job.getJobName().startsWith(CdaCacheScheduler.JOB_NAME_PREFIX) && job.getJobParams().containsKey("cdaQuery") && job.getNextRun() != null && job.getNextRun().getTime() > 0L;
            }
        };
    }

    private void checkSchedulerAccess(QueryExecution queryExec, IPentahoSession session) throws AccessDeniedException {
        if (!this.canSchedule(queryExec)) {
            throw new AccessDeniedException(String.format("User %s cannot schedule %s", session.getName(), queryExec.getCdaSettings().getId()), null);
        }
    }

    private void checkJobAccess(String jobId, IPentahoSession session) throws AccessDeniedException, SchedulerException {
        IScheduler scheduler = this.getScheduler();
        Job job = scheduler.getJob(jobId);
        if (job == null) {
            throw new IllegalArgumentException("No such job.");
        }
        if (!session.getName().equals(job.getUserName()) && !PentahoHelper.isAdmin(session)) {
            throw new AccessDeniedException("User must be admin or be the job owner to access existing job ", null);
        }
    }

    private boolean canSchedule(QueryExecution queryExec) {
        IAuthorizationPolicy authPolicy = this.getAuthorizationPolicy();
        if (authPolicy == null) {
            this.getLog().error((Object)String.format("Unable to get authorization policy (%s)", IAuthorizationPolicy.class.getName()));
            return false;
        }
        return authPolicy.isAllowed("org.pentaho.scheduler.manage");
    }

    private IAuthorizationPolicy getAuthorizationPolicy() {
        return (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
    }

    private IScheduler getScheduler() {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)SUGAR_SCHEDULER_BEAN_ID, null);
        if (scheduler == null) {
            this.getLog().warn((Object)String.format("Scheduler bean '%s' not found, falling back to default", new Object[0]));
            return (IScheduler)PentahoSystem.get(IScheduler.class);
        }
        return scheduler;
    }

    private Job scheduleQuery(QueryExecution query) {
        try {
            CdaSettings cdaSettings = query.getCdaSettings();
            QueryOptions queryOpts = query.getQueryOptions();
            String cron = query.getCronString();
            String jobName = this.getJobName(cdaSettings, queryOpts);
            IScheduler scheduler = this.getScheduler();
            HashMap<String, String> actionParameters = new HashMap<String, String>();
            actionParameters.put("cdaQuery", query.getJsonString());
            IJobTrigger trigger = this.createTrigger(cron);
            return scheduler.createJob(jobName, ACTION_BEAN_ID, actionParameters, trigger);
        }
        catch (SchedulerException e) {
            this.getLog().error((Object)"Unable to schedule query.", (Throwable)e);
            return null;
        }
    }

    public static String getCronString(JSONObject json) throws JSONException {
        return json.getString("cronString");
    }

    private IJobTrigger createTrigger(String cron) {
        String[] split = StringUtils.split((String)cron);
        if (split == null || split.length < 6) {
            throw new IllegalArgumentException("Illegal cron string.");
        }
        if (split.length == 6) {
            cron = cron + " *";
        }
        return QuartzScheduler.createComplexTrigger((String)cron);
    }

    private void logJob(Job job) {
        Log log = this.getLog();
        log.info((Object)String.format("Job id=\"%s\", name=\"%s\",  ", job.getJobId(), job.getJobName()));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\t state=%s, next execution at %s, ", job.getState(), job.getNextRun()));
        }
    }

    public String getJobName(CdaSettings cda, QueryOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append(JOB_NAME_PREFIX);
        sb.append(cda.getId());
        sb.append("/");
        sb.append(options.getDataAccessId());
        return sb.toString();
    }

    private static JsonGeneratorSerializable toCachedQueryJson(final ScheduledQueryExecution query) {
        return new JsonGeneratorSerializable(){

            public void writeToGenerator(JsonGenerator out) throws JsonGenerationException, IOException {
                Job job = query.getJob();
                QueryOptions opts = query.getQueryOptions();
                out.writeStartObject();
                out.writeStringField("id", job.getJobId());
                out.writeStringField("cdaFile", query.getCdaSettings().getId());
                out.writeStringField("dataAccessId", opts.getDataAccessId());
                out.writeObjectFieldStart("parameters");
                for (Parameter param : opts.getParameters()) {
                    out.writeStringField(param.getName(), param.getStringValue());
                }
                out.writeEndObject();
                out.writeNumberField("nextExecution", job.getNextRun() != null ? job.getNextRun().getTime() : 0L);
                out.writeNumberField("lastExecuted", job.getLastRun() != null ? job.getLastRun().getTime() : 0L);
                out.writeStringField("cronString", job.getJobTrigger().getCronString());
                out.writeNumberField("timeElapsed", -1);
                out.writeBooleanField("success", job.getState() == Job.JobState.NORMAL);
                out.writeEndObject();
            }
        };
    }

    private JsonGeneratorSerializable getError(final Exception e) {
        return new JsonGeneratorSerializable(){

            public void writeToGenerator(JsonGenerator out) throws JsonGenerationException, IOException {
                out.writeStartObject();
                out.writeStringField(CdaCacheScheduler.STATUS_FIELD, CdaCacheScheduler.STATUS_ERROR);
                out.writeStringField("errorMsg", e.getLocalizedMessage());
                out.writeEndObject();
            }
        };
    }
}

