/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.scheduler;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cda.AccessDeniedException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.CdaSettingsReadException;
import pt.webdetails.cda.settings.SettingsManager;

public class QueryExecution {
    private CdaSettings cdaSettings;
    private QueryOptions queryOptions;
    private String cronString;
    private String jsonString;

    public QueryExecution(SettingsManager settingsMgr, String jsonString) throws JSONException, CdaSettingsReadException, AccessDeniedException {
        JSONObject json = new JSONObject(jsonString);
        this.jsonString = jsonString;
        String cdaFile = json.getString("cdaFile");
        this.cdaSettings = settingsMgr.parseSettingsFile(cdaFile);
        this.queryOptions = QueryExecution.createQueryOptions(json);
        this.cronString = json.getString("cronString");
    }

    public CdaSettings getCdaSettings() {
        return this.cdaSettings;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public String getCronString() {
        return this.cronString;
    }

    public static QueryOptions createQueryOptions(JSONObject json) throws JSONException {
        Object parameters;
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setDataAccessId(json.getString("dataAccessId"));
        if (json.has("parameters") && (parameters = json.get("parameters")) instanceof JSONArray) {
            JSONArray parametersArray = (JSONArray)parameters;
            for (int i = 0; i < parametersArray.length(); ++i) {
                JSONObject param = parametersArray.getJSONObject(i);
                String name = param.getString("name");
                JSONArray arrayOpt = param.optJSONArray("value");
                if (arrayOpt != null) {
                    String[] values = new String[arrayOpt.length()];
                    for (int j = 0; j < values.length; ++j) {
                        values[i] = arrayOpt.getString(j);
                    }
                    queryOpts.addParameter(name, (Object)values);
                    continue;
                }
                String value = param.getString("value");
                queryOpts.addParameter(name, (Object)value);
            }
        }
        queryOpts.setCacheBypass(true);
        return queryOpts;
    }
}

