/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.services.BaseService;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.utils.Pair;

public abstract class ProcessedHtmlPage
extends BaseService {
    private static Log log = LogFactory.getLog(ProcessedHtmlPage.class);
    protected static final Pattern URL_PROTOCOL = Pattern.compile("^\\w*\\:");
    private static final String CODE_SNIPPET_START_TAG = String.format("<script type=\"%s\">\n", "text/javascript");
    private static final String CODE_SNIPPET_END_TAG = "\n</script>\n";
    private IUrlProvider urlProvider;
    private IContentAccessFactory access;

    protected ProcessedHtmlPage(IUrlProvider urlProvider, IContentAccessFactory access) {
        this.urlProvider = urlProvider;
        this.access = access;
    }

    private IUrlProvider getUrlProvider() {
        return this.urlProvider;
    }

    private IContentAccessFactory getRepo() {
        return this.access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processPage(PathOrigin baseDir, String pagePath) throws IOException {
        String string;
        long start = System.currentTimeMillis();
        InputStream file = null;
        try {
            file = baseDir.getReader(this.getRepo()).getFileInputStream(pagePath);
            Source html = new Source(file);
            OutputDocument outDoc = new OutputDocument(html);
            this.modifyDocument(html, baseDir, outDoc);
            string = outDoc.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(file);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("processPage for %s took %dms", pagePath, System.currentTimeMillis() - start));
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)file);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processPage for %s took %dms", pagePath, System.currentTimeMillis() - start));
        }
        return string;
    }

    protected void modifyDocument(Source html, PathOrigin baseDir, OutputDocument out) {
        this.replaceUrlAttribute(html.getAllStartTags("link"), "href", baseDir, out);
        this.replaceUrlAttribute(html.getAllStartTags("script"), "src", baseDir, out);
        this.replaceUrlAttribute(html.getAllStartTags("img"), "src", baseDir, out);
        int insertPos = html.getFirstElement("head").getEndTag().getBegin();
        out.insert(insertPos, (CharSequence)this.getCodeSnippet(this.getBackendAssignments(this.getUrlProvider())));
    }

    protected abstract Iterable<Pair<String, String>> getBackendAssignments(IUrlProvider var1);

    protected String getCodeSnippet(Iterable<Pair<String, String>> assignments) {
        StringBuilder element = new StringBuilder(CODE_SNIPPET_START_TAG);
        for (Pair<String, String> assignment : assignments) {
            element.append((String)assignment.first).append(" = ").append((String)assignment.second).append(";\n");
        }
        element.append(CODE_SNIPPET_END_TAG);
        return element.toString();
    }

    protected boolean shouldProcessPath(String path) {
        return !StringUtils.isEmpty((String)path) && !path.startsWith("/") && !URL_PROTOCOL.matcher(path).find();
    }

    protected String processPath(PathOrigin origin, String path, IUrlProvider urlProvider) {
        return ProcessedHtmlPage.normalizeUri(origin.getUrl(path, urlProvider));
    }

    protected int replaceUrlAttribute(Iterable<StartTag> tags, String pathAttribute, PathOrigin baseDir, OutputDocument doc) {
        int count = 0;
        for (StartTag tag : tags) {
            Attributes attr = tag.parseAttributes();
            String path = attr.getValue(pathAttribute);
            if (!this.shouldProcessPath(path)) continue;
            String newPath = this.processPath(baseDir, path, this.getUrlProvider());
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("replaced: in %s@%s \"%s\" --> \"%s\"", tag.getName(), pathAttribute, path, newPath));
            }
            doc.replace(attr, true).put(pathAttribute, newPath);
            ++count;
        }
        return count;
    }

    private static String normalizeUri(String path) {
        try {
            URI uri = new URI(path);
            return uri.normalize().getPath();
        }
        catch (URISyntaxException e) {
            log.error((Object)("normalizeUri: cannot process path " + path), (Throwable)e);
            return path;
        }
    }
}

