/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.teradatabulkloader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderData;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderMeta;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderRoutines;

public class TeraDataBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TeraDataBulkLoaderMeta.class;
    public static String[] ActionTypes = new String[]{BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Insert.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Upsert.Label", (String[])new String[0])};
    public static String[] ScriptTypes = new String[]{BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ScriptOptionGenerate.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ScriptOptionUseExisting.Label", (String[])new String[0])};
    public static final long DEFAULT_ERROR_CODE = 1L;
    private TeraDataBulkLoaderMeta meta;
    TeraDataBulkLoaderData data;
    private final long threadWaitTime = 300000L;
    private final String threadWaitTimeText = "5min";
    private String tempScriptFile;

    public TeraDataBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void executeLoadCommand() throws Exception {
        TeraDataBulkLoaderRoutines routines = new TeraDataBulkLoaderRoutines(this, this.meta);
        this.tempScriptFile = routines.createScriptFile();
        this.data.tbuildThread = new TbuildThread(this);
        this.data.tbuildThread.start();
        if (!Const.isWindows()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.OpeningPipe", (String[])new String[]{this.data.fifoFilename}));
            OpenFifo openFifo = new OpenFifo(this.data.fifoFilename, 1000);
            openFifo.start();
            while (true) {
                openFifo.join(200L);
                if (openFifo.getState() == Thread.State.TERMINATED) break;
                try {
                    this.data.tbuildThread.checkExcn();
                }
                catch (Exception e) {
                    new DataInputStream(new FileInputStream(this.data.fifoFilename)).close();
                    openFifo.join();
                    this.logError("Execution error in tbuild: " + e);
                    throw e;
                }
                openFifo.checkExcn();
            }
            this.data.fifoStream = openFifo.getFifoStream();
        }
    }

    public boolean execute(TeraDataBulkLoaderMeta meta) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            this.data.fifoFilename = this.environmentSubstitute(meta.getFifoFileName());
            if (meta.isRandomizeFifoFilename()) {
                this.data.fifoFilename = this.data.fifoFilename + "." + new Random().nextInt(2139999999);
            }
            this.setVariable("TPT_FIFO_FILENAME", this.data.fifoFilename);
            File fifoFile = new File(this.data.fifoFilename);
            if (!fifoFile.exists()) {
                String mkFifoCmd = "mkfifo " + this.data.fifoFilename;
                this.logDetailed(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.CreatePipe", (String[])new String[]{mkFifoCmd}));
                Process mkFifoProcess = rt.exec(mkFifoCmd);
                StreamLogger errorLogger = new StreamLogger(this.log, mkFifoProcess.getErrorStream(), "mkFifoError");
                StreamLogger outputLogger = new StreamLogger(this.log, mkFifoProcess.getInputStream(), "mkFifoOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                int result = mkFifoProcess.waitFor();
                if (result != 0) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.CommandReturnCodeError", (Object[])new Object[]{result, mkFifoCmd}));
                }
                String chmodCmd = "chmod 666 " + this.data.fifoFilename;
                this.logDetailed(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.SetPipePermissions", (String[])new String[]{chmodCmd}));
                Process chmodProcess = rt.exec(chmodCmd);
                errorLogger = new StreamLogger(this.log, chmodProcess.getErrorStream(), "chmodError");
                outputLogger = new StreamLogger(this.log, chmodProcess.getInputStream(), "chmodOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                result = chmodProcess.waitFor();
                if (result != 0) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.CommandReturnCodeError", (Object[])new Object[]{result, chmodCmd}));
                }
            }
            this.executeLoadCommand();
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        return true;
    }

    public String createCommandLine() throws KettleException {
        if (StringUtils.isBlank((String)this.meta.getTbuildPath())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.BuildPathNotSet", (String[])new String[0]));
        }
        StringBuilder builder = new StringBuilder();
        try {
            String varfile;
            FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getTbuildPath()));
            String tbuildExec = KettleVFS.getFilename((FileObject)fileObject);
            builder.append(tbuildExec + " ");
            builder.append("-f " + this.tempScriptFile + " ");
            if (!this.meta.getGenerateScript() && (varfile = this.meta.getVariableFile()) != null && !varfile.equals("")) {
                builder.append("-v " + varfile + " ");
            }
            builder.append(this.meta.getJobName());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.ErrorBuildAppString", (String[])new String[0]), (Throwable)e);
        }
        return builder.toString();
    }

    public String[] createEnvironmentVariables() {
        ArrayList<String> varlist = new ArrayList<String>();
        StringBuffer libpath = new StringBuffer();
        varlist.add("TWB_ROOT=" + this.meta.getTwbRoot());
        varlist.add("COPLIB=" + this.meta.getCopLibPath());
        varlist.add("COPERR=" + this.meta.getCopLibPath());
        libpath.append(this.meta.getLibPath() + ":");
        libpath.append(this.meta.getTbuildLibPath() + ":");
        libpath.append(this.meta.getTdicuLibPath() + ":");
        libpath.append(this.meta.getLibPath() + "64:");
        libpath.append(this.meta.getTbuildLibPath() + "64:");
        libpath.append(this.meta.getTdicuLibPath() + "64:");
        varlist.add("LD_LIBRARY_PATH=" + libpath.toString());
        return varlist.toArray(new String[varlist.size()]);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TeraDataBulkLoaderMeta)smi;
        this.data = (TeraDataBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.closeOutput();
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.data.bulkFormatMeta = new ValueMetaInterface[this.data.keynrs.length];
                this.execute(this.meta);
            }
            this.writeRowToBulk(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void closeOutput() throws Exception {
        if (this.data.fifoStream != null) {
            this.data.fifoStream.close();
            this.data.fifoStream = null;
        }
        if (this.data.tbuildThread != null) {
            this.logBasic(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.WaitForTBuild", (String[])new String[]{this.threadWaitTimeText}));
            this.data.tbuildThread.join(this.threadWaitTime);
            TbuildThread tbuildThread = this.data.tbuildThread;
            this.data.tbuildThread = null;
            tbuildThread.checkExcn();
        }
    }

    private void writeRowToBulk(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            block13: for (int i = 0; i < this.data.keynrs.length; ++i) {
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                switch (valueMeta.getType()) {
                    case 2: {
                        this.data.fifoStream.write(TeraDataBulkLoaderRoutines.convertVarchar(valueMeta.getString(valueData)));
                        continue block13;
                    }
                    case 5: {
                        this.data.fifoStream.write(TeraDataBulkLoaderRoutines.convertLong(valueMeta.getInteger(valueData)));
                        continue block13;
                    }
                    case 3: {
                        Date date = valueMeta.getDate(valueData);
                        this.data.fifoStream.write(TeraDataBulkLoaderRoutines.convertDateTime(date));
                        continue block13;
                    }
                    case 4: {
                        Boolean b = valueMeta.getBoolean(valueData);
                        this.data.fifoStream.write(TeraDataBulkLoaderRoutines.convertBoolean(b));
                        continue block13;
                    }
                    case 1: {
                        Double d = valueMeta.getNumber(valueData);
                        this.data.fifoStream.write(TeraDataBulkLoaderRoutines.convertFloat(d));
                        continue block13;
                    }
                    case 6: {
                        BigDecimal bn = valueMeta.getBigNumber(valueData);
                        this.data.fifoStream.write(TeraDataBulkLoaderRoutines.convertBignum(bn));
                        continue block13;
                    }
                    default: {
                        this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.UnsupportedType", (Object[])new Object[]{valueMeta.getType()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.UnsupportedType", (Object[])new Object[]{valueMeta.getType()}));
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.ErrorDuringWrite", (String[])new String[]{this.threadWaitTimeText}));
            }
            catch (Exception loadEx) {
                this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.LoadexError", (Object[])new Object[]{loadEx}));
                throw new KettleException("loadEx Error serializing rows of data to the fifo file 1", (Throwable)loadEx);
            }
            this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.IOError", (String[])new String[0]), e);
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.IOError", (String[])new String[0]), (Throwable)e);
        }
        catch (Exception e2) {
            this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.UnknownError", (String[])new String[0]), e2);
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Exception.UnknownError", (String[])new String[0]), (Throwable)e2);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TeraDataBulkLoaderMeta)smi;
        this.data = (TeraDataBulkLoaderData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TeraDataBulkLoaderMeta)smi;
        this.data = (TeraDataBulkLoaderData)sdi;
        try {
            if (this.data.fifoStream != null) {
                this.data.fifoStream.close();
            }
            if (this.data.db != null) {
                this.data.db.disconnect();
                this.data.db = null;
            }
            try {
                if (this.data.fifoFilename != null) {
                    new File(this.data.fifoFilename).delete();
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.CannotDeletePipe", (String[])new String[]{this.data.fifoFilename}), e);
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoader.Log.CloseConnectionError", (String[])new String[0]), e);
        }
        super.dispose(smi, sdi);
    }

    static class OpenFifo
    extends Thread {
        private DataOutputStream fifoStream = null;
        private Exception ex;
        private String fifoName;
        private int size;

        OpenFifo(String fifoName, int size) {
            this.fifoName = fifoName;
            this.size = size;
        }

        @Override
        public void run() {
            try {
                this.fifoStream = new DataOutputStream(new FileOutputStream(this.fifoName));
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        DataOutputStream getFifoStream() {
            return this.fifoStream;
        }
    }

    static class TbuildThread
    extends Thread {
        private TeraDataBulkLoader parent;
        private String command;
        private String[] environment;
        private Process process;
        private int exitValue;
        private Exception ex;

        TbuildThread(TeraDataBulkLoader parent) throws KettleException {
            this.parent = parent;
            this.command = parent.createCommandLine();
            this.environment = parent.createEnvironmentVariables();
        }

        @Override
        public void run() {
            StringBuilder errors = new StringBuilder();
            this.parent.logBasic(BaseMessages.getString((Class)PKG, (String)"TeraDataBulkLoader.Log.RunCommand", (String[])new String[]{this.command}));
            this.parent.logBasic(BaseMessages.getString((Class)PKG, (String)"TeraDataBulkLoader.Log.Environment", (String[])new String[]{StringUtils.join((Object[])this.environment, (String)":")}));
            try {
                String strLine;
                this.process = Runtime.getRuntime().exec(this.command, this.environment);
                InputStream tbuildOutput = this.process.getInputStream();
                DataInputStream in = new DataInputStream(tbuildOutput);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    this.parent.logDetailed(strLine);
                    if (!strLine.matches("(?i:.*ERROR.*)")) continue;
                    errors.append(strLine + "\n");
                }
                this.exitValue = this.process.waitFor();
                if (this.exitValue > 0) {
                    this.ex = new KettleException(BaseMessages.getString((Class)PKG, (String)"TeraDataBulkLoader.Exception.TBuildProcessError", (Object[])new Object[]{this.exitValue, errors.toString()}));
                }
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }
}

