/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.serial.Zipper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class SerializableTransport
implements Externalizable {
    static final long serialVersionUID = -5634734498572640609L;
    private boolean _isCompressed;
    private Object _transportee;
    private transient Object _original;

    public SerializableTransport() {
    }

    public SerializableTransport(Object transportee, int compressionMode, long minimumSize) {
        this.deflate(transportee, compressionMode, minimumSize);
    }

    public SerializableTransport(Object transportee) {
        this(transportee, 1, 2000L);
    }

    public Object getTransportee() throws IOException, ClassNotFoundException {
        if (this._original == null) {
            if (this._isCompressed) {
                this.inflate();
            } else {
                this._original = this._transportee;
            }
        }
        return this._original;
    }

    private void deflate(Object crs, int compressionMode, long minimumSize) {
        block5: {
            if (compressionMode != 0) {
                try {
                    byte[] serializedObject = SerializableTransport.serializeObject(crs);
                    if ((long)serializedObject.length >= minimumSize) {
                        this._transportee = Zipper.zip(serializedObject, compressionMode);
                        this._isCompressed = true;
                        break block5;
                    }
                    this._transportee = crs;
                    this._isCompressed = false;
                }
                catch (IOException e) {
                    this._transportee = crs;
                    this._isCompressed = false;
                }
            } else {
                this._transportee = crs;
                this._isCompressed = false;
            }
        }
    }

    private void inflate() throws IOException, ClassNotFoundException {
        byte[] unzipped = Zipper.unzip((byte[])this._transportee);
        this._original = SerializableTransport.deserializeObject(unzipped);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._isCompressed = in.readBoolean();
        this._transportee = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._isCompressed);
        out.writeObject(this._transportee);
    }

    private static byte[] serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        return baos.toByteArray();
    }

    private static Object deserializeObject(byte[] b) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }
}

