/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;

public class AttributesMapUtil {
    public static final String NODE_ATTRIBUTE_GROUPS = "ATTRIBUTE_GROUPS";

    public static final void saveAttributesMap(DataNode dataNode, AttributesInterface attributesInterface) throws KettleException {
        AttributesMapUtil.saveAttributesMap(dataNode, attributesInterface, NODE_ATTRIBUTE_GROUPS);
    }

    public static final void saveAttributesMap(DataNode dataNode, AttributesInterface attributesInterface, String attributeGroupsNode) throws KettleException {
        if (attributesInterface != null) {
            Map attributesMap = attributesInterface.getAttributesMap();
            DataNode attributeNodes = dataNode.getNode(attributeGroupsNode);
            if (attributeNodes == null) {
                attributeNodes = dataNode.addNode(attributeGroupsNode);
            }
            for (String groupName : attributesMap.keySet()) {
                DataNode attributeNode = attributeNodes.getNode(groupName);
                if (attributeNode == null) {
                    attributeNode = attributeNodes.addNode(groupName);
                }
                Map attributes = (Map)attributesMap.get(groupName);
                for (Map.Entry entry : attributes.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key == null || value == null) continue;
                    attributeNode.setProperty(key, value);
                }
            }
        }
    }

    public static final void loadAttributesMap(DataNode dataNode, AttributesInterface attributesInterface) throws KettleException {
        AttributesMapUtil.loadAttributesMap(dataNode, attributesInterface, NODE_ATTRIBUTE_GROUPS);
    }

    public static final void loadAttributesMap(DataNode dataNode, AttributesInterface attributesInterface, String attributeGroupsNode) throws KettleException {
        DataNode groupsNode;
        HashMap attributesMap = new HashMap();
        attributesInterface.setAttributesMap(attributesMap);
        if (dataNode != null && (groupsNode = dataNode.getNode(attributeGroupsNode)) != null) {
            for (DataNode groupNode : groupsNode.getNodes()) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributesMap.put(groupNode.getName(), attributes);
                Iterable properties = groupNode.getProperties();
                for (DataProperty dataProperty : properties) {
                    String key = dataProperty.getName();
                    String value = dataProperty.getString();
                    if (key == null || value == null) continue;
                    attributes.put(key, value);
                }
            }
        }
    }
}

