/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import org.pentaho.di.repository.KettleRepositoryLostException;

class UnifiedRepositoryInvocationHandler<T>
implements InvocationHandler {
    private T rep;

    UnifiedRepositoryInvocationHandler(T rep) {
        this.rep = rep;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.rep, args);
        }
        catch (InvocationTargetException ex) {
            if (this.lookupConnectException(ex)) {
                throw new KettleRepositoryLostException(ex.getCause());
            }
            throw ex.getCause();
        }
    }

    private boolean lookupConnectException(Throwable root) {
        while (root != null) {
            if (root instanceof ConnectException) {
                return true;
            }
            root = root.getCause();
        }
        return false;
    }

    public static <T> T forObject(T o, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{clazz}, new UnifiedRepositoryInvocationHandler<T>(o));
    }
}

