/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.pur.PurObjectRevision;
import org.pentaho.di.repository.pur.RootRef;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.VersionSummary;

public class UnifiedRepositoryRevisionService
implements IRevisionService {
    private final IUnifiedRepository unifiedRepository;
    private final RootRef rootRef;

    public UnifiedRepositoryRevisionService(IUnifiedRepository unifiedRepository, RootRef rootRef) {
        this.unifiedRepository = unifiedRepository;
        this.rootRef = rootRef;
    }

    @Override
    public List<ObjectRevision> getRevisions(RepositoryElementInterface element) throws KettleException {
        return this.getRevisions(element.getObjectId());
    }

    @Override
    public List<ObjectRevision> getRevisions(ObjectId fileId) throws KettleException {
        String absPath = null;
        try {
            ArrayList<ObjectRevision> versions = new ArrayList<ObjectRevision>();
            List versionSummaries = this.unifiedRepository.getVersionSummaries((Serializable)((Object)fileId.getId()));
            for (VersionSummary versionSummary : versionSummaries) {
                versions.add(new PurObjectRevision(versionSummary.getId(), versionSummary.getAuthor(), versionSummary.getDate(), versionSummary.getMessage()));
            }
            return versions;
        }
        catch (Exception e) {
            throw new KettleException("Could not retrieve version history of object with path [" + absPath + "]", (Throwable)e);
        }
    }

    @Override
    public void restoreJob(ObjectId id_job, String revision, String versionComment) throws KettleException {
        this.unifiedRepository.restoreFileAtVersion((Serializable)((Object)id_job.getId()), (Serializable)((Object)revision), versionComment);
        this.rootRef.clearRef();
    }

    @Override
    public void restoreTransformation(ObjectId id_transformation, String revision, String versionComment) throws KettleException {
        this.unifiedRepository.restoreFileAtVersion((Serializable)((Object)id_transformation.getId()), (Serializable)((Object)revision), versionComment);
        this.rootRef.clearRef();
    }
}

