/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.platform.api.engine.security.userroledao.UserRoleInfo;
import org.pentaho.platform.security.userrole.ws.IUserRoleListWebService;

public class UserRoleListDelegate
implements Serializable {
    private static final Class PKG = UserRoleListDelegate.class;
    private static final long serialVersionUID = -2895663865550206386L;
    IUserRoleListWebService userDetailsRoleListWebService;
    UserRoleInfo userRoleInfo;
    Log logger;

    public UserRoleListDelegate() {
    }

    public UserRoleListDelegate(PurRepositoryMeta repositoryMeta, IUser userInfo, Log logger, ServiceManager serviceManager) {
        try {
            this.logger = logger;
            this.userDetailsRoleListWebService = serviceManager.createService(userInfo.getLogin(), userInfo.getPassword(), IUserRoleListWebService.class);
            this.updateUserRoleList();
        }
        catch (Exception e) {
            this.logger.error((Object)BaseMessages.getString((Class)PKG, (String)"UserRoleListDelegate.ERROR_0001_UNABLE_TO_INITIALIZE_USER_ROLE_LIST_WEBSVC", (String[])new String[0]), (Throwable)e);
        }
    }

    public List<String> getAllRoles() throws KettleException {
        return this.userRoleInfo.getRoles();
    }

    public List<String> getAllUsers() throws KettleException {
        return this.userRoleInfo.getUsers();
    }

    public void updateUserRoleList() {
        this.userRoleInfo = this.userDetailsRoleListWebService.getUserRoleInfo();
    }

    public IUserRoleListWebService getUserDetailsRoleListWebService() {
        return this.userDetailsRoleListWebService;
    }

    public void setUserDetailsRoleListWebService(IUserRoleListWebService userDetailsRoleListWebService) {
        this.userDetailsRoleListWebService = userDetailsRoleListWebService;
    }

    public UserRoleInfo getUserRoleInfo() {
        return this.userRoleInfo;
    }

    public void setUserRoleInfo(UserRoleInfo userRoleInfo) {
        this.userRoleInfo = userRoleInfo;
    }
}

