/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IAclObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcls;
import org.pentaho.di.ui.repository.pur.services.IAclService;
import org.pentaho.di.ui.repository.repositoryexplorer.AccessDeniedException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIDatabaseConnection;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;

public class UIEEDatabaseConnection
extends UIDatabaseConnection
implements IAclObject {
    private IAclService aclService;
    private Map<RepositoryFilePermission, Boolean> hasAccess = null;

    public UIEEDatabaseConnection() {
    }

    public UIEEDatabaseConnection(DatabaseMeta meta, Repository rep) {
        super(meta, rep);
        this.initializeService(rep);
    }

    private void initializeService(Repository rep) {
        try {
            if (!rep.hasService(IAclService.class)) {
                throw new IllegalStateException();
            }
            this.aclService = (IAclService)rep.getService(IAclService.class);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void getAcls(UIRepositoryObjectAcls acls, boolean forceParentInheriting) throws AccessDeniedException {
        try {
            acls.setObjectAcl(this.aclService.getAcl(this.getDatabaseMeta().getObjectId(), forceParentInheriting));
        }
        catch (KettleException ke) {
            throw new AccessDeniedException((Throwable)ke);
        }
    }

    @Override
    public void getAcls(UIRepositoryObjectAcls acls) throws AccessDeniedException {
        try {
            acls.setObjectAcl(this.aclService.getAcl(this.getDatabaseMeta().getObjectId(), false));
        }
        catch (KettleException ke) {
            throw new AccessDeniedException((Throwable)ke);
        }
    }

    @Override
    public void setAcls(UIRepositoryObjectAcls security) throws AccessDeniedException {
        try {
            this.aclService.setAcl(this.getDatabaseMeta().getObjectId(), security.getObjectAcl());
        }
        catch (KettleException e) {
            throw new AccessDeniedException((Throwable)e);
        }
    }

    @Override
    public void clearAcl() {
        this.hasAccess = null;
    }

    @Override
    public boolean hasAccess(RepositoryFilePermission perm) throws KettleException {
        if (this.hasAccess == null) {
            this.hasAccess = new HashMap<RepositoryFilePermission, Boolean>();
        }
        if (this.hasAccess.get(perm) == null) {
            this.hasAccess.put(perm, new Boolean(this.aclService.hasAccess(this.getDatabaseMeta().getObjectId(), perm)));
        }
        return this.hasAccess.get(perm);
    }
}

