/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import java.util.List;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.ui.database.event.IConnectionAutoBeanFactory;
import org.pentaho.ui.database.event.IDatabaseDialectList;
import org.pentaho.ui.database.event.IDatabaseTypesList;
import org.pentaho.ui.database.services.IXulAsyncDatabaseDialectService;
import org.pentaho.ui.xul.XulServiceCallback;

public class GwtXulAsyncDatabaseDialectService
implements IXulAsyncDatabaseDialectService {
    protected IConnectionAutoBeanFactory connectionAutoBeanFactory = (IConnectionAutoBeanFactory)GWT.create(IConnectionAutoBeanFactory.class);

    private static String getBaseUrl() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "plugin/data-access/api/dialect/";
        }
        if (moduleUrl.indexOf("api") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("api"));
            return baseUrl + "plugin/data-access/api/dialect/";
        }
        return moduleUrl + "plugin/data-access/api/dialect/";
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect, final XulServiceCallback<Void> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.POST, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "registerDatabaseDialect");
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        AutoBean bean = AutoBeanUtils.getAutoBean((Object)databaseDialect);
        String databaseDialectJson = AutoBeanCodex.encode((AutoBean)bean).getPayload();
        try {
            registerDialectRequestBuilder.sendRequest(databaseDialectJson, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    callback.success(null);
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect, boolean validateClassExists, final XulServiceCallback<Void> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.POST, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "registerDatabaseDialectWithValidation/" + Boolean.toString(validateClassExists));
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        AutoBean bean = AutoBeanUtils.getAutoBean((Object)databaseDialect);
        String databaseDialectJson = AutoBeanCodex.encode((AutoBean)bean).getPayload();
        try {
            registerDialectRequestBuilder.sendRequest(databaseDialectJson, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    callback.success(null);
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    @Override
    public void getDialect(IDatabaseType databaseType, final XulServiceCallback<IDatabaseDialect> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.POST, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "getDialectByType");
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        AutoBean bean = AutoBeanUtils.getAutoBean((Object)databaseType);
        String databaseDialectJson = AutoBeanCodex.encode((AutoBean)bean).getPayload();
        try {
            registerDialectRequestBuilder.sendRequest(databaseDialectJson, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    AutoBean databaseDialectBean = AutoBeanCodex.decode((AutoBeanFactory)GwtXulAsyncDatabaseDialectService.this.connectionAutoBeanFactory, IDatabaseDialect.class, (String)response.getText());
                    callback.success(databaseDialectBean.as());
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    @Override
    public void getDialect(IDatabaseConnection connection, final XulServiceCallback<IDatabaseDialect> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.POST, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "getDialectByConnection");
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        AutoBean bean = AutoBeanUtils.getAutoBean((Object)connection);
        String connectionJson = AutoBeanCodex.encode((AutoBean)bean).getPayload();
        try {
            registerDialectRequestBuilder.sendRequest(connectionJson, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    AutoBean databaseDialectBean = AutoBeanCodex.decode((AutoBeanFactory)GwtXulAsyncDatabaseDialectService.this.connectionAutoBeanFactory, IDatabaseDialect.class, (String)response.getText());
                    callback.success(databaseDialectBean.as());
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    @Override
    public void getDatabaseDialects(final XulServiceCallback<List<IDatabaseDialect>> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.GET, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "getDatabaseDialects");
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        try {
            registerDialectRequestBuilder.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    AutoBean databaseDialectBean = AutoBeanCodex.decode((AutoBeanFactory)GwtXulAsyncDatabaseDialectService.this.connectionAutoBeanFactory, IDatabaseDialectList.class, (String)response.getText());
                    callback.success(((IDatabaseDialectList)databaseDialectBean.as()).getDialects());
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    @Override
    public void getDatabaseTypes(final XulServiceCallback<List<IDatabaseType>> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.GET, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "getDatabaseTypes");
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        try {
            registerDialectRequestBuilder.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, final Response response) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            AutoBean databaseTypesBean = AutoBeanCodex.decode((AutoBeanFactory)GwtXulAsyncDatabaseDialectService.this.connectionAutoBeanFactory, IDatabaseTypesList.class, (String)response.getText());
                            callback.success(((IDatabaseTypesList)databaseTypesBean.as()).getDbTypes());
                        }
                    });
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    @Override
    public void validateJdbcDriverClassExists(String classname, final XulServiceCallback<Boolean> callback) {
        RequestBuilder registerDialectRequestBuilder = new RequestBuilder(RequestBuilder.POST, GwtXulAsyncDatabaseDialectService.getBaseUrl() + "validateJdbcDriverClassExists");
        registerDialectRequestBuilder.setHeader("Content-Type", "application/json");
        try {
            registerDialectRequestBuilder.sendRequest(classname, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    callback.success((Object)GwtXulAsyncDatabaseDialectService.parseBoolean(response.getText()));
                }

                public void onError(Request request, Throwable exception) {
                    callback.error("error testing connection: ", exception);
                }
            });
        }
        catch (RequestException e) {
            callback.error("error testing connection: ", (Throwable)e);
        }
    }

    private static final native Boolean parseBoolean(String var0);
}

