/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.inspector;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.baserver.utils.inspector.ParamDefinition;
import org.pentaho.di.baserver.utils.web.Http;
import org.pentaho.di.baserver.utils.web.HttpParameter;

public class Endpoint
implements Comparable<Endpoint> {
    private String id;
    private String path;
    private Http httpMethod;
    private Set<ParamDefinition> paramDefinitions = new HashSet<ParamDefinition>();
    private boolean deprecated;
    private boolean supported;
    private String documentation;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Http getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(Http httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Set<ParamDefinition> getParamDefinitions() {
        return this.paramDefinitions;
    }

    public ParamDefinition getParameterDefinition(String paramName) {
        if (paramName == null) {
            return null;
        }
        return this.paramDefinitions.stream().filter(description -> paramName.equals(description.getName())).findAny().orElse(null);
    }

    public HttpParameter.ParamType getParameterType(String paramName) {
        ParamDefinition paramDefinition = this.getParameterDefinition(paramName);
        return paramDefinition != null ? paramDefinition.getParamType() : null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public void setSupported(boolean supported) {
        this.supported = supported;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String doc) {
        this.documentation = doc;
    }

    @Override
    public int compareTo(Endpoint endpoint) {
        if (this == endpoint) {
            return 0;
        }
        return this.id.compareTo(endpoint.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

