/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.LogUtils;

public abstract class NotificationXCommand
extends XCommand<Void> {
    public static final String NOTIFICATION_URL_CONNECTION_TIMEOUT_KEY = "oozie.notification.url.connection.timeout";
    public static final String NOTIFICATION_PROXY_KEY = "oozie.notification.proxy";
    protected int retries = 0;
    protected String jobId;
    protected String url;
    protected String proxyConf;

    public NotificationXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    @Override
    protected final boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected Void execute() throws CommandException {
        this.sendNotification();
        return null;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.jobId);
    }

    protected Proxy getProxy(String proxyConf) {
        if (proxyConf != null && !proxyConf.trim().equals("") && proxyConf.lastIndexOf(":") != -1) {
            int typeIndex = proxyConf.indexOf("@");
            Proxy.Type proxyType = Proxy.Type.HTTP;
            if (typeIndex != -1 && proxyConf.substring(0, typeIndex).compareToIgnoreCase("socks") == 0) {
                proxyType = Proxy.Type.SOCKS;
            }
            String hostname = proxyConf.substring(typeIndex + 1, proxyConf.lastIndexOf(":"));
            String portConf = proxyConf.substring(proxyConf.lastIndexOf(":") + 1);
            try {
                int port = Integer.parseInt(portConf);
                this.LOG.info("Workflow notification using proxy type \"" + (Object)((Object)proxyType) + "\" hostname \"" + hostname + "\" and port \"" + port + "\"");
                return new Proxy(proxyType, new InetSocketAddress(hostname, port));
            }
            catch (NumberFormatException nfe) {
                this.LOG.warn("Workflow notification couldn't parse configured proxy's port " + portConf + ". Not going to use a proxy");
            }
        }
        return Proxy.NO_PROXY;
    }

    protected void handleRetry() {
        if (this.retries < 3) {
            ++this.retries;
            this.resetUsed();
            this.queue(this, 60000L);
        } else {
            this.LOG.warn(4, "could not send notification [{0}]", this.url);
        }
    }

    protected void sendNotification() {
        if (this.url != null) {
            Proxy proxy = this.getProxy(this.proxyConf);
            try {
                URL url = new URL(this.url);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection(proxy);
                urlConn.setConnectTimeout(this.getTimeOut());
                urlConn.setReadTimeout(this.getTimeOut());
                if (urlConn.getResponseCode() != 200) {
                    this.handleRetry();
                }
            }
            catch (IOException ex) {
                this.handleRetry();
            }
        } else {
            this.LOG.info("No Notification URL is defined. Therefore nothing to notify for job " + this.jobId);
        }
    }

    private int getTimeOut() {
        return ConfigurationService.getInt(NOTIFICATION_URL_CONNECTION_TIMEOUT_KEY);
    }

    public void setRetry(int retries) {
        this.retries = retries;
    }
}

